/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath.ui.internal.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.xml.xpath.ui.internal.Messages;

class XPathViewActions {
    private static final ImageDescriptor COLLAPSE_D = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.wst.xml.xpath.ui", (String)"icons/full/dlcl16/collapseall.gif");
    private static final ImageDescriptor COLLAPSE_E = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.wst.xml.xpath.ui", (String)"icons/full/elcl16/collapseall.gif");
    private static final ImageDescriptor SYNCED_D = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.wst.xml.xpath.ui", (String)"icons/full/dlcl16/synced.gif");
    private static final ImageDescriptor SYNCED_E = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.wst.xml.xpath.ui", (String)"icons/full/elcl16/synced.gif");
    private boolean linkWithEditor = false;
    private CollapseTreeAction collapseAction;
    private ToggleLinkAction toggleAction;

    XPathViewActions() {
    }

    protected IAction[] createMenuContributions(TreeViewer viewer) {
        return new IAction[0];
    }

    protected IAction[] createToolbarContributions(TreeViewer viewer) {
        this.collapseAction = new CollapseTreeAction(viewer);
        this.toggleAction = new ToggleLinkAction();
        this.toggleAction.setChecked(this.isLinkWithEditor());
        return new IAction[]{this.collapseAction, this.toggleAction};
    }

    public ISelection getSelection(TreeViewer viewer, ISelection selection) {
        return selection;
    }

    public boolean isLinkedWithEditor(TreeViewer treeViewer) {
        return this.isLinkWithEditor();
    }

    void setLinkWithEditor(boolean isLinkWithEditor) {
        this.linkWithEditor = isLinkWithEditor;
    }

    void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.collapseAction);
        manager.add((IAction)this.toggleAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    public boolean isLinkWithEditor() {
        return this.linkWithEditor;
    }

    private static class CollapseTreeAction
    extends Action {
        private final TreeViewer fTreeViewer;

        public CollapseTreeAction(TreeViewer viewer) {
            super(Messages.XPathViewActions_0, 1);
            this.setImageDescriptor(COLLAPSE_E);
            this.setDisabledImageDescriptor(COLLAPSE_D);
            this.setToolTipText(this.getText());
            this.fTreeViewer = viewer;
        }

        public void run() {
            this.fTreeViewer.collapseAll();
        }
    }

    private class ToggleLinkAction
    extends Action {
        public ToggleLinkAction() {
            super(Messages.XPathViewActions_1, 2);
            this.setToolTipText(this.getText());
            this.setDisabledImageDescriptor(SYNCED_D);
            this.setImageDescriptor(SYNCED_E);
        }

        public void run() {
            XPathViewActions.this.setLinkWithEditor(this.isChecked());
        }
    }
}

