/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dom;

import org.eclipse.jst.pagedesigner.dom.DOMPositionHelper;
import org.eclipse.jst.pagedesigner.dom.DOMRange;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.DesignRange;
import org.w3c.dom.Node;

public final class DOMRangeHelper {
    public static DOMRange toDOMRange(DesignRange range) {
        if (range.getStartPosition() == range.getEndPosition()) {
            IDOMPosition dp = DOMPositionHelper.toDOMPosition(range.getStartPosition());
            return new DOMRange(dp, dp);
        }
        return new DOMRange(DOMPositionHelper.toDOMPosition(range.getStartPosition()), DOMPositionHelper.toDOMPosition(range.getEndPosition()));
    }

    public static DesignRange toDesignRange(DOMRange range) {
        if (range.getStartPosition() == range.getEndPosition()) {
            DesignPosition dp = DOMPositionHelper.toDesignPosition(range.getStartPosition());
            return new DesignRange(dp, dp);
        }
        return new DesignRange(DOMPositionHelper.toDesignPosition(range.getStartPosition()), DOMPositionHelper.toDesignPosition(range.getEndPosition()));
    }

    public static DOMRange handleReplacement(DOMRange range, Node original, Node replacement) {
        if (range.getStartPosition() == range.getEndPosition()) {
            IDOMPosition pos = range.getStartPosition().handleReplacement(original, replacement);
            return new DOMRange(pos, pos);
        }
        return new DOMRange(range.getStartPosition().handleReplacement(original, replacement), range.getEndPosition().handleReplacement(original, replacement));
    }

    private DOMRangeHelper() {
    }
}

