/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.annotation.validation.tests;

import java.util.ArrayList;
import javax.jws.soap.SOAPBinding;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;
import org.eclipse.jst.ws.jaxws.core.annotation.validation.tests.AbstractSOAPBindingValidationTest;
import org.eclipse.ltk.core.refactoring.Change;

public class SOAPBindingMixedBindingsRuleTest
extends AbstractSOAPBindingValidationTest {
    protected Annotation getAnnotation() {
        ArrayList<MemberValuePair> memberValuePairs = new ArrayList<MemberValuePair>();
        MemberValuePair styleValuePair = AnnotationsCore.createEnumMemberValuePair((AST)this.ast, (String)SOAPBinding.class.getCanonicalName(), (String)"style", (Object)SOAPBinding.Style.DOCUMENT);
        MemberValuePair useValuePair = AnnotationsCore.createEnumMemberValuePair((AST)this.ast, (String)SOAPBinding.class.getCanonicalName(), (String)"use", (Object)SOAPBinding.Use.LITERAL);
        MemberValuePair parameterStyleValuePair = AnnotationsCore.createEnumMemberValuePair((AST)this.ast, (String)SOAPBinding.class.getCanonicalName(), (String)"parameterStyle", (Object)SOAPBinding.ParameterStyle.WRAPPED);
        memberValuePairs.add(styleValuePair);
        memberValuePairs.add(useValuePair);
        memberValuePairs.add(parameterStyleValuePair);
        return AnnotationsCore.createNormalAnnotation((AST)this.ast, (String)SOAPBinding.class.getSimpleName(), memberValuePairs);
    }

    protected String getClassContents() {
        StringBuilder classContents = new StringBuilder("package com.example;\n\n");
        classContents.append("import javax.jws.soap.SOAPBinding;\n\n");
        classContents.append("@SOAPBinding(style=SOAPBinding.Style.RPC, use=SOAPBinding.Use.LITERAL, ");
        classContents.append("parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)\n");
        classContents.append("public class MyClass {\n\n\tpublic String myMethod(String in) {");
        classContents.append("\n\t\treturn \"txt\";\n\t}\n\n}");
        return classContents.toString();
    }

    public void testSOAPBindingMixedBindingsRule() {
        try {
            SOAPBindingMixedBindingsRuleTest.assertNotNull((Object)this.annotation);
            SOAPBindingMixedBindingsRuleTest.assertEquals((String)SOAPBinding.class.getSimpleName(), (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation));
            IMethod method = this.source.findPrimaryType().getMethod("myMethod", new String[]{"QString;"});
            SOAPBindingMixedBindingsRuleTest.assertNotNull((Object)method);
            this.textFileChange.addEdit(AnnotationUtils.createAddImportTextEdit((IJavaElement)method, (String)SOAPBinding.class.getCanonicalName()));
            this.textFileChange.addEdit(AnnotationUtils.createAddAnnotationTextEdit((IJavaElement)method, (Annotation)this.annotation));
            SOAPBindingMixedBindingsRuleTest.assertTrue((boolean)this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)this.textFileChange));
            SOAPBindingMixedBindingsRuleTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)method, (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation)));
            SOAPBindingMixedBindingsRuleTest.assertTrue((boolean)this.source.getImport(SOAPBinding.class.getCanonicalName()).exists());
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
            IMarker[] allmarkers = this.source.getResource().findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            SOAPBindingMixedBindingsRuleTest.assertEquals((int)1, (int)allmarkers.length);
            IMarker annotationProblemMarker = allmarkers[0];
            SOAPBindingMixedBindingsRuleTest.assertEquals((Object)this.source.getResource(), (Object)annotationProblemMarker.getResource());
            SOAPBindingMixedBindingsRuleTest.assertEquals((Object)JAXWSCoreMessages.SOAPBINDING_NO_MIXED_BINDINGS, (Object)annotationProblemMarker.getAttribute("message"));
        }
        catch (CoreException ce) {
            SOAPBindingMixedBindingsRuleTest.fail((String)ce.getLocalizedMessage());
        }
        catch (OperationCanceledException oce) {
            SOAPBindingMixedBindingsRuleTest.fail((String)oce.getLocalizedMessage());
        }
        catch (InterruptedException ie) {
            SOAPBindingMixedBindingsRuleTest.fail((String)ie.getLocalizedMessage());
        }
    }
}

