/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.corext.fix.ControlStatementsFix;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class ControlStatementsCleanUp
extends AbstractCleanUp {
    public ControlStatementsCleanUp(Map options) {
        super(options);
    }

    public ControlStatementsCleanUp() {
    }

    @Override
    public boolean requireAST(IJavaScriptUnit unit) throws CoreException {
        boolean useBlocks = this.isEnabled("cleanup.use_blocks");
        if (!useBlocks) {
            return false;
        }
        return this.isEnabled("cleanup.always_use_blocks") || this.isEnabled("cleanup.never_use_blocks") || this.isEnabled("cleanup.use_blocks_only_for_return_and_throw");
    }

    @Override
    public IFix createFix(JavaScriptUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        boolean useBlocks = this.isEnabled("cleanup.use_blocks");
        if (!useBlocks) {
            return null;
        }
        return ControlStatementsFix.createCleanUp(compilationUnit, this.isEnabled("cleanup.always_use_blocks"), this.isEnabled("cleanup.never_use_blocks"), this.isEnabled("cleanup.use_blocks_only_for_return_and_throw"));
    }

    @Override
    public IFix createFix(JavaScriptUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    @Override
    public Map getRequiredOptions() {
        return null;
    }

    @Override
    public String[] getDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.use_blocks") && this.isEnabled("cleanup.always_use_blocks")) {
            result.add(MultiFixMessages.CodeStyleMultiFix_ConvertSingleStatementInControlBodeyToBlock_description);
        }
        if (this.isEnabled("cleanup.use_blocks") && this.isEnabled("cleanup.never_use_blocks")) {
            result.add(MultiFixMessages.ControlStatementsCleanUp_RemoveUnnecessaryBlocks_description);
        }
        if (this.isEnabled("cleanup.use_blocks") && this.isEnabled("cleanup.use_blocks_only_for_return_and_throw")) {
            result.add(MultiFixMessages.ControlStatementsCleanUp_RemoveUnnecessaryBlocksWithReturnOrThrow_description);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        if (this.isEnabled("cleanup.use_blocks") && this.isEnabled("cleanup.always_use_blocks")) {
            buf.append("if (obj == null) {\n");
            buf.append("    throw ('some exception');\n");
            buf.append("}\n");
            buf.append("if (ids.length > 0) {\n");
            buf.append("    alert(ids[0]);\n");
            buf.append("} else {\n");
            buf.append("    return;\n");
            buf.append("}\n");
        } else if (this.isEnabled("cleanup.use_blocks") && this.isEnabled("cleanup.never_use_blocks")) {
            buf.append("if (obj == null)\n");
            buf.append("    throw ('some exception');\n");
            buf.append("\n");
            buf.append("if (ids.length > 0)\n");
            buf.append("    alert(ids[0]);\n");
            buf.append("else\n");
            buf.append("    return;\n");
            buf.append("\n");
        } else if (this.isEnabled("cleanup.use_blocks") && this.isEnabled("cleanup.use_blocks_only_for_return_and_throw")) {
            buf.append("if (obj == null)\n");
            buf.append("    throw ('some exception');\n");
            buf.append("\n");
            buf.append("if (ids.length > 0) {\n");
            buf.append("    alert(ids[0]);\n");
            buf.append("} else \n");
            buf.append("    return;\n");
            buf.append("\n");
        } else {
            buf.append("if (obj == null) {\n");
            buf.append("    throw ('some exception');\n");
            buf.append("}\n");
            buf.append("if (ids.length > 0) {\n");
            buf.append("    alert(ids[0]);\n");
            buf.append("} else \n");
            buf.append("    return;\n");
            buf.append("\n");
        }
        return buf.toString();
    }

    @Override
    public boolean canFix(JavaScriptUnit compilationUnit, IProblemLocation problem) throws CoreException {
        return false;
    }

    @Override
    public int maximalNumberOfFixes(JavaScriptUnit compilationUnit) {
        return -1;
    }
}

