/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive.operations;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jee.archive.ArchiveException;
import org.eclipse.jst.jee.archive.ArchiveSaveFailureException;
import org.eclipse.jst.jee.archive.internal.ArchiveUtil;
import org.eclipse.wst.common.componentcore.internal.flat.FlatFolder;
import org.eclipse.wst.common.componentcore.internal.flat.FlatVirtualComponent;
import org.eclipse.wst.common.componentcore.internal.flat.IChildModuleReference;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatFile;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatFolder;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatResource;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatVirtualComponent;
import org.eclipse.wst.common.componentcore.internal.flat.IFlattenParticipant;
import org.eclipse.wst.common.componentcore.internal.flat.VirtualComponentFlattenUtility;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class FlatComponentArchiver {
    private IFlatVirtualComponent flatComponent;
    private OutputStream destinationStream;
    private ZipOutputStream zipOutputStream;
    private IVirtualComponent component;
    private List<IFlattenParticipant> participants;
    private ComponentExportCallback callbackHandler;
    private List<IPath> zipEntries = new ArrayList<IPath>();
    private List<IVirtualComponent> componentsArchived = new ArrayList<IVirtualComponent>();

    public FlatComponentArchiver(IVirtualComponent aComponent, OutputStream out, List<IFlattenParticipant> fParticipants) {
        this.participants = fParticipants;
        this.component = aComponent;
        this.destinationStream = out;
        this.zipOutputStream = new ZipOutputStream(out);
        this.flatComponent = this.getFlatComponent(aComponent);
    }

    public FlatComponentArchiver(IVirtualComponent aComponent, OutputStream out, List<IFlattenParticipant> fParticipants, ComponentExportCallback callback) {
        this.participants = fParticipants;
        this.component = aComponent;
        this.destinationStream = out;
        this.callbackHandler = callback;
        this.zipOutputStream = new ZipOutputStream(out);
        this.flatComponent = this.getFlatComponent(aComponent);
    }

    public void close() throws IOException {
        this.getDestinationStream().close();
    }

    public void finish() throws IOException {
        this.getZipOutputStream().finish();
        if (!(this.getDestinationStream() instanceof ZipOutputStream)) {
            this.getDestinationStream().close();
        }
    }

    protected void saveArchive() throws ArchiveSaveFailureException {
        Exception caughtException = null;
        boolean createManifest = true;
        try {
            try {
                if (this.callbackHandler != null && this.callbackHandler.canSave(this.getComponent())) {
                    this.flatComponent = this.callbackHandler.saveComponent(this.getComponent(), this.getZipOutputStream(), this.zipEntries);
                    createManifest = this.callbackHandler.createManifest();
                }
                if (this.flatComponent != null) {
                    IFlatResource[] resources = this.flatComponent.fetchResources();
                    this.saveManifest(Arrays.asList(resources), createManifest);
                    this.saveChildModules(this.flatComponent.getChildModules());
                    this.saveFlatResources(resources);
                }
            }
            catch (Exception e) {
                caughtException = e;
                try {
                    try {
                        this.finish();
                    }
                    catch (IOException e2) {
                        throw new ArchiveSaveFailureException((Throwable)e2);
                    }
                }
                finally {
                    if (caughtException != null) {
                        throw new ArchiveSaveFailureException((Throwable)caughtException);
                    }
                }
            }
        }
        finally {
            try {
                try {
                    this.finish();
                }
                catch (IOException e) {
                    throw new ArchiveSaveFailureException((Throwable)e);
                }
            }
            finally {
                if (caughtException != null) {
                    throw new ArchiveSaveFailureException((Throwable)caughtException);
                }
            }
        }
    }

    protected FlatComponentArchiver saveNestedArchive(IVirtualComponent component, IPath entry) throws IOException {
        ZipEntry nest = new ZipEntry(entry.toString());
        this.getZipOutputStream().putNextEntry(nest);
        return new FlatComponentArchiver(component, this.getZipOutputStream(), this.getParticipants(), this.callbackHandler);
    }

    protected void saveFlatResources(IFlatResource[] resources) throws ArchiveSaveFailureException {
        int i = 0;
        while (i < resources.length) {
            IFlatResource resource = resources[i];
            IPath entryPath = resource.getModuleRelativePath().append(resource.getName());
            if (resource instanceof IFlatFile) {
                if (this.shouldInclude(entryPath, true)) {
                    this.addZipEntry(resource, entryPath);
                    this.zipEntries.add(entryPath);
                }
            } else if (resource instanceof IFlatFolder && this.shouldInclude(entryPath, false)) {
                this.addZipEntry(resource, entryPath);
                this.zipEntries.add(entryPath);
                this.saveFlatResources(((IFlatFolder)resource).members());
            }
            ++i;
        }
    }

    protected boolean shouldInclude(IPath entryPath, boolean isFile) {
        if (this.zipEntries.contains(entryPath)) {
            return false;
        }
        return !(isFile ? entryPath.equals((Object)new Path("META-INF/MANIFEST.MF")) : entryPath.equals((Object)new Path(".settings")));
    }

    protected void saveChildModules(IChildModuleReference[] childModules) throws ArchiveSaveFailureException, IOException {
        this.componentsArchived.add(this.component);
        int i = 0;
        while (i < childModules.length) {
            IChildModuleReference childModule = childModules[i];
            IPath entryPath = childModule.getRelativeURI();
            this.zipEntries.add(entryPath);
            if (!this.componentsArchived.contains(childModule.getComponent())) {
                FlatComponentArchiver saver = this.saveNestedArchive(childModule.getComponent(), entryPath);
                saver.setArchivedComponents(this.componentsArchived);
                saver.saveArchive();
            }
            ++i;
        }
    }

    protected void addZipEntry(IFlatResource f, IPath entryPath) throws ArchiveSaveFailureException {
        try {
            IPath path = entryPath;
            boolean isFolder = false;
            long lastModified = 0L;
            if (f instanceof IFlatFolder) {
                isFolder = true;
                File folder = (File)((IFlatFolder)f).getAdapter(File.class);
                if (folder != null) {
                    lastModified = folder.lastModified();
                }
                if (!path.hasTrailingSeparator()) {
                    path = path.addTrailingSeparator();
                }
            } else {
                lastModified = ((IFlatFile)f).getModificationStamp();
            }
            ZipEntry entry = new ZipEntry(path.toString());
            if (lastModified > 0L) {
                entry.setTime(lastModified);
            }
            this.getZipOutputStream().putNextEntry(entry);
            if (!isFolder) {
                InputStream is = (InputStream)f.getAdapter(InputStream.class);
                if (is == null) {
                    File file = (File)f.getAdapter(File.class);
                    String msg = null;
                    msg = file != null ? "Cannot find the file " + file.getAbsolutePath() + " in the file system. Make sure the file exists and try the operation again" : "Cannot find the file " + f.getModuleRelativePath().append(f.getName()) + " in the file system. Make sure the file exists and try the operation again";
                    throw new UnderlyingFileNotFoundException(msg);
                }
                ArchiveUtil.copy((InputStream)is, (OutputStream)this.getZipOutputStream());
            }
            this.getZipOutputStream().closeEntry();
        }
        catch (IOException e) {
            throw new ArchiveSaveFailureException((Throwable)e);
        }
    }

    protected IFlatVirtualComponent getFlatComponent(IVirtualComponent component) {
        FlatVirtualComponent.FlatComponentTaskModel options = new FlatVirtualComponent.FlatComponentTaskModel();
        options.put((Object)"org.eclipse.wst.common.componentcore.export.participantList", this.getParticipants());
        return new FlatVirtualComponent(component, options);
    }

    protected List<IFlattenParticipant> getParticipants() {
        return this.participants;
    }

    protected ZipOutputStream getZipOutputStream() {
        return this.zipOutputStream;
    }

    private void saveManifest(List<IFlatResource> resources, boolean createManifest) throws ArchiveSaveFailureException {
        FlatFolder metainf = (FlatFolder)VirtualComponentFlattenUtility.getExistingModuleResource(resources, (IPath)new Path("META-INF"));
        IFlatFile manifest = null;
        if (metainf != null) {
            IFlatResource[] children = metainf.members();
            int i = 0;
            while (i < children.length) {
                if (children[i].getName().equals("MANIFEST.MF")) {
                    manifest = (IFlatFile)children[i];
                    IPath entryPath = manifest.getModuleRelativePath().append(manifest.getName());
                    this.addZipEntry((IFlatResource)manifest, entryPath);
                    break;
                }
                ++i;
            }
        }
        if (createManifest && manifest == null) {
            this.createManifest();
        }
    }

    private void createManifest() throws ArchiveSaveFailureException {
        String manifestContents = "Manifest-Version: 1.0\r\n\r\n";
        try {
            ZipEntry entry = new ZipEntry("META-INF/MANIFEST.MF");
            this.getZipOutputStream().putNextEntry(entry);
            ArchiveUtil.copy((InputStream)new ByteArrayInputStream(manifestContents.getBytes()), (OutputStream)this.getZipOutputStream());
        }
        catch (IOException e) {
            throw new ArchiveSaveFailureException((Throwable)e);
        }
    }

    public void setArchivedComponents(List<IVirtualComponent> componentList) {
        this.componentsArchived.addAll(componentList);
    }

    public OutputStream getDestinationStream() {
        return this.destinationStream;
    }

    public IVirtualComponent getComponent() {
        return this.component;
    }

    public IFlatVirtualComponent getFlatComponent() {
        return this.flatComponent;
    }

    public List<IPath> getZipEntries() {
        return this.zipEntries;
    }

    public static interface ComponentExportCallback {
        public boolean canSave(IVirtualComponent var1);

        public IFlatVirtualComponent saveComponent(IVirtualComponent var1, ZipOutputStream var2, List<IPath> var3) throws ArchiveException;

        public boolean createManifest();
    }

    public static class UnderlyingFileNotFoundException
    extends ArchiveSaveFailureException {
        private static final long serialVersionUID = 1L;

        public UnderlyingFileNotFoundException(String message) {
            super(message);
        }
    }
}

