/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import java.util.Set;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.impl.AbstractCreateConnectionFeature;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.ICreateBiDirRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.modelintegration.util.ModelIntegrationUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.AbstractRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.HasReferanceRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;

public abstract class CreateRelationFeature
extends AbstractCreateConnectionFeature {
    protected PersistentType owner;
    protected boolean isDerivedIdFeature;

    public CreateRelationFeature(IJPAEditorFeatureProvider fp, String name, String description, boolean isDerivedIdFeature) {
        super((IFeatureProvider)fp, name, description);
        this.isDerivedIdFeature = isDerivedIdFeature;
    }

    public boolean canCreate(ICreateConnectionContext context) {
        this.owner = this.getPersistentType(context.getSourceAnchor());
        PersistentType inverse = this.getPersistentType(context.getTargetAnchor());
        if (this.owner == null || inverse == null) {
            return false;
        }
        if (JpaArtifactFactory.instance().isMappedSuperclass(inverse) || JpaArtifactFactory.instance().isEmbeddable(inverse)) {
            return false;
        }
        if (JpaArtifactFactory.instance().isEmbeddable(this.owner) && (!this.isRelationshipPossible() || this.isParentEntity(inverse) || JPAEditorUtil.checkJPAFacetVersion(this.owner.getJpaProject(), "1.0"))) {
            return false;
        }
        if (this instanceof ICreateBiDirRelationFeature && JpaArtifactFactory.instance().isMappedSuperclass(this.owner)) {
            return false;
        }
        return !this.isDerivedIdFeature || JpaArtifactFactory.instance().isEntity(this.owner) && JpaArtifactFactory.instance().isEntity(inverse);
    }

    public boolean canStartConnection(ICreateConnectionContext context) {
        this.owner = this.getPersistentType(context.getSourceAnchor());
        return this.owner != null;
    }

    public Connection create(ICreateConnectionContext context) {
        Connection newConnection = null;
        PersistentType owner = this.getPersistentType(context.getSourceAnchor());
        PersistentType inverse = this.getPersistentType(context.getTargetAnchor());
        if (owner != null && inverse != null) {
            if (JpaArtifactFactory.instance().isEmbeddable(owner) && this instanceof ICreateBiDirRelationFeature) {
                Set<HasReferanceRelation> refs = JpaArtifactFactory.instance().findAllHasReferenceRelationsByEmbeddable(owner, this.getFeatureProvider());
                newConnection = this.makeRelation(context, refs.iterator().next().getEmbeddingEntity());
            } else {
                newConnection = this.makeRelation(context, null);
            }
        }
        return newConnection;
    }

    private Connection makeRelation(ICreateConnectionContext context, PersistentType embeddingJPT) {
        AbstractRelation rel = this.createRelation(this.getFeatureProvider(), (PictogramElement)context.getSourceAnchor().getParent(), (PictogramElement)context.getTargetAnchor().getParent(), embeddingJPT);
        AddConnectionContext addContext = new AddConnectionContext(context.getSourceAnchor(), context.getTargetAnchor());
        addContext.setNewObject((Object)rel);
        Connection newConnection = (Connection)this.getFeatureProvider().addIfPossible((IAddContext)addContext);
        return newConnection;
    }

    protected PersistentType getPersistentType(Anchor anchor) {
        Object refObject;
        if (anchor != null && (refObject = this.getBusinessObjectForPictogramElement((PictogramElement)anchor.getParent())) instanceof PersistentType) {
            return (PersistentType)refObject;
        }
        return null;
    }

    protected abstract AbstractRelation createRelation(IJPAEditorFeatureProvider var1, PictogramElement var2, PictogramElement var3, PersistentType var4);

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    protected abstract boolean isRelationshipPossible();

    public void attachedToSource(ICreateConnectionContext context) {
        super.attachedToSource(context);
        this.getFeatureProvider().setOriginalPersistentTypeColor();
        this.disableUnvalidRelationTargets();
    }

    public void endConnecting() {
        super.endConnecting();
        this.getFeatureProvider().setOriginalPersistentTypeColor();
    }

    public void startConnecting() {
        super.startConnecting();
        this.disableAllEmbeddables();
    }

    private void disableUnvalidRelationTargets() {
        Diagram d = this.getDiagram();
        JpaProject project = ModelIntegrationUtil.getProjectByDiagram(d.getName());
        PersistenceUnit unit = (PersistenceUnit)project.getContextRoot().getPersistenceXml().getRoot().getPersistenceUnits().iterator().next();
        if (JpaArtifactFactory.instance().isEntity(this.owner)) {
            this.disableAllJPTsThatAreNotEntities(unit);
        } else if (JpaArtifactFactory.instance().isMappedSuperclass(this.owner)) {
            if (this.isDerivedIdFeature || this instanceof ICreateBiDirRelationFeature) {
                this.disableAllPersistentTypes(unit);
            } else {
                this.disableAllJPTsThatAreNotEntities(unit);
            }
        } else if (JpaArtifactFactory.instance().isEmbeddable(this.owner)) {
            if (this.isDerivedIdFeature || !this.isRelationshipPossible() || JPAEditorUtil.checkJPAFacetVersion(this.owner.getJpaProject(), "1.0")) {
                this.disableAllPersistentTypes(unit);
            } else {
                this.disableAllJPTsThatAreNotEntities(unit);
            }
        }
    }

    private void disableAllJPTsThatAreNotEntities(PersistenceUnit unit) {
        for (ClassRef classRef : unit.getClassRefs()) {
            if (classRef.getJavaPersistentType() == null) continue;
            JavaPersistentType jpt = classRef.getJavaPersistentType();
            if (!JpaArtifactFactory.instance().isEmbeddable((PersistentType)jpt) && !JpaArtifactFactory.instance().isMappedSuperclass((PersistentType)jpt) && !this.isParentEntity((PersistentType)jpt)) continue;
            this.getFeatureProvider().setGrayColor((PersistentType)jpt);
        }
    }

    private void disableAllPersistentTypes(PersistenceUnit unit) {
        for (ClassRef classRef : unit.getClassRefs()) {
            if (classRef.getJavaPersistentType() == null) continue;
            JavaPersistentType jpt = classRef.getJavaPersistentType();
            this.getFeatureProvider().setGrayColor((PersistentType)jpt);
        }
    }

    private void disableAllEmbeddables() {
        Diagram d = this.getDiagram();
        JpaProject project = ModelIntegrationUtil.getProjectByDiagram(d.getName());
        PersistenceUnit unit = (PersistenceUnit)project.getContextRoot().getPersistenceXml().getRoot().getPersistenceUnits().iterator().next();
        boolean isJPA10Project = JPAEditorUtil.checkJPAFacetVersion(ModelIntegrationUtil.getProjectByDiagram(this.getDiagram().getName()), "1.0");
        for (ClassRef classRef : unit.getClassRefs()) {
            if (classRef.getJavaPersistentType() == null) continue;
            JavaPersistentType jpt = classRef.getJavaPersistentType();
            if ((!isJPA10Project || !JpaArtifactFactory.instance().isEmbeddable((PersistentType)jpt)) && (!this.isDerivedIdFeature || JpaArtifactFactory.instance().isEntity((PersistentType)jpt))) continue;
            this.getFeatureProvider().setGrayColor((PersistentType)jpt);
        }
    }

    private boolean isParentEntity(PersistentType jpt) {
        Set<HasReferanceRelation> refs;
        if (JpaArtifactFactory.instance().isEntity(jpt) && !(refs = JpaArtifactFactory.instance().findAllHasReferenceRelationsByEmbeddable(this.owner, this.getFeatureProvider())).isEmpty()) {
            for (HasReferanceRelation ref : refs) {
                if (!ref.getEmbeddingEntity().getName().equals(jpt.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

