/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jpt.common.utility.internal.CharArrayTools;
import org.eclipse.jpt.common.utility.internal.ClassNameTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringBuilderTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.TypeDeclarationTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;

public final class ClassTools {
    public static final Class<?>[] EMPTY_ARRAY = new Class[0];
    public static final Class<?> OBJECT = Object.class;
    public static final Class<?> VOID = Void.TYPE;
    public static final Class<Void> VOID_WRAPPER = Void.class;
    public static final Predicate<Field> FIELD_IS_STATIC = new FieldIsStatic();
    public static final Predicate<Field> FIELD_IS_NOT_STATIC = PredicateTools.not(FIELD_IS_STATIC);
    static final Iterable<Primitive> PRIMITIVES = ClassTools.buildPrimitives();
    public static final char BYTE_CODE = 'B';
    public static final char CHAR_CODE = 'C';
    public static final char DOUBLE_CODE = 'D';
    public static final char FLOAT_CODE = 'F';
    public static final char INT_CODE = 'I';
    public static final char LONG_CODE = 'J';
    public static final char SHORT_CODE = 'S';
    public static final char BOOLEAN_CODE = 'Z';
    public static final char VOID_CODE = 'V';
    static final int MAX_PRIMITIVE_CLASS_NAME_LENGTH = ClassTools.calculateMaxPrimitiveClassNameLength();
    static final int MAX_PRIMITIVE_WRAPPER_CLASS_NAME_LENGTH = ClassTools.calculateMaxPrimitiveWrapperClassNameLength();

    public static Class<?> forName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(className, ex);
        }
    }

    public static Class<?> forName(char[] className) {
        return ClassTools.forName(String.copyValueOf(className));
    }

    public static Class<?> forName_(char[] className) throws ClassNotFoundException {
        return Class.forName(String.copyValueOf(className));
    }

    public static Class<?> forName(String className, boolean initialize, ClassLoader classLoader) {
        try {
            return Class.forName(className, initialize, classLoader);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(className, ex);
        }
    }

    public static Class<?> forName(char[] className, boolean initialize, ClassLoader classLoader) {
        return ClassTools.forName(String.copyValueOf(className), initialize, classLoader);
    }

    public static Class<?> forName_(char[] className, boolean initialize, ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName(String.copyValueOf(className), initialize, classLoader);
    }

    public static String toStringName(Class<?> javaClass) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.appendToStringName(sb, javaClass);
        return sb.toString();
    }

    static void appendToStringNameTo(Class<?> javaClass, StringBuilder sb) {
        if (javaClass.isAnonymousClass()) {
            ClassTools.appendToStringNameTo(javaClass.getSuperclass(), sb);
        } else {
            Class<?> enclosingClass = javaClass.getEnclosingClass();
            if (enclosingClass == null) {
                ClassTools.appendTopLevelToStringNameTo(javaClass, sb);
            } else {
                ClassTools.appendToStringNameTo(enclosingClass, sb);
                sb.append('.');
                sb.append(javaClass.getSimpleName());
            }
        }
    }

    private static void appendTopLevelToStringNameTo(Class<?> javaClass, StringBuilder sb) {
        String fullName = javaClass.getName();
        int dot = fullName.lastIndexOf(46);
        if (dot == -1) {
            sb.append(fullName);
        } else {
            sb.append(fullName, dot + 1, fullName.length());
        }
    }

    public static Iterable<Class<?>> allSuperclasses(Class<?> javaClass) {
        if ((javaClass = javaClass.getSuperclass()) == null) {
            return IterableTools.emptyIterable();
        }
        ArrayList classes = new ArrayList();
        do {
            classes.add(javaClass);
        } while ((javaClass = javaClass.getSuperclass()) != null);
        return classes;
    }

    public static Iterable<Class<?>> allInterfaces(Class<?> javaClass) {
        ArrayList interfaces = new ArrayList();
        Class<?> tempClass = javaClass;
        while (tempClass != null) {
            CollectionTools.addAll(interfaces, tempClass.getInterfaces());
            tempClass = tempClass.getSuperclass();
        }
        return interfaces;
    }

    public static Object get(Class<?> javaClass, String fieldName) {
        try {
            return ClassTools.get_(javaClass, fieldName);
        }
        catch (NoSuchFieldException ex) {
            throw new RuntimeException(ClassTools.buildFieldExceptionMessage(ex, javaClass, fieldName), ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ClassTools.buildFieldExceptionMessage(ex, javaClass, fieldName), ex);
        }
    }

    public static Object get_(Class<?> javaClass, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        return ClassTools.field_(javaClass, fieldName).get(null);
    }

    public static void set(Class<?> javaClass, String fieldName, Object value) {
        try {
            ClassTools.set_(javaClass, fieldName, value);
        }
        catch (NoSuchFieldException ex) {
            throw new RuntimeException(ClassTools.buildFieldExceptionMessage(ex, javaClass, fieldName), ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ClassTools.buildFieldExceptionMessage(ex, javaClass, fieldName), ex);
        }
    }

    public static void set_(Class<?> javaClass, String fieldName, Object value) throws NoSuchFieldException, IllegalAccessException {
        ClassTools.field_(javaClass, fieldName).set(null, value);
    }

    public static Field field(Class<?> javaClass, String fieldName) {
        try {
            return ClassTools.field_(javaClass, fieldName);
        }
        catch (NoSuchFieldException ex) {
            throw new RuntimeException(ClassTools.buildFieldExceptionMessage(ex, javaClass, fieldName), ex);
        }
    }

    public static Field field_(Class<?> javaClass, String fieldName) throws NoSuchFieldException {
        Field field = null;
        try {
            field = javaClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException ex) {
            Class<?> superclass = javaClass.getSuperclass();
            if (superclass == null) {
                throw ex;
            }
            return ClassTools.field_(superclass, fieldName);
        }
        field.setAccessible(true);
        return field;
    }

    public static Iterable<Field> allInstanceFields(Class<?> javaClass) {
        return IterableTools.filter(ClassTools.allFields(javaClass), FIELD_IS_NOT_STATIC);
    }

    public static Iterable<Field> allFields(Class<?> javaClass) {
        ArrayList fields = new ArrayList();
        Class<?> tempClass = javaClass;
        while (tempClass != null) {
            CollectionTools.addAll(fields, ClassTools.declaredFields(tempClass));
            tempClass = tempClass.getSuperclass();
        }
        return ClassTools.makeAccessible(fields);
    }

    public static Iterable<Field> declaredFields(Class<?> javaClass) {
        return ClassTools.makeAccessible(IterableTools.iterable(javaClass.getDeclaredFields()));
    }

    public static Object execute(Class<?> javaClass, String methodName) {
        return ClassTools.execute(javaClass, methodName, EMPTY_ARRAY, ObjectTools.EMPTY_OBJECT_ARRAY);
    }

    public static Object execute_(Class<?> javaClass, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return ClassTools.execute_(javaClass, methodName, EMPTY_ARRAY, ObjectTools.EMPTY_OBJECT_ARRAY);
    }

    public static Object execute(Class<?> javaClass, String methodName, Class<?> parameterType, Object argument) {
        return ClassTools.execute(javaClass, methodName, new Class[]{parameterType}, new Object[]{argument});
    }

    public static Object execute_(Class<?> javaClass, String methodName, Class<?> parameterType, Object argument) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return ClassTools.execute_(javaClass, methodName, new Class[]{parameterType}, new Object[]{argument});
    }

    public static Object execute(Class<?> javaClass, String methodName, Class<?>[] parameterTypes, Object[] arguments) {
        try {
            return ClassTools.execute_(javaClass, methodName, parameterTypes, arguments);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ClassTools.buildMethodExceptionMessage(ex, javaClass, methodName, parameterTypes), ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ClassTools.buildMethodExceptionMessage(ex, javaClass, methodName, parameterTypes), ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ClassTools.buildMethodExceptionMessage(ex, javaClass, methodName, parameterTypes), ex);
        }
    }

    public static Object execute_(Class<?> javaClass, String methodName, Class<?>[] parameterTypes, Object[] arguments) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return ClassTools.staticMethod_(javaClass, methodName, parameterTypes).invoke(null, arguments);
    }

    public static Method method(Class<?> javaClass, String methodName) {
        return ClassTools.method(javaClass, methodName, EMPTY_ARRAY);
    }

    public static Method method_(Class<?> javaClass, String methodName) throws NoSuchMethodException {
        return ClassTools.method_(javaClass, methodName, EMPTY_ARRAY);
    }

    public static Method method(Class<?> javaClass, String methodName, Class<?> parameterType) {
        return ClassTools.method(javaClass, methodName, new Class[]{parameterType});
    }

    public static Method method_(Class<?> javaClass, String methodName, Class<?> parameterType) throws NoSuchMethodException {
        return ClassTools.method_(javaClass, methodName, new Class[]{parameterType});
    }

    public static Method method(Class<?> javaClass, String methodName, Class<?>[] parameterTypes) {
        try {
            return ClassTools.method_(javaClass, methodName, parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ClassTools.buildMethodExceptionMessage(ex, javaClass, methodName, parameterTypes), ex);
        }
    }

    public static Method method_(Class<?> javaClass, String methodName, Class<?>[] parameterTypes) throws NoSuchMethodException {
        Method method = null;
        try {
            method = javaClass.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            Class<?> superclass = javaClass.getSuperclass();
            if (superclass == null) {
                throw ex;
            }
            return ClassTools.method_(superclass, methodName, parameterTypes);
        }
        method.setAccessible(true);
        return method;
    }

    public static Method staticMethod(Class<?> javaClass, String methodName) {
        return ClassTools.staticMethod(javaClass, methodName, EMPTY_ARRAY);
    }

    public static Method staticMethod_(Class<?> javaClass, String methodName) throws NoSuchMethodException {
        return ClassTools.staticMethod_(javaClass, methodName, EMPTY_ARRAY);
    }

    public static Method staticMethod(Class<?> javaClass, String methodName, Class<?> parameterType) {
        return ClassTools.staticMethod(javaClass, methodName, new Class[]{parameterType});
    }

    public static Method staticMethod_(Class<?> javaClass, String methodName, Class<?> parameterType) throws NoSuchMethodException {
        return ClassTools.staticMethod_(javaClass, methodName, new Class[]{parameterType});
    }

    public static Method staticMethod(Class<?> javaClass, String methodName, Class<?>[] parameterTypes) {
        try {
            return ClassTools.staticMethod_(javaClass, methodName, parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ClassTools.buildMethodExceptionMessage(ex, javaClass, methodName, parameterTypes), ex);
        }
    }

    public static Method staticMethod_(Class<?> javaClass, String methodName, Class<?>[] parameterTypes) throws NoSuchMethodException {
        Method method = ClassTools.method_(javaClass, methodName, parameterTypes);
        if (Modifier.isStatic(method.getModifiers())) {
            return method;
        }
        throw new NoSuchMethodException(ClassTools.buildFullyQualifiedMethodSignature(javaClass, methodName, parameterTypes));
    }

    public static Iterable<Method> allMethods(Class<?> javaClass) {
        ArrayList methods = new ArrayList();
        Class<?> tempClass = javaClass;
        while (tempClass != null) {
            CollectionTools.addAll(methods, ClassTools.declaredMethods(tempClass));
            tempClass = tempClass.getSuperclass();
        }
        return ClassTools.makeAccessible(methods);
    }

    public static Iterable<Method> declaredMethods(Class<?> javaClass) {
        return ClassTools.makeAccessible(IterableTools.iterable(javaClass.getDeclaredMethods()));
    }

    public static <T> T newInstance(Class<T> javaClass) {
        return ClassTools.newInstance(javaClass, EMPTY_ARRAY, ObjectTools.EMPTY_OBJECT_ARRAY);
    }

    public static <T> T newInstance_(Class<T> javaClass) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return ClassTools.newInstance_(javaClass, EMPTY_ARRAY, ObjectTools.EMPTY_OBJECT_ARRAY);
    }

    public static <T> T newInstance(Class<T> javaClass, Class<?> parameterType, Object argument) {
        return ClassTools.newInstance(javaClass, new Class[]{parameterType}, argument);
    }

    public static <T> T newInstance_(Class<T> javaClass, Class<?> parameterType, Object argument) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return ClassTools.newInstance_(javaClass, new Class[]{parameterType}, argument);
    }

    public static <T> T newInstance(Class<T> javaClass, Class<?>[] parameterTypes, Object ... arguments) {
        try {
            return ClassTools.newInstance_(javaClass, parameterTypes, arguments);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ClassTools.buildConstructorExceptionMessage(ex, javaClass, parameterTypes), ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ClassTools.buildConstructorExceptionMessage(ex, javaClass, parameterTypes), ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ClassTools.buildConstructorExceptionMessage(ex, javaClass, parameterTypes), ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ClassTools.buildConstructorExceptionMessage(ex, javaClass, parameterTypes), ex);
        }
    }

    public static <T> T newInstance_(Class<T> javaClass, Class<?>[] parameterTypes, Object ... arguments) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return ClassTools.constructor_(javaClass, parameterTypes).newInstance(arguments);
    }

    public static <T> Constructor<T> defaultConstructor(Class<T> javaClass) {
        return ClassTools.constructor(javaClass);
    }

    public static <T> Constructor<T> defaultConstructor_(Class<T> javaClass) throws NoSuchMethodException {
        return ClassTools.constructor_(javaClass);
    }

    public static <T> Constructor<T> constructor(Class<T> javaClass) {
        return ClassTools.constructor(javaClass, EMPTY_ARRAY);
    }

    public static <T> Constructor<T> constructor_(Class<T> javaClass) throws NoSuchMethodException {
        return ClassTools.constructor_(javaClass, EMPTY_ARRAY);
    }

    public static <T> Constructor<T> constructor(Class<T> javaClass, Class<?> parameterType) {
        return ClassTools.constructor(javaClass, new Class[]{parameterType});
    }

    public static <T> Constructor<T> constructor_(Class<T> javaClass, Class<?> parameterType) throws NoSuchMethodException {
        return ClassTools.constructor_(javaClass, new Class[]{parameterType});
    }

    public static <T> Constructor<T> constructor(Class<T> javaClass, Class<?>[] parameterTypes) {
        try {
            return ClassTools.constructor_(javaClass, parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ClassTools.buildConstructorExceptionMessage(ex, javaClass, parameterTypes), ex);
        }
    }

    public static <T> Constructor<T> constructor_(Class<T> javaClass, Class<?>[] parameterTypes) throws NoSuchMethodException {
        Constructor<T> constructor = javaClass.getDeclaredConstructor(parameterTypes);
        constructor.setAccessible(true);
        return constructor;
    }

    public static <T> Iterable<Constructor<T>> declaredConstructors(Class<T> javaClass) {
        Constructor<?>[] constructors = javaClass.getDeclaredConstructors();
        return ClassTools.makeAccessible(IterableTools.iterable(constructors));
    }

    public static int arrayDepth(Class<?> javaClass) {
        int depth = 0;
        while (javaClass.isArray()) {
            ++depth;
            javaClass = javaClass.getComponentType();
        }
        return depth;
    }

    public static Class<?> elementType(Class<?> javaClass) {
        while (javaClass.isArray()) {
            javaClass = javaClass.getComponentType();
        }
        return javaClass;
    }

    public static Class<?> primitiveWrapper(Class<?> primitiveClass) {
        for (Primitive primitive : PRIMITIVES) {
            if (primitive.javaClass != primitiveClass) continue;
            return primitive.wrapperClass;
        }
        return null;
    }

    public static boolean isPrimitiveWrapper(Class<?> javaClass) {
        if (javaClass.isArray() || javaClass.getName().length() > MAX_PRIMITIVE_WRAPPER_CLASS_NAME_LENGTH) {
            return false;
        }
        for (Primitive primitive : PRIMITIVES) {
            if (javaClass != primitive.wrapperClass) continue;
            return true;
        }
        return false;
    }

    public static boolean isVariablePrimitiveWrapper(Class<?> javaClass) {
        return ClassTools.isPrimitiveWrapper(javaClass) && javaClass != VOID_WRAPPER;
    }

    public static boolean isVariablePrimitive(Class<?> javaClass) {
        return javaClass.isPrimitive() && javaClass != VOID;
    }

    public static Class<?> primitiveForCode(int classCode) {
        return ClassTools.primitiveForCode((char)classCode);
    }

    public static Class<?> primitiveForCode(char classCode) {
        for (Primitive primitive : PRIMITIVES) {
            if (primitive.code != classCode) continue;
            return primitive.javaClass;
        }
        return null;
    }

    public static char primitiveCode(Class<?> primitiveClass) {
        if (!primitiveClass.isArray() && primitiveClass.getName().length() <= MAX_PRIMITIVE_CLASS_NAME_LENGTH) {
            for (Primitive primitive : PRIMITIVES) {
                if (primitive.javaClass != primitiveClass) continue;
                return primitive.code;
            }
        }
        return '\u0000';
    }

    private static int calculateMaxPrimitiveClassNameLength() {
        int max = -1;
        for (Primitive primitive : PRIMITIVES) {
            int len = primitive.javaClassName.length;
            if (len <= max) continue;
            max = len;
        }
        return max;
    }

    private static int calculateMaxPrimitiveWrapperClassNameLength() {
        int max = -1;
        for (Primitive primitive : PRIMITIVES) {
            int len = primitive.wrapperClassName.length;
            if (len <= max) continue;
            max = len;
        }
        return max;
    }

    private static Iterable<Primitive> buildPrimitives() {
        Primitive[] array = new Primitive[]{new Primitive('B', Byte.class), new Primitive('C', Character.class), new Primitive('D', Double.class), new Primitive('F', Float.class), new Primitive('I', Integer.class), new Primitive('J', Long.class), new Primitive('S', Short.class), new Primitive('Z', Boolean.class), new Primitive('V', Void.class)};
        return IterableTools.iterable(array);
    }

    public static Class<?> forTypeDeclaration(String typeDeclaration) {
        return ClassTools.forTypeDeclaration(typeDeclaration, null);
    }

    public static Class<?> forTypeDeclaration(char[] typeDeclaration) {
        return ClassTools.forTypeDeclaration(typeDeclaration, null);
    }

    public static Class<?> forTypeDeclaration_(String typeDeclaration) throws ClassNotFoundException {
        return ClassTools.forTypeDeclaration_(typeDeclaration, null);
    }

    public static Class<?> forTypeDeclaration_(char[] typeDeclaration) throws ClassNotFoundException {
        return ClassTools.forTypeDeclaration_(typeDeclaration, null);
    }

    public static Class<?> forTypeDeclaration(String typeDeclaration, ClassLoader classLoader) {
        try {
            return ClassTools.forTypeDeclaration_(typeDeclaration, classLoader);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Class<?> forTypeDeclaration(char[] typeDeclaration, ClassLoader classLoader) {
        try {
            return ClassTools.forTypeDeclaration_(typeDeclaration, classLoader);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Class<?> forTypeDeclaration_(String typeDeclaration, ClassLoader classLoader) throws ClassNotFoundException {
        typeDeclaration = StringTools.removeAllWhitespace(typeDeclaration);
        int arrayDepth = TypeDeclarationTools.arrayDepth_(typeDeclaration);
        String elementTypeName = TypeDeclarationTools.elementTypeName_(typeDeclaration, arrayDepth);
        return ClassTools.forTypeDeclaration_(elementTypeName, arrayDepth, classLoader);
    }

    public static Class<?> forTypeDeclaration_(char[] typeDeclaration, ClassLoader classLoader) throws ClassNotFoundException {
        typeDeclaration = CharArrayTools.removeAllWhitespace(typeDeclaration);
        int arrayDepth = TypeDeclarationTools.arrayDepth_(typeDeclaration);
        char[] elementTypeName = TypeDeclarationTools.elementTypeName_(typeDeclaration, arrayDepth);
        return ClassTools.forTypeDeclaration_(elementTypeName, arrayDepth, classLoader);
    }

    public static Class<?> forTypeDeclaration(String elementTypeName, int arrayDepth) {
        return ClassTools.forTypeDeclaration(elementTypeName, arrayDepth, null);
    }

    public static Class<?> forTypeDeclaration(char[] elementTypeName, int arrayDepth) {
        return ClassTools.forTypeDeclaration(elementTypeName, arrayDepth, null);
    }

    public static Class<?> forTypeDeclaration_(String elementTypeName, int arrayDepth) throws ClassNotFoundException {
        return ClassTools.forTypeDeclaration_(elementTypeName, arrayDepth, null);
    }

    public static Class<?> forTypeDeclaration_(char[] elementTypeName, int arrayDepth) throws ClassNotFoundException {
        return ClassTools.forTypeDeclaration_(elementTypeName, arrayDepth, null);
    }

    public static Class<?> forTypeDeclaration(String elementTypeName, int arrayDepth, ClassLoader classLoader) {
        try {
            return ClassTools.forTypeDeclaration_(elementTypeName, arrayDepth, classLoader);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Class<?> forTypeDeclaration(char[] elementTypeName, int arrayDepth, ClassLoader classLoader) {
        try {
            return ClassTools.forTypeDeclaration_(elementTypeName, arrayDepth, classLoader);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Class<?> forTypeDeclaration_(String elementTypeName, int arrayDepth, ClassLoader classLoader) throws ClassNotFoundException {
        Primitive primitive = null;
        if (elementTypeName.length() <= MAX_PRIMITIVE_CLASS_NAME_LENGTH) {
            for (Primitive p : PRIMITIVES) {
                if (!p.javaClass.getName().equals(elementTypeName)) continue;
                primitive = p;
                break;
            }
        }
        if (arrayDepth == 0) {
            return primitive != null ? primitive.javaClass : Class.forName(elementTypeName, false, classLoader);
        }
        StringBuilder sb = new StringBuilder(100);
        int i = arrayDepth;
        while (i-- > 0) {
            sb.append('[');
        }
        if (primitive != null) {
            sb.append(primitive.code);
        } else {
            ClassNameTools.appendReferenceNameTo(elementTypeName, sb);
        }
        return Class.forName(sb.toString(), false, classLoader);
    }

    public static Class<?> forTypeDeclaration_(char[] elementTypeName, int arrayDepth, ClassLoader classLoader) throws ClassNotFoundException {
        Primitive primitive = null;
        if (elementTypeName.length <= MAX_PRIMITIVE_CLASS_NAME_LENGTH) {
            for (Primitive p : PRIMITIVES) {
                if (!Arrays.equals(p.javaClassName, elementTypeName)) continue;
                primitive = p;
                break;
            }
        }
        if (arrayDepth == 0) {
            return primitive != null ? primitive.javaClass : Class.forName(String.copyValueOf(elementTypeName), false, classLoader);
        }
        StringBuilder sb = new StringBuilder(100);
        int i = arrayDepth;
        while (i-- > 0) {
            sb.append('[');
        }
        if (primitive != null) {
            sb.append(primitive.code);
        } else {
            ClassNameTools.appendReferenceNameTo(elementTypeName, sb);
        }
        return Class.forName(sb.toString(), false, classLoader);
    }

    private static <A extends AccessibleObject> Iterable<A> makeAccessible(Iterable<A> objects) {
        for (AccessibleObject object : objects) {
            object.setAccessible(true);
        }
        return objects;
    }

    static String buildFieldExceptionMessage(Exception ex, Class<?> javaClass, String fieldName) {
        StringBuilder sb = new StringBuilder(200);
        sb.append(ex);
        sb.append(StringTools.CR);
        sb.append(javaClass.getName());
        sb.append('.');
        sb.append(fieldName);
        return sb.toString();
    }

    private static String buildMethodExceptionMessage(Exception ex, Class<?> javaClass, String methodName, Class<?>[] parameterTypes) {
        StringBuilder sb = new StringBuilder(200);
        sb.append(ex);
        sb.append(StringTools.CR);
        ClassTools.appendFullyQualifiedMethodSignature(sb, javaClass, methodName, parameterTypes);
        return sb.toString();
    }

    private static String buildMethodExceptionMessage(InvocationTargetException ex, Class<?> javaClass, String methodName, Class<?>[] parameterTypes) {
        StringBuilder sb = new StringBuilder(200);
        ClassTools.appendFullyQualifiedMethodSignature(sb, javaClass, methodName, parameterTypes);
        sb.append(StringTools.CR);
        sb.append(ex.getTargetException());
        return sb.toString();
    }

    private static String buildFullyQualifiedMethodSignature(Class<?> javaClass, String methodName, Class<?>[] parameterTypes) {
        StringBuilder sb = new StringBuilder(200);
        ClassTools.appendFullyQualifiedMethodSignature(sb, javaClass, methodName, parameterTypes);
        return sb.toString();
    }

    private static void appendFullyQualifiedMethodSignature(StringBuilder sb, Class<?> javaClass, String methodName, Class<?>[] parameterTypes) {
        sb.append(javaClass.getName());
        ClassTools.appendMethodSignature(sb, methodName, parameterTypes);
    }

    public static String buildMethodSignature(String methodName, Class<?>[] parameterTypes) {
        StringBuilder sb = new StringBuilder(200);
        ClassTools.appendMethodSignature_(sb, methodName, parameterTypes);
        return sb.toString();
    }

    private static void appendMethodSignature(StringBuilder sb, String methodName, Class<?>[] parameterTypes) {
        if (methodName != null) {
            sb.append('.');
        }
        ClassTools.appendMethodSignature_(sb, methodName, parameterTypes);
    }

    private static void appendMethodSignature_(StringBuilder sb, String methodName, Class<?>[] parameterTypes) {
        if (methodName != null) {
            sb.append(methodName);
        }
        sb.append('(');
        if (parameterTypes.length > 0) {
            Class<?>[] classArray = parameterTypes;
            int n = parameterTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> parameterType = classArray[n2];
                sb.append(parameterType.getName());
                sb.append(", ");
                ++n2;
            }
            sb.setLength(sb.length() - 2);
        }
        sb.append(')');
    }

    private static String buildConstructorExceptionMessage(Exception ex, Class<?> javaClass, Class<?>[] parameterTypes) {
        return ClassTools.buildMethodExceptionMessage(ex, javaClass, null, parameterTypes);
    }

    private static String buildConstructorExceptionMessage(InvocationTargetException ex, Class<?> javaClass, Class<?>[] parameterTypes) {
        return ClassTools.buildMethodExceptionMessage(ex, javaClass, null, parameterTypes);
    }

    private ClassTools() {
        throw new UnsupportedOperationException();
    }

    public static class FieldIsStatic
    extends PredicateAdapter<Field> {
        @Override
        public boolean evaluate(Field field) {
            return Modifier.isStatic(field.getModifiers());
        }
    }

    static class Primitive {
        final char code;
        final Class<?> javaClass;
        final char[] javaClassName;
        final Class<?> wrapperClass;
        final char[] wrapperClassName;
        private static final String WRAPPER_CLASS_TYPE_FIELD_NAME = "TYPE";

        Primitive(char code, Class<?> wrapperClass) {
            this.code = code;
            this.javaClass = (Class)ClassTools.get(wrapperClass, WRAPPER_CLASS_TYPE_FIELD_NAME);
            this.javaClassName = this.javaClass.getName().toCharArray();
            this.wrapperClass = wrapperClass;
            this.wrapperClassName = wrapperClass.getName().toCharArray();
        }
    }
}

