/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.core.internal.validation.eclipse;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.wst.xsd.core.internal.validation.eclipse.XSDMessageInfoHelperWrapper;

public class XSDMessageInfoHelperTest
extends TestCase {
    private XSDMessageInfoHelperWrapper helper = new XSDMessageInfoHelperWrapper();

    public static Test suite() {
        return new TestSuite(XSDMessageInfoHelperTest.class);
    }

    public void testNotExistantKeyAndNullMessageArguments() {
        String[] messageInfo = this.helper.createMessageInfo("NON_EXISTANT_KEY", null);
        XSDMessageInfoHelperTest.assertEquals((String)"The selection strategy returned was not an empty string.", (String)"", (String)messageInfo[0]);
        XSDMessageInfoHelperTest.assertEquals((String)"The nameOrValue returned was not an empty string.", (String)"", (String)messageInfo[1]);
    }

    public void testNullKeyAndMessageArguments() {
        String[] messageInfo = this.helper.createMessageInfo(null, null);
        XSDMessageInfoHelperTest.assertEquals((String)"The selection strategy returned was not an empty string.", (String)"", (String)messageInfo[0]);
        XSDMessageInfoHelperTest.assertEquals((String)"The nameOrValue returned was not an empty string.", (String)"", (String)messageInfo[1]);
    }

    public void testGetFirstStringBetweenSingleQuotes() {
        String result = this.helper.getFirstStringBetweenSingleQuotes("'name'");
        XSDMessageInfoHelperTest.assertEquals((String)"The returned string was not \"name\" for the string \"'name'\".", (String)"name", (String)result);
        result = this.helper.getFirstStringBetweenSingleQuotes("name");
        XSDMessageInfoHelperTest.assertNull((String)"The returned string was not null for the string \"name\" with no single quotes.", (Object)result);
        result = this.helper.getFirstStringBetweenSingleQuotes("'name");
        XSDMessageInfoHelperTest.assertNull((String)"The returned string was not null for the string \"'name\" with one single quote.", (Object)result);
        result = this.helper.getFirstStringBetweenSingleQuotes("'name'name2'");
        XSDMessageInfoHelperTest.assertEquals((String)"The returned string was not \"name\" for the string \"'name'name2'\" with 3 single quotes.", (String)"name", (String)result);
    }
}

