/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.launching.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.wst.xsl.launching.model.IXSLDebugTarget;
import org.eclipse.wst.xsl.launching.model.XSLDebugElement;

public class XSLThread
extends XSLDebugElement
implements IThread {
    private IBreakpoint[] fBreakpoints;
    private boolean fStepping = false;

    public XSLThread(IDebugTarget target) {
        super(target);
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        if (this.isSuspended()) {
            return ((IXSLDebugTarget)this.getDebugTarget()).getStackFrames();
        }
        return new IStackFrame[0];
    }

    public boolean hasStackFrames() throws DebugException {
        return this.isSuspended();
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        IStackFrame[] frames = this.getStackFrames();
        if (frames.length > 0) {
            return frames[0];
        }
        return null;
    }

    public String getName() throws DebugException {
        return "Thread[1]";
    }

    public IBreakpoint[] getBreakpoints() {
        if (this.fBreakpoints == null) {
            return new IBreakpoint[0];
        }
        return this.fBreakpoints;
    }

    public void setBreakpoints(IBreakpoint[] breakpoints) {
        this.fBreakpoints = breakpoints;
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.getDebugTarget().isSuspended();
    }

    public void resume() throws DebugException {
        this.getDebugTarget().resume();
    }

    public void suspend() throws DebugException {
        this.getDebugTarget().suspend();
    }

    public boolean canStepInto() {
        return this.isSuspended();
    }

    public boolean canStepOver() {
        return this.isSuspended();
    }

    public boolean canStepReturn() {
        return this.isSuspended();
    }

    public boolean isStepping() {
        return this.fStepping;
    }

    public void stepInto() throws DebugException {
        ((IXSLDebugTarget)this.getDebugTarget()).stepInto();
    }

    public void stepOver() throws DebugException {
        ((IXSLDebugTarget)this.getDebugTarget()).stepOver();
    }

    public void stepReturn() throws DebugException {
        ((IXSLDebugTarget)this.getDebugTarget()).stepReturn();
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    public void setStepping(boolean stepping) {
        this.fStepping = stepping;
    }
}

