/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.eclipse.wst.xml.xpath2.processor.internal.types.builtin.BuiltinTypeLibrary;

public class XSNormalizedString
extends XSString {
    private static final String XS_NORMALIZEDSTRING = "xs:normalizedString";

    public XSNormalizedString(String x) {
        super(x);
    }

    public XSNormalizedString() {
        this(null);
    }

    public String string_type() {
        return XS_NORMALIZEDSTRING;
    }

    public String type_name() {
        return "normalizedString";
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        Item aat = arg.first();
        String srcString = aat.getStringValue();
        if (!this.isSatisfiesConstraints(srcString)) {
            DynamicError.throw_type_error();
        }
        return new XSNormalizedString(srcString);
    }

    protected boolean isSatisfiesConstraints(String srcString) {
        boolean isNormalizedStr = true;
        if (srcString.indexOf("\r") != -1 || srcString.indexOf("\n") != -1 || srcString.indexOf("\t") != -1) {
            isNormalizedStr = false;
        }
        return isNormalizedStr;
    }

    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_NORMALIZEDSTRING;
    }
}

