/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.contentassist.resources;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.html.core.internal.validate.ModuleCoreSupport;
import org.eclipse.wst.html.ui.internal.HTMLUIPlugin;
import org.eclipse.wst.html.ui.internal.Logger;
import org.eclipse.wst.html.ui.internal.contentassist.resources.ContentTypeSpecs;
import org.eclipse.wst.html.ui.internal.wizard.FacetModuleCoreSupport;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.xml.core.internal.parser.regions.AttributeNameRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.eclipse.wst.xml.ui.internal.contentassist.DefaultXMLCompletionProposalComputer;

public abstract class AbstractWebResourcesCompletionProposalComputer
extends DefaultXMLCompletionProposalComputer {
    private Job completionComputerJob;
    protected Set<Image> images = new HashSet<Image>();

    protected void addAttributeValueProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        IFile file;
        IDOMNode element = (IDOMNode)contentAssistRequest.getNode();
        Path referencePath = new Path(element.getModel().getBaseLocation());
        if (referencePath.segmentCount() > 1 && (file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)referencePath)).exists() && this.matchRequest(contentAssistRequest)) {
            String matchString = contentAssistRequest.getMatchString();
            if ((matchString = StringUtils.stripQuotes((String)matchString)).length() > 0 && (matchString.startsWith("\"") || matchString.startsWith("'"))) {
                matchString = matchString.substring(1);
            }
            IPath runtimeReferencePath = ModuleCoreSupport.getRuntimePath((IPath)referencePath).removeLastSegments(1).makeAbsolute();
            IPath[] iPathArray = this.findMatchingPaths((IResource)file);
            int n = iPathArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPath path = iPathArray[n2];
                if (!referencePath.equals((Object)path)) {
                    String proposalText = null;
                    try {
                        IPath runtimeProposalPath = ModuleCoreSupport.getRuntimePath((IPath)path);
                        if (runtimeProposalPath != null && runtimeReferencePath != null) {
                            proposalText = runtimeProposalPath.makeRelativeTo(runtimeReferencePath).toString();
                        }
                        if (proposalText == null) {
                            proposalText = runtimeProposalPath.makeRelativeTo(referencePath.removeLastSegments(1)).toString();
                        }
                        if (proposalText.startsWith(matchString)) {
                            contentAssistRequest.addProposal(this.createCompletionProposal(contentAssistRequest, (IPath)referencePath, runtimeReferencePath, path, runtimeProposalPath, proposalText));
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        Logger.logException(ex);
                    }
                }
                ++n2;
            }
        }
    }

    protected ICompletionProposal createCompletionProposal(ContentAssistRequest request, IPath referencePath, IPath runtimeReferencePath, IPath proposalPath, IPath runtimeProposalPath, String relativeProposal) {
        String replacementString = String.valueOf('\"') + relativeProposal + '\"';
        int cursorPosition = replacementString.length();
        Image image = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(referencePath.lastSegment()).createImage();
        if (image != null) {
            this.images.add(image);
        }
        int replacementLength = request.getRegion().getTextLength();
        int replacementOffset = request.getStartOffset();
        return new CustomCompletionProposal(replacementString, replacementOffset, replacementLength, cursorPosition, image, relativeProposal, null, proposalPath.toString(), 0);
    }

    protected IPath[] findMatchingPaths(IResource referenceResource) {
        final ContentTypeSpecs fileMatcher = this.createFilenameMatcher();
        final ArrayList res = new ArrayList();
        IWorkspaceRoot root = referenceResource.getWorkspace().getRoot();
        IPath referencePath = referenceResource.getFullPath();
        IPath[] roots = FacetModuleCoreSupport.getAcceptableRootPaths(referenceResource.getProject());
        boolean referencePathWithinValidRoot = false;
        int i = 0;
        while (i < roots.length) {
            referencePathWithinValidRoot |= roots[i].isPrefixOf(referencePath);
            ++i;
        }
        if (!referencePathWithinValidRoot) {
            roots = new IPath[]{referenceResource.getProject().getFullPath()};
        }
        i = 0;
        while (i < roots.length) {
            try {
                root.findMember(roots[i]).accept(new IResourceProxyVisitor(){

                    public boolean visit(IResourceProxy proxy) throws CoreException {
                        if (proxy.getType() == 1 && fileMatcher.matches(proxy.getName())) {
                            res.add(proxy.requestFullPath());
                        }
                        return !proxy.isDerived();
                    }
                }, 0);
            }
            catch (CoreException ex) {
                HTMLUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wst.html.ui", ex.getMessage(), (Throwable)ex));
            }
            ++i;
        }
        return res.toArray(new IPath[res.size()]);
    }

    abstract boolean matchRequest(ContentAssistRequest var1);

    abstract ContentTypeSpecs createFilenameMatcher();

    public void sessionEnded() {
        if (this.completionComputerJob != null) {
            this.completionComputerJob.cancel();
        }
        for (Image image : this.images) {
            image.dispose();
        }
        super.sessionEnded();
    }

    protected String getCurrentAttributeName(ContentAssistRequest contentAssistRequest) {
        String attributeName = null;
        ITextRegion[] iTextRegionArray = contentAssistRequest.getDocumentRegion().getRegions().toArray();
        int n = iTextRegionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITextRegion childRegion = iTextRegionArray[n2];
            if (childRegion instanceof AttributeNameRegion) {
                attributeName = contentAssistRequest.getDocumentRegion().getText(childRegion);
            } else if (childRegion.equals(contentAssistRequest.getRegion())) break;
            ++n2;
        }
        return attributeName;
    }
}

