/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.ui.internal;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.server.generic.core.internal.GenericServer;
import org.eclipse.jst.server.generic.core.internal.GenericServerRuntime;
import org.eclipse.jst.server.generic.servertype.definition.ServerRuntime;
import org.eclipse.jst.server.generic.ui.internal.GenericServerComposite;
import org.eclipse.jst.server.generic.ui.internal.GenericServerCompositeDecorator;
import org.eclipse.jst.server.generic.ui.internal.GenericServerUIMessages;
import org.eclipse.jst.server.generic.ui.internal.ServerDefinitionTypeAwareWizardFragment;
import org.eclipse.jst.server.generic.ui.internal.ServerTypeDefinitionServerDecorator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class GenericServerWizardFragment
extends ServerDefinitionTypeAwareWizardFragment {
    private GenericServerCompositeDecorator[] fDecorators;

    public boolean isComplete() {
        ServerRuntime serverRuntime = this.getServerTypeDefinitionFor(this.getServer());
        if (serverRuntime == null) {
            return false;
        }
        IServerWorkingCopy server = this.getServer();
        GenericServer dl = (GenericServer)server.loadAdapter(GenericServer.class, null);
        IStatus status = dl.validate();
        return status != null && status.isOK();
    }

    @Override
    public void createContent(Composite parent, IWizardHandle handle) {
        IServerWorkingCopy server = this.getServer();
        GenericServer dl = (GenericServer)server.loadAdapter(GenericServer.class, null);
        ServerRuntime definition = this.getServerTypeDefinitionFor(server);
        this.fDecorators = new GenericServerCompositeDecorator[1];
        this.fDecorators[0] = new ServerTypeDefinitionServerDecorator(definition, null, this.getWizard(), dl);
        new GenericServerComposite(parent, this.fDecorators);
    }

    private ServerRuntime getServerTypeDefinitionFor(IServerWorkingCopy server) {
        IRuntime wc;
        GenericServerRuntime runtime = (GenericServerRuntime)server.getRuntime().getAdapter(GenericServerRuntime.class);
        if (runtime == null && (runtime = (GenericServerRuntime)(wc = (IRuntime)this.getTaskModel().getObject("runtime")).getAdapter(GenericServerRuntime.class)) == null) {
            runtime = (GenericServerRuntime)wc.loadAdapter(GenericServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
        }
        String serverTyepId = server.getServerType().getId();
        String runtimeTypeId = runtime.getRuntime().getRuntimeType().getId();
        if (runtimeTypeId == null) {
            return null;
        }
        Map runtimeProperties = runtime.getServerInstanceProperties();
        ServerRuntime definition = this.getServerTypeDefinition(serverTyepId, runtimeTypeId, runtimeProperties);
        return definition;
    }

    private IServerWorkingCopy getServer() {
        IServerWorkingCopy server = (IServerWorkingCopy)this.getTaskModel().getObject("server");
        return server;
    }

    public void enter() {
        if (this.fDecorators == null) {
            return;
        }
        int i = 0;
        while (i < this.fDecorators.length) {
            if (this.fDecorators[i].validate()) {
                return;
            }
            ++i;
        }
    }

    public void exit() {
        if (this.fDecorators == null) {
            return;
        }
        int i = 0;
        while (i < this.fDecorators.length) {
            if (this.fDecorators[i].validate()) {
                return;
            }
            ++i;
        }
    }

    @Override
    public String description() {
        String sName = this.getServerName();
        if (sName == null || sName.length() < 1) {
            sName = "Generic";
        }
        return NLS.bind((String)GenericServerUIMessages.serverWizardDescription, (Object)sName);
    }

    private String getServerName() {
        if (this.getServer() != null && this.getServer().getRuntime() != null) {
            return this.getServer().getRuntime().getRuntimeType().getName();
        }
        return null;
    }

    @Override
    public String title() {
        String sName = this.getServerName();
        if (sName == null || sName.length() < 1) {
            sName = "Generic";
        }
        return NLS.bind((String)GenericServerUIMessages.serverWizardTitle, (Object)sName);
    }
}

