/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.model;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.core.tests.util.FileUtil;
import org.eclipse.wst.xml.core.tests.util.ProjectUnzipUtility;

public class TestStructuredModel
extends TestCase {
    private boolean isSetup = false;
    private final String fProjectName = "DOCUMENT-LOADER";
    private final String fZipFileName = "xml-document-loader-tests.zip";

    public TestStructuredModel() {
        super("TestStructuredModel");
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (!this.isSetup) {
            this.doSetup();
            this.isSetup = true;
        }
    }

    private void doSetup() throws Exception {
        Location platformLocation = Platform.getInstanceLocation();
        ProjectUnzipUtility unzipUtil = new ProjectUnzipUtility();
        File zipFile = FileUtil.makeFileFor("projecttestfiles", "xml-document-loader-tests.zip", "projecttestfiles");
        unzipUtil.unzipAndImport(zipFile, platformLocation.getURL().getFile());
        unzipUtil.initJavaProject("DOCUMENT-LOADER");
    }

    public void testAboutToChangeModel() throws IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        try {
            model.aboutToChangeModel();
            TestStructuredModel.assertTrue((boolean)true);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testAddRemoveModelStateListener() throws IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        try {
            IModelStateListener listener = new IModelStateListener(){

                public void modelAboutToBeChanged(IStructuredModel model) {
                }

                public void modelChanged(IStructuredModel model) {
                }

                public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
                }

                public void modelResourceDeleted(IStructuredModel model) {
                }

                public void modelResourceMoved(IStructuredModel oldModel, IStructuredModel newModel) {
                }

                public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
                }

                public void modelReinitialized(IStructuredModel structuredModel) {
                }
            };
            model.aboutToChangeModel();
            model.removeModelStateListener(listener);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testChangedModel() throws IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        try {
            try {
                model.changedModel();
            }
            catch (Exception e) {
                TestStructuredModel.assertTrue((boolean)(e instanceof IllegalStateException));
            }
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testGetContentType() throws IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        try {
            String ct = model.getContentTypeIdentifier();
            TestStructuredModel.assertTrue((String)("model has wrong content type:" + ct + " != " + ContentTypeIdForXML.ContentTypeID_XML), (boolean)ct.equals(ContentTypeIdForXML.ContentTypeID_XML));
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testGetBaseLocation() throws IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        try {
            String location = model.getBaseLocation();
            TestStructuredModel.assertTrue((String)"wrong base location", (boolean)location.equals("/DOCUMENT-LOADER/files/simple.xml"));
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testGetFactoryRegistry() throws IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        try {
            model.getFactoryRegistry();
            TestStructuredModel.assertTrue((boolean)true);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testGetIndexedRegion() throws IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        try {
            model.getIndexedRegion(0);
            TestStructuredModel.assertTrue((boolean)true);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testGetIndexedRegions() throws IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        if (model != null) {
            model.releaseFromEdit();
        }
    }

    public void testGetStructuredDocument() throws IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        try {
            IStructuredDocument doc = model.getStructuredDocument();
            TestStructuredModel.assertNotNull((String)"document is null", (Object)doc);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testIsDirty() throws IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        try {
            TestStructuredModel.assertFalse((String)"model should not be dirty", (boolean)model.isDirty());
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testIsModelStateChanging() throws IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        try {
            TestStructuredModel.assertFalse((String)"model should not be changing", (boolean)model.isModelStateChanging());
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testIsNew() throws IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        if (model != null) {
            model.releaseFromEdit();
        }
    }

    public void testIsReinitializationNeeded() throws IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        try {
            TestStructuredModel.assertFalse((String)"reinitialization should not be needed", (boolean)model.isReinitializationNeeded());
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testIsSaveNeeded() throws IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        try {
            TestStructuredModel.assertFalse((String)"save should not be needed", (boolean)model.isSaveNeeded());
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testNewInstance() throws IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        try {
            IStructuredModel newInstance = null;
            try {
                newInstance = model.newInstance();
            }
            catch (IOException iOException) {
                TestStructuredModel.assertTrue((String)"IOException during model new instance", (boolean)false);
            }
            TestStructuredModel.assertNotNull((String)"new instance is null", (Object)newInstance);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testGetModelResource() throws IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        IResource resource = (IResource)model.getAdapter(IResource.class);
        TestStructuredModel.assertNotNull((String)"A resource wasn't obtained from the model", (Object)resource);
        TestStructuredModel.assertEquals((String)"The resource doesn't correspond to the model's base location", (Object)new Path("/DOCUMENT-LOADER/files/simple.xml"), (Object)resource.getFullPath());
    }

    public void testUnmanagedModelResource() throws IOException, CoreException {
        IStructuredModel model = StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        IResource resource = (IResource)model.getAdapter(IResource.class);
        TestStructuredModel.assertNull((String)"A resource was obtained from an unmanaged model", (Object)resource);
    }

    public void testGetNodeResource() throws IOException, CoreException {
        IStructuredModel model = this.getTestModel();
        IndexedRegion region = model.getIndexedRegion(0);
        TestStructuredModel.assertTrue((String)"The region is not adaptable", (boolean)(region instanceof IAdaptable));
        IResource resource = (IResource)((IAdaptable)region).getAdapter(IResource.class);
        TestStructuredModel.assertNotNull((String)"A resource wasn't obtained from the model", (Object)resource);
        TestStructuredModel.assertEquals((String)"The resource doesn't correspond to the model's base location", (Object)new Path("/DOCUMENT-LOADER/files/simple.xml"), (Object)resource.getFullPath());
    }

    IStructuredModel getTestModel() throws IOException, CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("DOCUMENT-LOADER");
        IFile iFile = (IFile)project.findMember("/files/simple.xml");
        IStructuredModel model = null;
        IModelManager modelManager = StructuredModelManager.getModelManager();
        model = modelManager.getModelForEdit(iFile);
        return model;
    }
}

