/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.tests.format;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.formatter.FormattingContext;
import org.eclipse.jface.text.formatter.IContentFormatterExtension;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.jsdt.web.ui.tests.internal.ProjectUtil;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.ExtendedConfigurationBuilder;

public class TestJSPContentFormatter
extends TestCase {
    String wtp_autotest_noninteractive = null;
    private static final String PROJECT_NAME = "jsdtjspformatting";
    private static final String UTF_8 = "UTF-8";
    private IFormattingContext fContext;

    public static Test suite() {
        TestSuite ts = new TestSuite(TestJSPContentFormatter.class);
        return ts;
    }

    protected void setUp() throws Exception {
        super.setUp();
        String noninteractive = System.getProperty("wtp.autotest.noninteractive");
        if (noninteractive != null) {
            this.wtp_autotest_noninteractive = noninteractive;
        }
        System.setProperty("wtp.autotest.noninteractive", "true");
        if (!ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME).exists()) {
            ProjectUtil.createProject(PROJECT_NAME, null, new String[]{"org.eclipse.wst.jsdt.core.jsNature"});
            ProjectUtil.copyBundleEntriesIntoWorkspace("/testFiles/jsdtjspformatting", "/jsdtjspformatting");
        }
        TestJSPContentFormatter.assertTrue((String)"project could not be created", (boolean)ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME).exists());
        this.fContext = new FormattingContext();
        this.fContext.setProperty((Object)"formatting.context.document", (Object)true);
    }

    private void formatAndAssertEquals(String beforePath, String afterPath, boolean resetPreferences) throws UnsupportedEncodingException, IOException, CoreException {
        IStructuredModel beforeModel = null;
        IStructuredModel afterModel = null;
        try {
            beforeModel = this.getModelForEdit(beforePath);
            TestJSPContentFormatter.assertNotNull((String)("could not retrieve structured model for : " + beforePath), (Object)beforeModel);
            afterModel = this.getModelForEdit(afterPath);
            TestJSPContentFormatter.assertNotNull((String)("could not retrieve structured model for : " + afterPath), (Object)afterModel);
            if (resetPreferences) {
                this.resetPreferencesToDefault();
            }
            SourceViewerConfiguration configuration = (SourceViewerConfiguration)ExtendedConfigurationBuilder.getInstance().getConfiguration("sourceViewerConfiguration", "org.eclipse.jst.jsp.core.jspsource");
            IContentFormatterExtension formatter = (IContentFormatterExtension)configuration.getContentFormatter(null);
            IStructuredDocument document = beforeModel.getStructuredDocument();
            Region region = new Region(0, document.getLength());
            this.fContext.setProperty((Object)"formatting.context.region", (Object)region);
            formatter.format((IDocument)document, this.fContext);
            ByteArrayOutputStream formattedBytes = new ByteArrayOutputStream();
            beforeModel.save((OutputStream)formattedBytes);
            ByteArrayOutputStream afterBytes = new ByteArrayOutputStream();
            afterModel.save((OutputStream)afterBytes);
            String expectedContents = new String(afterBytes.toByteArray(), UTF_8);
            expectedContents = StringUtils.replace((String)expectedContents, (String)"\r\n", (String)"\r");
            expectedContents = StringUtils.replace((String)expectedContents, (String)"\r", (String)"\n");
            String actualContents = new String(formattedBytes.toByteArray(), UTF_8);
            actualContents = StringUtils.replace((String)actualContents, (String)"\r\n", (String)"\r");
            actualContents = StringUtils.replace((String)actualContents, (String)"\r", (String)"\n");
            TestJSPContentFormatter.assertTrue((boolean)this.onlyWhiteSpaceDiffers(expectedContents, actualContents));
            TestJSPContentFormatter.assertEquals((String)"Formatted document differs from the expected.", (String)expectedContents, (String)actualContents);
        }
        finally {
            if (beforeModel != null) {
                beforeModel.releaseFromEdit();
            }
            if (afterModel != null) {
                afterModel.releaseFromEdit();
            }
        }
    }

    private void formatAndAssertSignificantEquals(String beforePath, boolean resetPreferences) throws UnsupportedEncodingException, IOException, CoreException {
        StructuredTextEditor editor = (StructuredTextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(beforePath)), (String)"org.eclipse.jst.jsp.core.jspsource.source", (boolean)true);
        try {
            String before = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).get();
            editor.getTextViewer().doOperation(23);
            String after = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).get();
            TestJSPContentFormatter.assertTrue((boolean)this.onlyWhiteSpaceDiffers(before, after));
        }
        finally {
            editor.close(false);
        }
    }

    private IStructuredModel getModelForEdit(String filename) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filename));
        TestJSPContentFormatter.assertTrue((String)("unable to find file: " + filename), (boolean)file.exists());
        IStructuredModel model = null;
        try {
            IModelManager modelManager = StructuredModelManager.getModelManager();
            model = modelManager.getModelForEdit(file);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        return model;
    }

    private boolean onlyWhiteSpaceDiffers(String expectedContents, String actualContents) {
        CharArrayWriter writer1 = new CharArrayWriter();
        char[] expected = expectedContents.toCharArray();
        int i = 0;
        while (i < expected.length) {
            if (!Character.isWhitespace(expected[i])) {
                writer1.write(expected[i]);
            }
            ++i;
        }
        CharArrayWriter writer2 = new CharArrayWriter();
        char[] actual = actualContents.toCharArray();
        int i2 = 0;
        while (i2 < actual.length) {
            if (!Character.isWhitespace(actual[i2])) {
                writer2.write(actual[i2]);
            }
            ++i2;
        }
        writer1.close();
        writer2.close();
        char[] expectedCompacted = writer1.toCharArray();
        char[] actualCompacted = writer2.toCharArray();
        TestJSPContentFormatter.assertEquals((String)"significant character differs", (String)new String(expectedCompacted), (String)new String(actualCompacted));
        return true;
    }

    private void resetPreferencesToDefault() {
        Preferences preferences = HTMLCorePlugin.getDefault().getPluginPreferences();
        preferences.setToDefault("splitMultiAttrs");
        preferences.setToDefault("lineWidth");
        preferences.setToDefault("indentationChar");
        preferences.setToDefault("indentationSize");
        preferences.setToDefault("clearAllBlankLines");
    }

    public void testFormatBug102495() throws UnsupportedEncodingException, IOException, CoreException {
        String beforePath = "/jsdtjspformatting/WebContent/formatbug102495.jsp";
        String afterPath = "/jsdtjspformatting/WebContent/formatbug102495-fmt.jsp";
        this.formatAndAssertEquals(beforePath, afterPath, true);
    }

    public void testFormatBug102495_1() throws UnsupportedEncodingException, IOException, CoreException {
        String beforePath = "/jsdtjspformatting/WebContent/formatbug102495_1.jsp";
        String afterPath = "/jsdtjspformatting/WebContent/formatbug102495_1-fmt.jsp";
        this.formatAndAssertEquals(beforePath, afterPath, true);
    }

    public void testFormatBug102495_2() throws UnsupportedEncodingException, IOException, CoreException {
        String beforePath = "/jsdtjspformatting/WebContent/formatbug102495_2.jsp";
        String afterPath = "/jsdtjspformatting/WebContent/formatbug102495_2-fmt.jsp";
        this.formatAndAssertEquals(beforePath, afterPath, true);
    }

    public void testFormatBug102495_3() throws UnsupportedEncodingException, IOException, CoreException {
        String beforePath = "/jsdtjspformatting/WebContent/formatbug102495_3.jsp";
        String afterPath = "/jsdtjspformatting/WebContent/formatbug102495_3-fmt.jsp";
        this.formatAndAssertEquals(beforePath, afterPath, true);
    }

    public void testFormatBug102495_4() throws UnsupportedEncodingException, IOException, CoreException {
        String beforePath = "/jsdtjspformatting/WebContent/formatbug102495_4.jsp";
        String afterPath = "/jsdtjspformatting/WebContent/formatbug102495_4-fmt.jsp";
        this.formatAndAssertEquals(beforePath, afterPath, true);
    }

    public void testFormatBug358545a() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertSignificantEquals("/jsdtjspformatting/WebContent/formatbug358545.jsp", true);
    }

    public void testFormatBug358545b() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertSignificantEquals("/jsdtjspformatting/WebContent/formatbug358545b.jsp", true);
    }

    public void testFormatBug384126() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertSignificantEquals("/jsdtjspformatting/WebContent/formatBug384126.jsp", true);
    }

    public void testFormatBug383387() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertSignificantEquals("/jsdtjspformatting/WebContent/formatBug383387.jsp", true);
    }
}

