/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.tests.contentassist;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.wst.jsdt.web.ui.tests.contentassist.ContentAssistTestUtilities;
import org.eclipse.wst.jsdt.web.ui.tests.internal.TestProjectSetup;

public class ConstructorTests_Edited
extends TestCase {
    private static final String TEST_NAME = "Test Constructor JavaScript Content Assist after Edit";
    private static TestProjectSetup fTestProjectSetup;

    public ConstructorTests_Edited() {
        super(TEST_NAME);
    }

    public ConstructorTests_Edited(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite ts = new TestSuite(ConstructorTests_Edited.class, TEST_NAME);
        fTestProjectSetup = new TestProjectSetup((Test)ts, "JSDTWebContentAssist", "WebContent", false){

            @Override
            public void additionalSetUp() throws Exception {
                this.editFile("JSClasses.js", 0, 9, 7, "Awesomeness");
                this.editFile("JSClasses.js", 10, 4, 6, "ClassOne");
                this.editFile("JSClasses.js", 11, 4, 6, "ClassOne");
                this.editFile("JSClasses.js", 12, 4, 6, "ClassTwo");
                this.editFile("JSClasses.js", 13, 4, 6, "ClassTwo");
                this.editFile("JSClasses.js", 14, 8, 6, "ClassThree");
                this.editFile("JSClasses.js", 15, 8, 6, "ClassThree");
                this.editFile("ClassTest1.js", 0, 9, 8, "MyClassEdit1");
                this.editFile("ClassTest1.js", 4, 4, 8, "MyClassEdit2");
                this.editFile("ClassTest1.js", 5, 0, 8, "MyClassEdit2");
                this.editFile("Test.js", 0, 4, 4, "testEdit");
                this.editFile("Test.js", 1, 0, 4, "testEdit");
            }
        };
        return fTestProjectSetup;
    }

    public void testFindConstructors_AfterEdit_ExpressionStarted_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"Awesomeness(param1, param2) - Awesomeness"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "JSClasses.html", 8, 6, expectedProposals);
    }

    public void testFindConstructors_AfterEdit_ExpressionStarted_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"bar.ClassOne(a, b) - bar.ClassOne", "bar.ClassTwo(c, d, e) - bar.ClassTwo", "bar.foo.ClassThree(param1, param2, param3, param4) - bar.foo.ClassThree"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "JSClasses.html", 10, 6, expectedProposals);
    }

    public void testFindConstructors_AfterEdit_ExpressionStarted_2() throws Exception {
        String[][] expectedProposals = new String[][]{{"bar.ClassOne(a, b) - bar.ClassOne", "bar.ClassTwo(c, d, e) - bar.ClassTwo"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "JSClasses.html", 12, 9, expectedProposals);
    }

    public void testFindConstructors_AfterEdit_ExpressionStarted_3() throws Exception {
        String[][] expectedProposals = new String[][]{{"bar.foo.ClassThree(param1, param2, param3, param4) - bar.foo.ClassThree"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "JSClasses.html", 14, 10, expectedProposals);
    }

    public void testFindConstructors_AfterEdit_ExpressionStarted_4() throws Exception {
        String[][] expectedProposals = new String[][]{{"bar.foo.ClassThree(param1, param2, param3, param4) - bar.foo.ClassThree"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "JSClasses.html", 16, 13, expectedProposals);
    }

    public void testFindConstructors_AfterEdit_ExpressionStarted_5() throws Exception {
        String[][] expectedProposals = new String[][]{{"bar.ClassOne(a, b) - bar.ClassOne", "bar.ClassTwo(c, d, e) - bar.ClassTwo", "bar.foo.ClassThree(param1, param2, param3, param4) - bar.foo.ClassThree"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "JSClasses.html", 18, 5, expectedProposals);
    }

    public void testFindConstructors_AfterEdit_ExpressionStarted_6() throws Exception {
        String[][] expectedProposals = new String[][]{{"bar.ClassOne(a, b) - bar.ClassOne", "bar.ClassTwo(c, d, e) - bar.ClassTwo", "bar.foo.ClassThree(param1, param2, param3, param4) - bar.foo.ClassThree"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "JSClasses.html", 20, 9, expectedProposals);
    }

    public void testFindConstructors_AfterEdit_VarDeclaration_ExpressionStarted_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"MyClassEdit1(a) - MyClassEdit1", "MyClassEdit2() - MyClassEdit2"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "ClassTest2.html", 7, 8, expectedProposals);
    }

    public void testFindConstructors_AfterEdit_ArrayReferenceDeclaration_ExpressionStarted_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"testEdit.Foo(x, y, z) - testEdit.Foo"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "Test.html", 8, 7, expectedProposals);
    }
}

