/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.actions;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.wst.jsdt.chromium.JsVariable;
import org.eclipse.wst.jsdt.chromium.debug.core.model.Variable;
import org.eclipse.wst.jsdt.chromium.debug.ui.actions.VariableBasedAction;

public abstract class WatchPropertyDescriptor
extends VariableBasedAction {
    protected WatchPropertyDescriptor(VariableBasedAction.ElementHandler elementHandler) {
        super(elementHandler);
    }

    @Override
    protected Runnable createRunnable(VariableBasedAction.VariableWrapper wrapper) {
        if (wrapper == null) {
            return null;
        }
        Variable variable = wrapper.getVariable();
        if (variable == null) {
            return null;
        }
        Variable.Real realVariable = variable.asRealVariable();
        if (realVariable == null) {
            return null;
        }
        final JsVariable jsVariable = realVariable.getJsVariable();
        final String qualifiedName = realVariable.createHolderWatchExpression();
        if (qualifiedName == null) {
            return null;
        }
        return new Runnable(){

            @Override
            public void run() {
                String expression = "Object.getOwnPropertyDescriptor(" + qualifiedName + ", \"" + jsVariable.getName() + "\")";
                IExpressionManager expressionManager = DebugPlugin.getDefault().getExpressionManager();
                IWatchExpression watchExpression = expressionManager.newWatchExpression(expression);
                expressionManager.addExpression((IExpression)watchExpression);
            }
        };
    }

    public static class ForExpression
    extends WatchPropertyDescriptor {
        public ForExpression() {
            super(EXPRESSION_VIEW_ELEMENT_HANDLER);
        }
    }

    public static class ForVariable
    extends WatchPropertyDescriptor {
        public ForVariable() {
            super(VARIABLE_VIEW_ELEMENT_HANDLER);
        }
    }
}

