/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.deque;

import java.util.Comparator;
import org.eclipse.jpt.common.utility.internal.deque.AbstractPriorityDeque;

public class PriorityDeque<E>
extends AbstractPriorityDeque<E> {
    private static final long serialVersionUID = 1L;

    public PriorityDeque(Comparator<? super E> comparator, int initialCapacity) {
        super(comparator, initialCapacity);
    }

    @Override
    public void enqueue(E element) {
        this.ensureCapacity(this.size + 1);
        super.enqueue(element);
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elements.length - 1;
        if (oldCapacity < minCapacity) {
            int newCapacity = (oldCapacity * 3 >> 1) + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elements = this.copyElements(newCapacity);
        }
    }

    public void trimToSize() {
        if (this.elements.length > this.size + 1) {
            this.elements = this.copyElements(this.size);
        }
    }

    private E[] copyElements(int newCapacity) {
        Object[] newElements = new Object[newCapacity + 1];
        System.arraycopy(this.elements, 1, newElements, 1, this.size);
        return newElements;
    }

    @Override
    public PriorityDeque<E> clone() {
        return (PriorityDeque)super.clone();
    }
}

