/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.core.search.TypeNameRequestor;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaSearchTests;
import org.eclipse.wst.jsdt.core.tests.model.JavaSearchTests;
import org.eclipse.wst.jsdt.core.tests.model.SearchTests;

public class WorkingCopySearchTests
extends JavaSearchTests {
    IJavaScriptUnit workingCopy;

    public WorkingCopySearchTests(String name) {
        super(name);
    }

    public static Test suite() {
        return WorkingCopySearchTests.buildModelTestSuite(WorkingCopySearchTests.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        try {
            this.workingCopy = this.getCompilationUnit("JSSearch", "src", "wc", "X.js").getWorkingCopy(null);
        }
        catch (JavaScriptModelException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void tearDown() throws Exception {
        this.workingCopy.discardWorkingCopy();
        this.workingCopy = null;
        super.tearDown();
    }

    public void testHierarchyScopeOnWorkingCopy() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JSSearch", "src", "a9", "A.js");
        IJavaScriptUnit copy = unit.getWorkingCopy(null);
        try {
            IType type = copy.getType("A");
            WorkingCopySearchTests.assertNotNull((Object)type);
            IJavaScriptSearchScope scope = SearchEngine.createHierarchyScope((IType)type);
            WorkingCopySearchTests.assertTrue((String)"a9.A should be included in hierarchy scope", (boolean)scope.encloses((IJavaScriptElement)type));
            WorkingCopySearchTests.assertTrue((String)"a9.C should be included in hierarchy scope", (boolean)scope.encloses((IJavaScriptElement)copy.getType("C")));
            WorkingCopySearchTests.assertTrue((String)"a9.B should be included in hierarchy scope", (boolean)scope.encloses((IJavaScriptElement)copy.getType("B")));
            IPath path = unit.getUnderlyingResource().getFullPath();
            WorkingCopySearchTests.assertTrue((String)"a9/A.java should be included in hierarchy scope", (boolean)scope.encloses(path.toString()));
        }
        finally {
            copy.discardWorkingCopy();
        }
    }

    public void testAddNewType() throws CoreException {
        this.workingCopy.createType("function NewType(){}\nNewType.prototype = new Object();\n", null, false, null);
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{this.workingCopy.getParent()});
        SearchPattern pattern = SearchPattern.createPattern((String)"NewType", (int)0, (int)0, (int)8);
        new SearchEngine(new IJavaScriptUnit[]{this.workingCopy}).search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)this.resultCollector, null);
        this.assertSearchResults("src/wc/X.js wc.NewType [NewType]", this.resultCollector);
    }

    public void testAllTypeNames1() throws CoreException {
        this.workingCopy.getBuffer().setContents("Y.prototype = new Object();\nY.prototype.I = new Object();\nY.I2 = new Object();\n");
        this.workingCopy.makeConsistent(null);
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{this.workingCopy.getParent()});
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine(new IJavaScriptUnit[]{this.workingCopy}).searchAllTypeNames(null, 0, null, 2, 0, scope, (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "Y", (Object)requestor);
    }

    public void testAllTypeNames2() throws CoreException {
        this.workingCopy.getBuffer().setContents("Y.prototype = new Object();\nY.prototype.I = new Object();\nY.I2 = new Object();\n");
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{this.workingCopy.getParent()});
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine(new IJavaScriptUnit[]{this.workingCopy}).searchAllTypeNames(null, 0, null, 2, 0, scope, (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "Y", (Object)requestor);
    }

    public void testAllTypeNames3() throws CoreException {
        IJavaScriptUnit wc = this.getCompilationUnit("/JSSearch/wc3/X44884.js");
        try {
            wc.becomeWorkingCopy(null);
            wc.getBuffer().setContents("X44884.prototype = new Object();\nI.prototype = new Object();\n");
            wc.makeConsistent(null);
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{wc.getParent()});
            SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
            new SearchEngine().searchAllTypeNames(null, 0, "X".toCharArray(), 1, 0, scope, (TypeNameRequestor)requestor, 3, null);
            this.assertSearchResults("Unexpected all type names", "X44884", (Object)requestor);
        }
        finally {
            wc.discardWorkingCopy();
        }
    }

    public void testAllTypeNames4() throws CoreException {
        IJavaScriptUnit wc = this.getCompilationUnit("/JSSearch/wc3/X44884.js");
        try {
            wc.becomeWorkingCopy(null);
            wc.getBuffer().setContents("X44884.prototype = new Object();\nI.prototype = new Object();\n");
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{wc.getParent()});
            SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
            new SearchEngine().searchAllTypeNames(null, 0, "X".toCharArray(), 1, 0, scope, (TypeNameRequestor)requestor, 3, null);
            this.assertSearchResults("Unexpected all type names", "X44884", (Object)requestor);
        }
        finally {
            wc.discardWorkingCopy();
        }
    }

    public void testAllTypeNamesBug99915() throws CoreException {
        this.workingCopy.getBuffer().setContents("X.prototype = new Object();\nAAABBB.prototype = new Object();\nBBBCCC.prototype = new Object();\n");
        this.workingCopy.makeConsistent(null);
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{this.workingCopy.getParent()});
        SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
        new SearchEngine(new IJavaScriptUnit[]{this.workingCopy}).searchAllTypeNames(null, 0, "A*".toCharArray(), 2, 0, scope, (TypeNameRequestor)requestor, 3, null);
        this.assertSearchResults("Unexpected all type names", "AAABBB", (Object)requestor);
    }

    public void testAllTypeNamesBug98684() throws CoreException {
        try {
            IJavaScriptProject[] projects = new IJavaScriptProject[]{this.createJavaProject("P1"), this.createJavaProject("P2")};
            this.workingCopies = new IJavaScriptUnit[2];
            this.workingCopies[0] = this.getWorkingCopy("/P1/p1/A1.js", "Ca1.prototype = new Object()");
            this.workingCopies[1] = this.getWorkingCopy("/P2/p2/A2.js", "Cb2.prototype = new Object()");
            SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{projects[1]});
            new SearchEngine(this.workingCopies).searchAllTypeNames(null, 0, "C".toCharArray(), 1, 0, scope, (TypeNameRequestor)requestor, 3, null);
            this.assertSearchResults("Unexpected all type names", "Cb2", (Object)requestor);
        }
        finally {
            this.deleteProject("P1");
            this.deleteProject("P2");
        }
    }

    public void testDeclarationOfReferencedTypes() throws CoreException {
        IFunction method = this.workingCopy.getType("X").createMethod("public void foo() {\n  X x = new X();\n}", null, true, null);
        this.searchDeclarationsOfReferencedTypes((IJavaScriptElement)method, this.resultCollector);
        this.assertSearchResults("src/wc/X.java wc.X [X]", this.resultCollector);
    }

    public void testMoveType() throws CoreException {
        IJavaScriptUnit workingCopy1 = this.getCompilationUnit("JSSearch", "src", "wc1", "X.js").getWorkingCopy(null);
        IJavaScriptUnit workingCopy2 = this.getCompilationUnit("JSSearch", "src", "wc2", "Y.js").getWorkingCopy(null);
        try {
            workingCopy1.getType("X").move((IJavaScriptElement)workingCopy2, null, null, true, null);
            SearchEngine searchEngine = new SearchEngine(new IJavaScriptUnit[]{workingCopy1, workingCopy2});
            IJavaScriptSearchScope scope1 = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{workingCopy1.getParent()});
            SearchPattern pattern = SearchPattern.createPattern((String)"X", (int)0, (int)0, (int)8);
            searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope1, (SearchRequestor)this.resultCollector, null);
            WorkingCopySearchTests.assertEquals((String)"", (String)this.resultCollector.toString());
            IJavaScriptSearchScope scope2 = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{workingCopy2.getParent()});
            this.resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
            searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope2, (SearchRequestor)this.resultCollector, null);
            this.assertSearchResults("src/wc2/Y.js wc2.X [X]", this.resultCollector);
        }
        finally {
            workingCopy1.discardWorkingCopy();
            workingCopy2.discardWorkingCopy();
        }
    }

    public void testRemoveType() throws CoreException {
        this.workingCopy.getType("X").delete(true, null);
        IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{this.workingCopy.getParent()});
        SearchPattern pattern = SearchPattern.createPattern((String)"X", (int)0, (int)0, (int)8);
        new SearchEngine(new IJavaScriptUnit[]{this.workingCopy}).search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)this.resultCollector, null);
        this.assertSearchResults("", this.resultCollector);
        this.resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
        new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)this.resultCollector, null);
        this.assertSearchResults("src/wc/X.java wc.X [X]", this.resultCollector);
    }
}

