/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.dom;

import junit.framework.Test;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.tests.dom.ConverterTestSetup;

public class ASTPositionsTest
extends ConverterTestSetup {
    IJavaScriptUnit workingCopy;

    @Override
    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.ast = AST.newAST((int)3);
    }

    public ASTPositionsTest(String name) {
        super(name);
    }

    public static Test suite() {
        return ASTPositionsTest.buildModelTestSuite(ASTPositionsTest.class);
    }

    private void sanityCheck(String contents, JavaScriptUnit compilationUnit) {
        int i = 0;
        int max = contents.length();
        while (i < max) {
            int lineNumber = compilationUnit.getLineNumber(i);
            ASTPositionsTest.assertTrue((String)("Wrong value for char at " + i), (lineNumber >= 1 ? 1 : 0) != 0);
            int columnNumber = compilationUnit.getColumnNumber(i);
            ASTPositionsTest.assertTrue((String)("Wrong value for char at " + i), (columnNumber >= 0 ? 1 : 0) != 0);
            int position = compilationUnit.getPosition(lineNumber, columnNumber);
            ASTPositionsTest.assertTrue((String)"Wrong value for char at i", (position >= 0 ? 1 : 0) != 0);
            if (position == 0) {
                ASTPositionsTest.assertEquals((String)"Only true for first character", (int)0, (int)i);
            }
            ASTPositionsTest.assertEquals((String)"Wrong char", (char)contents.charAt(i), (char)contents.charAt(position));
            ++i;
        }
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.workingCopy != null) {
            this.workingCopy.discardWorkingCopy();
            this.workingCopy = null;
        }
    }

    public void test001() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter/src/X.js", true);
        ASTNode node = this.buildAST("var d = new Date();\r\nfunction X() {\r\n\tvar date= d;\r\n}", this.workingCopy, false);
        ASTPositionsTest.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        ASTPositionsTest.assertEquals((String)"Wrong char", (char)'X', (char)"var d = new Date();\r\nfunction X() {\r\n\tvar date= d;\r\n}".charAt(compilationUnit.getPosition(2, 9)));
        ASTPositionsTest.assertEquals((String)"Wrong char", (char)'v', (char)"var d = new Date();\r\nfunction X() {\r\n\tvar date= d;\r\n}".charAt(compilationUnit.getPosition(1, 0)));
        ASTPositionsTest.assertEquals((String)"Wrong position", (int)-1, (int)compilationUnit.getPosition(1, -1));
        ASTPositionsTest.assertEquals((String)"Wrong position", (int)-1, (int)compilationUnit.getPosition(-1, 0));
        ASTPositionsTest.assertEquals((String)"Wrong position", (int)-1, (int)compilationUnit.getPosition(5, 0));
        ASTPositionsTest.assertEquals((String)"Wrong position", (int)-1, (int)compilationUnit.getPosition(4, 1));
        ASTPositionsTest.assertEquals((String)"Wrong char", (char)'}', (char)"var d = new Date();\r\nfunction X() {\r\n\tvar date= d;\r\n}".charAt(compilationUnit.getPosition(4, 0)));
        ASTPositionsTest.assertEquals((String)"Wrong char", (char)'\r', (char)"var d = new Date();\r\nfunction X() {\r\n\tvar date= d;\r\n}".charAt(compilationUnit.getPosition(1, 19)));
        this.sanityCheck("var d = new Date();\r\nfunction X() {\r\n\tvar date= d;\r\n}", compilationUnit);
    }

    public void test002() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter/src/X.js", true);
        ASTNode node = this.buildAST("function X() {\n\tvar map= null;\n}\n", this.workingCopy, false);
        ASTPositionsTest.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.sanityCheck("function X() {\n\tvar map= null;\n}\n", compilationUnit);
    }

    public void test003() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter/src/X.js", true);
        ASTNode node = this.buildAST("function X() {\r\tvar map= null;\r}\r", this.workingCopy, false);
        ASTPositionsTest.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.sanityCheck("function X() {\r\tvar map= null;\r}\r", compilationUnit);
    }

    public void test004() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter/src/X.js", true);
        String contents = "function X() {}";
        ASTNode node = this.buildAST(contents, this.workingCopy, false);
        ASTPositionsTest.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        this.sanityCheck(contents, compilationUnit);
        ASTPositionsTest.assertEquals((int)1, (int)compilationUnit.getLineNumber(0));
    }

    public void test005() throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/Converter/src/X.js", true);
        String contents = "function X() {}";
        ASTNode node = this.buildAST(contents, this.workingCopy, false);
        ASTPositionsTest.assertEquals((String)"Not a compilation unit", (int)15, (int)node.getNodeType());
        JavaScriptUnit compilationUnit = (JavaScriptUnit)node;
        ASTPositionsTest.assertEquals((int)1, (int)compilationUnit.getLineNumber(0));
        this.sanityCheck(contents, compilationUnit);
    }
}

