/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import javax.wsdl.Binding;
import javax.wsdl.extensions.soap.SOAPFault;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;

public class BP2022
extends AssertionProcess {
    private final WSDLValidatorImpl validator;

    public BP2022(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Binding binding = (Binding)entryContext.getEntry().getEntryDetail();
        SOAPFault[] soapFaults = this.validator.getSoapFaults(binding);
        if (soapFaults == null || soapFaults.length == 0) {
            this.result = "notApplicable";
        } else {
            int i = 0;
            while (i < soapFaults.length) {
                SOAPFault soapFault = soapFaults[i];
                if (soapFault.getName() == null) {
                    this.result = "failed";
                    this.failureDetail = this.validator.createFailureDetail("soapbind:fault element : " + soapFault.toString(), entryContext);
                    break;
                }
                ++i;
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

