/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.handlers;

import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.jpa.core.context.SpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.ui.internal.handlers.JpaStructureViewHandler;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IEvaluationService;

public class PersistentAttributeMapAsHandler
extends JpaStructureViewHandler
implements IElementUpdater {
    public static final String COMMAND_ID = "org.eclipse.jpt.jpa.ui.persistentAttributeMapAs";
    public static final String SPECIFIED_MAPPING_COMMAND_PARAMETER_ID = "specifiedPersistentAttributeMappingKey";
    public static final String DEFAULT_MAPPING_COMMAND_PARAMETER_ID = "defaultPersistentAttributeMappingKey";

    @Override
    protected void execute_(Object[] items, Map<String, String> parameters, IWorkbenchWindow window) {
        String mappingKey = parameters.get(SPECIFIED_MAPPING_COMMAND_PARAMETER_ID);
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            SpecifiedPersistentAttribute attribute = (SpecifiedPersistentAttribute)item;
            attribute.setMappingKey(mappingKey);
            ++n2;
        }
    }

    public void updateElement(UIElement element, Map parameters) {
        IEvaluationService es = (IEvaluationService)element.getServiceLocator().getService(IEvaluationService.class);
        IViewPart part = (IViewPart)es.getCurrentState().getVariable("activePart");
        IStructuredSelection selection = (IStructuredSelection)part.getSite().getSelectionProvider().getSelection();
        element.setChecked(this.selectedElementsMappingKeysMatch(selection, parameters));
    }

    protected boolean selectedElementsMappingKeysMatch(IStructuredSelection selection, Map parameters) {
        String handlerSpecifiedMappingKey = (String)parameters.get(SPECIFIED_MAPPING_COMMAND_PARAMETER_ID);
        String handlerDefaultMappingKey = (String)parameters.get(DEFAULT_MAPPING_COMMAND_PARAMETER_ID);
        String commonDefaultKey = null;
        String commonSpecifiedKey = null;
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (!(obj instanceof SpecifiedPersistentAttribute)) {
                return false;
            }
            SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)obj;
            if (persistentAttribute.getMapping().isDefault()) {
                if (commonSpecifiedKey != null) {
                    return false;
                }
                if (commonDefaultKey == null) {
                    commonDefaultKey = persistentAttribute.getMappingKey();
                } else if (!commonDefaultKey.equals(persistentAttribute.getMappingKey())) {
                    return false;
                }
            } else {
                if (commonDefaultKey != null) {
                    return false;
                }
                if (commonSpecifiedKey == null) {
                    commonSpecifiedKey = persistentAttribute.getMappingKey();
                } else if (!commonSpecifiedKey.equals(persistentAttribute.getMappingKey())) {
                    return false;
                }
            }
            ++n2;
        }
        if (handlerSpecifiedMappingKey != null) {
            return handlerSpecifiedMappingKey.equals(commonSpecifiedKey);
        }
        if (handlerDefaultMappingKey != null) {
            return handlerDefaultMappingKey.equals(commonDefaultKey);
        }
        return false;
    }
}

