/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFVirtualMachine;

public class RemoteBreakpoint
implements Comparable {
    public static final String TYPE_LINE = "line";
    public static final String TYPE_HTML_ATTRIBUTE_CHANGE = "html_attribute_change";
    public static final String TYPE_HTML_CHILD_CHANGE = "html_child_change";
    public static final String TYPE_HTML_REMOVE = "html_remove";
    public static final String TYPE_HTML_TEXT = "html_text";
    public static final String TYPE_HTML_UNKNOWN = "html_unknown_type";
    CFVirtualMachine vm = null;
    Number handle = null;
    String type = null;
    Map location = null;
    Map attributes = null;

    public RemoteBreakpoint(CFVirtualMachine vm, Number handle, Map location, Map attributes, String type) {
        this.vm = vm;
        this.handle = handle;
        this.location = location;
        this.attributes = attributes;
        this.type = type;
    }

    public Number getHandle() {
        return this.handle;
    }

    public String getUrl() {
        if (this.location != null) {
            return (String)this.location.get("url");
        }
        return null;
    }

    public int getLine() {
        Number line;
        if (this.location != null && (line = (Number)this.location.get(TYPE_LINE)) != null) {
            return line.intValue();
        }
        return -1;
    }

    public String getCondition() {
        if (this.attributes != null) {
            return (String)this.attributes.get("condition");
        }
        return null;
    }

    public void setCondition(String condition) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        if (condition != null) {
            this.attributes.put("condition", condition);
        } else {
            this.attributes.remove("condition");
        }
    }

    public boolean isEnabled() {
        Boolean bool;
        if (this.attributes != null && (bool = (Boolean)this.attributes.get("enabled")) != null) {
            return bool;
        }
        return false;
    }

    public void setEnabled(boolean enabled) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put("enabled", enabled);
    }

    public String getType() {
        return this.type;
    }

    public boolean isLineBreakpoint() {
        return TYPE_LINE.equals(this.type);
    }

    public boolean equals(Object o) {
        if (o instanceof RemoteBreakpoint) {
            RemoteBreakpoint bp = (RemoteBreakpoint)o;
            return this.handle.equals(bp.handle) && this.mapsEqual(this.location, bp.location) && this.mapsEqual(this.attributes, bp.attributes) && this.type.equals(bp.type);
        }
        return false;
    }

    boolean mapsEqual(Map m1, Map m2) {
        if (m1 == null && m2 == null) {
            return true;
        }
        if (m1 == null ^ m2 == null) {
            return false;
        }
        if (m1.size() != m2.size()) {
            return false;
        }
        Map.Entry entry2 = null;
        for (Map.Entry entry2 : m1.entrySet()) {
            Object val = m2.get(entry2.getKey());
            if (val == null) {
                return false;
            }
            if (val.equals(entry2.getValue())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.handle.hashCode() + this.mapHashCode(this.location) + this.mapHashCode(this.attributes) + this.type.hashCode();
    }

    int mapHashCode(Map m) {
        int hashcode = 0;
        Iterator i = m.values().iterator();
        while (i.hasNext()) {
            hashcode += i.next().hashCode();
        }
        return hashcode;
    }

    public int compareTo(Object o) {
        if (o instanceof RemoteBreakpoint) {
            RemoteBreakpoint bp = (RemoteBreakpoint)o;
            return this.type.compareTo(bp.type);
        }
        return 0;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("RemoteBreakpoint\n");
        buff.append("\t[handle: ").append(this.handle.toString()).append("]\n");
        return super.toString();
    }

    public static boolean getEnabled(Map json) {
        Map map;
        Object val = json.get("attributes");
        if (val instanceof Map && (val = (map = (Map)val).get("enabled")) instanceof Boolean) {
            return (Boolean)val;
        }
        return false;
    }

    public static final String getCondition(Map json) {
        Map map;
        String condition;
        Object val = json.get("attributes");
        if (val instanceof Map && (condition = (String)(map = (Map)val).get("condition")) != null && condition.trim().length() > 0) {
            return condition;
        }
        return null;
    }

    public static final boolean isSet(Map json) {
        Object val = json.get("set");
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        return false;
    }
}

