/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.rhino.tests;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.EventPacket;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.RhinoRequest;
import org.eclipse.wst.jsdt.debug.rhino.tests.FrameRequestTests;
import org.eclipse.wst.jsdt.debug.rhino.tests.RequestTest;
import org.eclipse.wst.jsdt.debug.rhino.tests.TestEventHandler;
import org.eclipse.wst.jsdt.debug.rhino.tests.Util;
import org.eclipse.wst.jsdt.debug.transport.DebugSession;
import org.eclipse.wst.jsdt.debug.transport.exception.DisconnectedException;
import org.eclipse.wst.jsdt.debug.transport.exception.TimeoutException;
import org.eclipse.wst.jsdt.debug.transport.packet.Packet;
import org.eclipse.wst.jsdt.debug.transport.packet.Response;

public class RequestLookupTest
extends FrameRequestTests {
    public void testLookup() throws Exception {
        this.eventHandler.addSubhandler(new RequestTest.SetBreakpointHandler((RequestTest)this, new int[]{16}));
        final Object[] success = new Object[1];
        TestEventHandler.Subhandler frameCheckHandler = new TestEventHandler.Subhandler(){

            @Override
            public String testName() {
                return RequestLookupTest.this.getName();
            }

            @Override
            public boolean handleEvent(DebugSession debugSession, EventPacket event) {
                if (event.getEvent().equals("break")) {
                    Number threadId = (Number)event.getBody().get("threadId");
                    Number contextId = (Number)event.getBody().get("contextId");
                    RhinoRequest request = new RhinoRequest("frames");
                    request.getArguments().put("threadId", threadId);
                    try {
                        debugSession.send((Packet)request);
                        Response response = debugSession.receiveResponse(request.getSequence(), 30000);
                        RequestLookupTest.assertTrue((boolean)response.isSuccess());
                        Collection frames = (Collection)response.getBody().get("frames");
                        for (Number frameId : frames) {
                            request = new RhinoRequest("lookup");
                            request.getArguments().put("threadId", threadId);
                            request.getArguments().put("contextId", contextId);
                            request.getArguments().put("frameId", frameId);
                            request.getArguments().put("ref", 0);
                            debugSession.send((Packet)request);
                            response = debugSession.receiveResponse(request.getSequence(), 30000);
                            RequestLookupTest.assertTrue((boolean)response.isSuccess());
                            RequestLookupTest.assertTrue((boolean)response.getBody().containsKey("lookup"));
                        }
                        success[0] = Boolean.TRUE;
                    }
                    catch (DisconnectedException e) {
                        e.printStackTrace();
                    }
                    catch (TimeoutException e) {
                        e.printStackTrace();
                    }
                    return true;
                }
                return false;
            }
        };
        this.eventHandler.addSubhandler(frameCheckHandler);
        String script = Util.getTestSource("scripts", "script1.js");
        RequestLookupTest.assertNotNull((String)"The test source for [script1.js] must exist", (Object)script);
        this.evalScript(script, 2);
    }

    public void testLookupBug387465() throws Exception {
        this.eventHandler.addSubhandler(new RequestTest.SetBreakpointHandler((RequestTest)this, new int[]{17}));
        final Object[] success = new Object[1];
        TestEventHandler.Subhandler frameCheckHandler = new TestEventHandler.Subhandler(){

            @Override
            public String testName() {
                return RequestLookupTest.this.getName();
            }

            @Override
            public boolean handleEvent(DebugSession debugSession, EventPacket event) {
                if (event.getEvent().equals("break")) {
                    Number threadId = (Number)event.getBody().get("threadId");
                    Number contextId = (Number)event.getBody().get("contextId");
                    RhinoRequest request = new RhinoRequest("frames");
                    request.getArguments().put("threadId", threadId);
                    try {
                        debugSession.send((Packet)request);
                        Response response = debugSession.receiveResponse(request.getSequence(), 30000);
                        RequestLookupTest.assertTrue((boolean)response.isSuccess());
                        Collection frames = (Collection)response.getBody().get("frames");
                        RequestLookupTest.assertTrue((String)"There should be at least one frame", (frames.size() > 0 ? 1 : 0) != 0);
                        Number frameId = (Number)frames.iterator().next();
                        response = RequestLookupTest.this.doLookup(debugSession, threadId, contextId, frameId, 0);
                        RequestLookupTest.assertTrue((boolean)response.isSuccess());
                        Map map = (Map)response.getBody().get("lookup");
                        RequestLookupTest.assertNotNull((String)"There must be a lookup response", (Object)map);
                        List props = (List)map.get("properties");
                        RequestLookupTest.assertNotNull((String)"The successful lookup should have properties", (Object)props);
                        map = RequestLookupTest.this.findVar(props, "s");
                        RequestLookupTest.assertNotNull((String)"There must be an 's' variable", (Object)map);
                        Number ref = (Number)map.get("ref");
                        RequestLookupTest.assertNotNull((String)"There must be a 'ref' entry in the variable map", (Object)ref);
                        response = RequestLookupTest.this.doLookup(debugSession, threadId, contextId, frameId, ref);
                        RequestLookupTest.assertTrue((boolean)response.isSuccess());
                        map = (Map)response.getBody().get("lookup");
                        RequestLookupTest.assertNotNull((String)("There should be a lookup entry trying to lookup 's' with ref: " + ref), (Object)map);
                        RequestLookupTest.assertEquals((String)"The type should be string", (Object)"string", map.get("type"));
                        RequestLookupTest.assertEquals((String)"The value should be 'aa'", (Object)"aa", map.get("value"));
                        success[0] = Boolean.TRUE;
                    }
                    catch (DisconnectedException e) {
                        e.printStackTrace();
                    }
                    catch (TimeoutException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        RequestLookupTest.fail((String)e.getMessage());
                    }
                    return true;
                }
                return false;
            }
        };
        this.eventHandler.addSubhandler(frameCheckHandler);
        String script = Util.getTestSource("scripts", "bug387465.js");
        RequestLookupTest.assertNotNull((String)"The test source for [bug387465.js] must exist", (Object)script);
        this.evalScript(script, 2);
    }
}

