/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.tests.views.model.jsp;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagElement;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.ITagResolvingStrategy;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.JSPTagResolvingStrategy;
import org.eclipse.jst.jsf.designtime.tests.views.model.jsp.BaseTestClass;
import org.eclipse.jst.jsf.designtime.tests.views.model.jsp.TestUtil;
import org.eclipse.jst.jsf.designtime.tests.views.model.jsp.VerifyRegistryUtil;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDElementDeclaration;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseStrategyTestClass
extends BaseTestClass {
    protected JSPTagResolvingStrategy _strategy;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this._strategy = this.createStrategy();
    }

    public final void testResolveTLDElementDeclaration() {
        for (String uri : this.getTestUris()) {
            Map<String, ITagElement> tags = TestUtil.constructTagElements(TestUtil.getTags((ITaglibRecord)this._tagRecords.get(uri)), (ITagResolvingStrategy<TLDElementDeclaration, String>)this._strategy);
            List<VerifyRegistryUtil.Verifier> verifiers = this.createVerifiers(tags, uri);
            VerifyRegistryUtil.CompositeVerifier compVerifier = new VerifyRegistryUtil.CompositeVerifier(verifiers, this.getExpectedTagCount(uri).getMin(), this.getExpectedTagCount(uri).getMax());
            compVerifier.verify(tags);
        }
    }

    protected abstract JSPTagResolvingStrategy createStrategy();

    protected abstract List<String> getTestUris();

    protected ExpectedTagCount getExpectedTagCount(String uri) {
        if ("http://java.sun.com/jsf/core".equals(uri)) {
            switch (this._jsfVersion) {
                case V1_0: 
                case V1_1: {
                    return new ExpectedTagCount(18, 18);
                }
                case V1_2: {
                    return new ExpectedTagCount(20, 20);
                }
            }
            throw new IllegalStateException("Unknown version: " + this._jsfVersion);
        }
        if ("http://java.sun.com/jsf/html".equals(uri)) {
            return new ExpectedTagCount(25, 25);
        }
        return null;
    }

    protected List<VerifyRegistryUtil.Verifier> createVerifiers(Map<String, ITagElement> tagElements, String uri) {
        if ("http://java.sun.com/jsf/core".equals(uri)) {
            switch (this._jsfVersion) {
                case V1_0: 
                case V1_1: {
                    return VerifyRegistryUtil.CORE_VERIFIERS_11;
                }
                case V1_2: {
                    return VerifyRegistryUtil.CORE_VERIFIERS_12;
                }
            }
            return Collections.EMPTY_LIST;
        }
        if ("http://java.sun.com/jsf/html".equals(uri)) {
            return VerifyRegistryUtil.HTML_VERIFIERS;
        }
        return Collections.EMPTY_LIST;
    }

    static class ExpectedTagCount {
        private final int _min;
        private final int _max;

        public ExpectedTagCount(int min, int max) {
            BaseStrategyTestClass.assertTrue((min <= max ? 1 : 0) != 0);
            this._max = max;
            this._min = min;
        }

        public final int getMin() {
            return this._min;
        }

        public final int getMax() {
            return this._max;
        }
    }
}

