/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.launching.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.xsl.jaxp.launching.IProcessorJar;
import org.eclipse.wst.xsl.jaxp.launching.internal.JAXPLaunchingPlugin;

public class ProcessorJar
implements IProcessorJar {
    private final IPath path;

    public ProcessorJar(IPath path) {
        this.path = path;
    }

    @Override
    public URL asURL() {
        URL url = null;
        try {
            IPath rootPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            File file = new File(rootPath.append(this.path).toOSString());
            if (file.exists()) {
                url = file.toURI().toURL();
            } else {
                file = new File(this.path.toOSString());
                url = file.toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            JAXPLaunchingPlugin.log(e);
        }
        return url;
    }

    @Override
    public IPath getPath() {
        return this.path;
    }

    public String toString() {
        return this.path.toString();
    }
}

