/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.discovery.internal.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.ui.AcceptLicensesWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.server.discovery.ExtensionWizard;
import org.eclipse.wst.server.discovery.internal.Messages;
import org.eclipse.wst.server.discovery.internal.Trace;
import org.eclipse.wst.server.discovery.internal.model.Extension;
import org.eclipse.wst.server.discovery.internal.wizard.ErrorWizardPage;
import org.eclipse.wst.server.discovery.internal.wizard.ExtensionComposite;

public class ExtensionWizardPage
extends WizardPage {
    private ExtensionComposite comp;
    protected AcceptLicensesWizardPage licensePage;
    protected ErrorWizardPage errorPage;
    protected IWizardPage nextPage;
    private Extension extension;

    public ExtensionWizardPage(AcceptLicensesWizardPage licenseWizardPage, ErrorWizardPage errorWizardPage) {
        super("extension");
        this.licensePage = licenseWizardPage;
        this.errorPage = errorWizardPage;
        this.setTitle(Messages.wizExtensionTitle);
        this.setDescription(Messages.wizExtensionDescription);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridData data = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 64);
        data = new GridData(4, 1, false, false);
        data.widthHint = 350;
        label.setLayoutData((Object)data);
        label.setText(Messages.wizExtensionMessage);
        this.comp = new ExtensionComposite(composite, 0, new ExtensionComposite.ExtensionSelectionListener(){

            public void extensionSelected(Extension sel) {
                ExtensionWizardPage.this.handleSelection(sel);
            }
        });
        data = new GridData(4, 4, true, true);
        data.heightHint = 375;
        this.comp.setLayoutData(data);
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
    }

    protected void handleSelection(Extension sel) {
        this.extension = sel;
        if (this.extension == null) {
            this.licensePage.updateForPlan(new IInstallableUnit[0], null);
        } else {
            try {
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        final IProvisioningPlan plan = ExtensionWizardPage.this.extension.getProvisioningPlan(true, monitor);
                        if (plan != null && plan.getStatus().isOK()) {
                            ExtensionWizardPage.this.getShell().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    (this).ExtensionWizardPage.this.licensePage.updateForPlan(ExtensionWizardPage.this.extension.getIUs(), plan);
                                    (this).ExtensionWizardPage.this.nextPage = (this).ExtensionWizardPage.this.licensePage;
                                    ((ExtensionWizard)ExtensionWizardPage.this.getWizard()).setSecondPage((this).ExtensionWizardPage.this.nextPage);
                                }
                            });
                        } else {
                            ExtensionWizardPage.this.getShell().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    (this).ExtensionWizardPage.this.errorPage.setStatus(plan.getStatus());
                                }
                            });
                            ExtensionWizardPage.this.nextPage = ExtensionWizardPage.this.errorPage;
                            ((ExtensionWizard)ExtensionWizardPage.this.getWizard()).setSecondPage(ExtensionWizardPage.this.nextPage);
                        }
                        monitor.done();
                    }
                });
            }
            catch (Exception e) {
                Trace.trace((byte)3, "Error verifying license", e);
            }
        }
        this.setPageComplete(this.extension != null);
    }

    public Extension getExtension() {
        return this.extension;
    }
}

