/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.ui.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.json.core.document.IJSONNode;
import org.eclipse.wst.json.core.document.IJSONPair;
import org.eclipse.wst.json.core.document.IJSONValue;
import org.eclipse.wst.json.ui.contentassist.ContentAssistRequest;
import org.eclipse.wst.json.ui.internal.JSONUIMessages;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.contentassist.ICompletionProposalComputer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;

public abstract class AbstractJSONCompletionProposalComputer
implements ICompletionProposalComputer {
    private static final String BLANK = " ";
    private static final String EMPTY = "";
    private static final String COLON = ":";
    protected static final String QUOTE = "\"";
    protected static final String TRUE = "true";
    protected static final String FALSE = "false";
    private String fErrorMessage = null;
    private ITextViewer fTextViewer = null;

    public List computeCompletionProposals(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        ICompletionProposal[] props;
        ITextViewer textViewer = context.getViewer();
        int documentPosition = context.getInvocationOffset();
        this.setErrorMessage(null);
        this.fTextViewer = textViewer;
        IndexedRegion treeNode = ContentAssistUtils.getNodeAt((ITextViewer)textViewer, (int)(documentPosition <= 0 ? 0 : documentPosition - 1));
        IJSONNode node = (IJSONNode)treeNode;
        while (node != null && node.getNodeType() == 3 && node.getParentNode() != null) {
            node = node.getParentNode();
        }
        ContentAssistRequest contentAssistRequest = null;
        IStructuredDocumentRegion sdRegion = this.getStructuredDocumentRegion(documentPosition);
        ITextRegion completionRegion = this.getCompletionRegion(documentPosition, node);
        if (completionRegion != null && completionRegion.getType() == "JSON_OBJECT_CLOSE" && documentPosition > 0) {
            completionRegion = this.getCompletionRegion(documentPosition, node);
        }
        String matchString = EMPTY;
        if (completionRegion != null) {
            if (this.isPairValue(context, node)) {
                try {
                    String nodeText = this.getNodeText(node);
                    int colonIndex = nodeText.indexOf(COLON);
                    int offset = documentPosition - node.getStartOffset();
                    if (colonIndex >= 0 && offset >= 0) {
                        String str = nodeText.substring(colonIndex + 1, offset);
                        matchString = str = str.replaceAll(",", BLANK);
                    }
                }
                catch (BadLocationException badLocationException) {}
            } else {
                matchString = this.getMatchString(sdRegion, completionRegion, documentPosition);
            }
        }
        if ((contentAssistRequest = this.computeCompletionProposals(matchString, completionRegion, (IJSONNode)treeNode, node != null ? node.getParentNode() : null, context)) == null) {
            contentAssistRequest = new ContentAssistRequest((IJSONNode)treeNode, node != null ? node.getParentNode() : null, sdRegion, completionRegion, documentPosition, 0, EMPTY);
            this.setErrorMessage(JSONUIMessages.Content_Assist_not_availab_UI_);
        }
        if (contentAssistRequest.getProposals().size() == 0 && this.getErrorMessage() == null) {
            this.setErrorMessage(JSONUIMessages.Content_Assist_not_availab_UI_);
        }
        return (props = contentAssistRequest.getCompletionProposals()) != null ? Arrays.asList(props) : new ArrayList(0);
    }

    protected void setErrorMessage(String errorMessage) {
        this.fErrorMessage = errorMessage;
    }

    protected ContentAssistRequest computeCompletionProposals(String matchString, ITextRegion completionRegion, IJSONNode treeNode, IJSONNode xmlnode, CompletionProposalInvocationContext context) {
        int documentPosition = context.getInvocationOffset();
        ContentAssistRequest contentAssistRequest = null;
        String regionType = completionRegion != null ? completionRegion.getType() : EMPTY;
        this.getStructuredDocumentRegion(documentPosition);
        if (xmlnode != null && (xmlnode.getNodeType() == -1 || xmlnode.getNodeType() == 0)) {
            if (treeNode.getNodeType() == 0) {
                if (regionType == "JSON_OBJECT_OPEN" || regionType == "JSON_OBJECT_CLOSE" || regionType == "JSON_OBJECT_KEY" || regionType == "JSON_COMMA" || regionType == "JSON_UNKNOWN") {
                    contentAssistRequest = this.computeObjectKeyProposals(matchString, completionRegion, treeNode, xmlnode, context);
                }
            } else if (treeNode.getNodeType() == 2 && (regionType == "JSON_OBJECT_KEY" || regionType == "JSON_OBJECT_OPEN" || regionType == "JSON_OBJECT_CLOSE" || regionType == "JSON_ARRAY_OPEN" || regionType == "JSON_ARRAY_CLOSE" || regionType == "JSON_COMMA" || regionType == "JSON_VALUE_BOOLEAN" || regionType == "JSON_UNKNOWN" || regionType == "JSON_COLON" || regionType == "JSON_VALUE_STRING")) {
                contentAssistRequest = this.computeObjectKeyProposals(matchString, completionRegion, treeNode, xmlnode, context);
            }
        }
        return contentAssistRequest;
    }

    private ContentAssistRequest computeObjectKeyProposals(String matchString, ITextRegion completionRegion, IJSONNode nodeAtOffset, IJSONNode node, CompletionProposalInvocationContext context) {
        IJSONPair pair;
        int documentPosition = context.getInvocationOffset();
        ContentAssistRequest contentAssistRequest = null;
        IStructuredDocumentRegion sdRegion = this.getStructuredDocumentRegion(documentPosition);
        int replaceLength = 0;
        int begin = documentPosition;
        if (completionRegion.getType() == "JSON_OBJECT_KEY" || completionRegion.getType() == "JSON_UNKNOWN") {
            replaceLength = completionRegion.getTextLength();
            if (completionRegion instanceof ITextRegionContainer) {
                ITextRegion openRegion = ((ITextRegionContainer)completionRegion).getFirstRegion();
                ITextRegion closeRegion = ((ITextRegionContainer)completionRegion).getLastRegion();
                if (openRegion.getType() != closeRegion.getType()) {
                    replaceLength = openRegion.getTextLength();
                }
            }
            begin = sdRegion.getStartOffset(completionRegion);
        }
        if (this.isPairValue(context, nodeAtOffset)) {
            pair = (IJSONPair)nodeAtOffset;
            IJSONValue value = pair.getValue();
            if (value != null) {
                try {
                    begin = value.getStartOffset();
                    String valueText = this.getNodeText((IJSONNode)value);
                    valueText = valueText.trim();
                    replaceLength = valueText.length();
                    if (valueText.startsWith(QUOTE)) {
                        ++begin;
                        --replaceLength;
                    }
                    if (valueText.endsWith(QUOTE)) {
                        --replaceLength;
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        } else if (nodeAtOffset instanceof IJSONPair) {
            pair = (IJSONPair)nodeAtOffset;
            try {
                begin = pair.getStartOffset();
                String text = this.getNodeText((IJSONNode)pair);
                text = text.trim();
                replaceLength = pair.getName().length();
                if (text.startsWith(QUOTE)) {
                    ++begin;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        contentAssistRequest = new ContentAssistRequest(nodeAtOffset, node.getParentNode(), sdRegion, completionRegion, begin, replaceLength, matchString);
        this.addObjectKeyProposals(contentAssistRequest, context);
        return contentAssistRequest;
    }

    protected abstract void addObjectKeyProposals(ContentAssistRequest var1, CompletionProposalInvocationContext var2);

    private ITextRegion getCompletionRegion(int offset, IStructuredDocumentRegion sdRegion) {
        ITextRegion nextRegion;
        ITextRegion previousRegion;
        ITextRegion region = sdRegion.getRegionAtCharacterOffset(offset);
        if (region == null) {
            return null;
        }
        if (sdRegion.getStartOffset(region) == offset) {
            if (sdRegion.getStartOffset(region) == sdRegion.getStartOffset() && sdRegion.getPrevious() != null && !sdRegion.getPrevious().isEnded()) {
                region = sdRegion.getPrevious().getRegionAtCharacterOffset(offset - 1);
            } else {
                previousRegion = sdRegion.getRegionAtCharacterOffset(offset - 1);
                if (previousRegion != null && previousRegion != region && previousRegion.getTextLength() == previousRegion.getLength()) {
                    region = previousRegion;
                }
            }
        } else if (region.getType() != "JSON_COLON" && offset > sdRegion.getStartOffset(region) + region.getTextLength() && (nextRegion = sdRegion.getRegionAtCharacterOffset(sdRegion.getStartOffset(region) + region.getLength())) != null) {
            region = nextRegion;
        }
        if (region != null && region.getType() == "WHITE_SPACE" && (previousRegion = sdRegion.getRegionAtCharacterOffset(sdRegion.getStartOffset(region) - 1)) != null) {
            region = previousRegion;
        }
        return region;
    }

    private ITextRegion getCompletionRegion(int documentPosition, IJSONNode node) {
        if (node == null) {
            return null;
        }
        ITextRegion region = null;
        int offset = documentPosition;
        IStructuredDocumentRegion flatNode = null;
        if (node.getNodeType() == -1) {
            if (node.getStructuredDocument().getLength() == 0) {
                return null;
            }
            ITextRegion result = node.getStructuredDocument().getRegionAtCharacterOffset(offset).getRegionAtCharacterOffset(offset);
            while (result == null) {
                result = node.getStructuredDocument().getRegionAtCharacterOffset(--offset).getRegionAtCharacterOffset(offset);
            }
            return result;
        }
        IStructuredDocumentRegion startTag = node.getStartStructuredDocumentRegion();
        IStructuredDocumentRegion endTag = node.getEndStructuredDocumentRegion();
        if (startTag != null && startTag.getStartOffset() <= offset && offset < startTag.getStartOffset() + startTag.getLength()) {
            flatNode = startTag;
        } else if (endTag != null && endTag.getStartOffset() <= offset && offset < endTag.getStartOffset() + endTag.getLength()) {
            flatNode = endTag;
        }
        region = flatNode != null ? this.getCompletionRegion(offset, flatNode) : ((flatNode = node.getStructuredDocument().getRegionAtCharacterOffset(offset)).getStartOffset() <= documentPosition && flatNode.getEndOffset() >= documentPosition ? flatNode.getFirstRegion() : flatNode.getLastRegion());
        return region;
    }

    private String getMatchString(IStructuredDocumentRegion parent, ITextRegion aRegion, int offset) {
        if (aRegion == null) {
            return EMPTY;
        }
        String regionType = aRegion.getType();
        if (regionType != "JSON_OBJECT_KEY") {
            return EMPTY;
        }
        if (parent.getText(aRegion).length() > 0 && parent.getStartOffset(aRegion) < offset) {
            return parent.getText(aRegion).substring(0, offset - parent.getStartOffset(aRegion));
        }
        return EMPTY;
    }

    private IStructuredDocumentRegion getStructuredDocumentRegion(int pos) {
        return ContentAssistUtils.getStructuredDocumentRegion((ITextViewer)this.fTextViewer, (int)pos);
    }

    public List computeContextInformation(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        return Collections.EMPTY_LIST;
    }

    protected boolean isPairValue(CompletionProposalInvocationContext context, IJSONNode node) {
        if (!(node instanceof IJSONPair)) {
            return false;
        }
        int documentPosition = context.getInvocationOffset();
        try {
            String nodeText = this.getNodeText(node);
            int colonIndex = nodeText.indexOf(COLON);
            if (colonIndex >= 0) {
                return documentPosition > node.getStartOffset() + colonIndex;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    private String getNodeText(IJSONNode node) throws BadLocationException {
        return node.getStructuredDocument().get(node.getStartOffset(), node.getEndOffset() - node.getStartOffset());
    }

    protected static boolean beginsWith(String aString, String prefix) {
        if (aString == null || prefix == null) {
            return true;
        }
        return aString.toLowerCase().startsWith(prefix.toLowerCase());
    }
}

