/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.common.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.js.common.CommonPlugin;
import org.eclipse.wst.jsdt.js.common.build.system.ITask;
import org.eclipse.wst.jsdt.js.common.build.system.Location;

public class EditorUtility {
    public static IEditorPart isOpenInEditor(ITask task) {
        FileEditorInput input = new FileEditorInput(task.getBuildFile());
        IWorkbenchPage p = CommonPlugin.getActivePage();
        if (p != null) {
            return p.findEditor((IEditorInput)input);
        }
        return null;
    }

    public static void revealInEditor(IEditorPart editorPart, ITask task) {
        EditorUtility.revealInEditor(editorPart, task, null);
    }

    public static void revealInEditor(IEditorPart editorPart, ITask task, IWorkbenchPage page) {
        if (task == null) {
            return;
        }
        ITextEditor textEditor = null;
        if (editorPart instanceof ITextEditor) {
            textEditor = (ITextEditor)editorPart;
        } else if (editorPart instanceof IAdaptable) {
            textEditor = (ITextEditor)editorPart.getAdapter(ITextEditor.class);
        }
        if (textEditor != null) {
            int start;
            Location location = task.getLocation();
            if (location != null && (start = location.getStart()) > 0) {
                int length = location.getLength();
                textEditor.selectAndReveal(start, length);
                if (page != null) {
                    page.activate((IWorkbenchPart)editorPart);
                }
            }
        } else {
            Location location = task.getLocation();
            if (location != null) {
                IFile fileResource = task.getBuildFile();
                int start = location.getStart();
                try {
                    IMarker marker = fileResource.createMarker("org.eclipse.core.resources.textmarker");
                    marker.setAttribute("lineNumber", start);
                    editorPart = IDE.openEditor((IWorkbenchPage)page, (IMarker)marker, (boolean)true);
                    marker.delete();
                }
                catch (CoreException e) {
                    CommonPlugin.logError(e);
                }
            }
        }
    }
}

