/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.creation.ui.command;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.axis.consumption.core.context.AxisEmitterContext;
import org.eclipse.jst.ws.internal.axis.consumption.core.plugin.WebServiceAxisConsumptionCorePlugin;
import org.eclipse.jst.ws.internal.conformance.JAXRPCWebServiceAnalyzer;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.StatusException;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.ws.internal.wsrt.IWebService;

public class BUAxisInputCommand
extends AbstractDataModelOperation {
    private IWebService ws_;
    private String serverProject_;
    private String javaBeanName_;
    private String serviceServerTypeID_;
    private IServer serviceExistingServer_ = null;

    public BUAxisInputCommand() {
    }

    public BUAxisInputCommand(IWebService ws, String project) {
        this.ws_ = ws;
        this.serverProject_ = project;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        String serverInstanceId = this.ws_.getWebServiceInfo().getServerInstanceId();
        String serverFactoryId = this.ws_.getWebServiceInfo().getServerFactoryId();
        this.javaBeanName_ = this.ws_.getWebServiceInfo().getImplURL();
        IEnvironment environment = this.getEnvironment();
        AxisEmitterContext context = WebServiceAxisConsumptionCorePlugin.getInstance().getAxisEmitterContext();
        if (this.javaBeanName_ != null && context.isValidateAgainstJAXRPCEnabled()) {
            IStatus status;
            JAXRPCWebServiceAnalyzer analyzer = new JAXRPCWebServiceAnalyzer();
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.serverProject_);
            if (project != null && !(status = analyzer.analyze(project, this.javaBeanName_, monitor)).isOK()) {
                try {
                    environment.getStatusHandler().report(status);
                }
                catch (StatusException statusException) {
                    return new Status(4, "org.eclipse.jst.ws", 0, "", null);
                }
            }
        }
        if (serverInstanceId != null) {
            this.serviceExistingServer_ = ServerCore.findServer((String)serverInstanceId);
            if (this.serviceExistingServer_ != null) {
                this.serviceServerTypeID_ = this.serviceExistingServer_.getServerType().getId();
            }
        } else {
            this.serviceServerTypeID_ = serverFactoryId;
        }
        return Status.OK_STATUS;
    }

    public String getServerProject() {
        return this.serverProject_;
    }

    public String getServiceServerTypeID() {
        return this.serviceServerTypeID_;
    }

    public String getJavaBeanName() {
        return this.javaBeanName_;
    }

    public IServer getServiceExistingServer() {
        return this.serviceExistingServer_;
    }
}

