/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.format;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jst.jsp.ui.internal.JSPUIPlugin;
import org.eclipse.wst.html.core.internal.format.HTMLFormatProcessorImpl;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.ui.internal.format.StructuredFormattingStrategy;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.ui.internal.XMLFormattingStrategy;

public class StructuredFormattingStrategyJSP
extends ContextBasedFormattingStrategy {
    private static final String XMLNS_ATTR = "xmlns:jsp";
    private static final String NAMESPACE = "http://java.sun.com/JSP/Page";
    private XMLFormattingStrategy xmlStrategy = new XMLFormattingStrategy();
    private ContextBasedFormattingStrategy htmlStrategy = new StructuredFormattingStrategy((IStructuredFormatProcessor)new HTMLFormatProcessorImpl());
    private IDocument fDocument;
    private ContextBasedFormattingStrategy fStrategy;

    public void formatterStarts(IFormattingContext context) {
        super.formatterStarts(context);
        this.fDocument = (IDocument)context.getProperty((Object)"formatting.context.medium");
        this.getFormattingStrategy().formatterStarts(context);
    }

    public void format() {
        super.format();
        this.getFormattingStrategy().format();
    }

    public void formatterStops() {
        super.formatterStops();
        this.getFormattingStrategy().formatterStops();
        this.fDocument = null;
        this.fStrategy = null;
    }

    protected ContextBasedFormattingStrategy getFormattingStrategy() {
        IDOMModel model = null;
        if (this.fStrategy != null) {
            return this.fStrategy;
        }
        if (this.fDocument == null || JSPUIPlugin.getInstance().getPreferenceStore().getBoolean("useHTMLFormatter")) {
            this.fStrategy = this.htmlStrategy;
        } else {
            model = (IDOMModel)StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
            try {
                String attr = null;
                if (model != null && model.getDocument() != null) {
                    attr = model.getDocument().getDocumentElement().getAttribute(XMLNS_ATTR);
                }
                this.fStrategy = NAMESPACE.equals(attr) ? this.xmlStrategy : this.htmlStrategy;
            }
            finally {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
        return this.fStrategy;
    }
}

