/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.webservice;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.j2ee.internal.webservice.WebServiceViewerSynchronization;
import org.eclipse.jst.j2ee.internal.webservice.helper.WebServicesManager;
import org.eclipse.jst.j2ee.internal.webservice.plugin.WebServiceUIPlugin;
import org.eclipse.jst.j2ee.internal.webservice.startup.WebserviceListener;

public class NewProjectsListener
implements IResourceChangeListener,
IResourceDeltaVisitor {
    private WebServiceViewerSynchronization synchronization;
    private boolean listening = false;
    private boolean synchronizing = false;
    private boolean isDisposed = false;

    public NewProjectsListener(WebServiceViewerSynchronization sync) {
        this.synchronization = sync;
        if (!this.synchronization.webServiceProjectsExist((IProgressMonitor)new NullProgressMonitor())) {
            WebServiceViewerSynchronization.setAreThereWebServices(false);
        }
        this.startListening();
    }

    public void dispose() {
        if (this.listening) {
            this.stopListening();
        }
        if (this.synchronizing) {
            this.synchronization.stop();
        }
        if (WebserviceListener.getInstance() != null && !WebserviceListener.getInstance().isListening()) {
            WebserviceListener.getInstance().startListening();
        }
        this.isDisposed = true;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            event.getDelta().accept((IResourceDeltaVisitor)this);
        }
        catch (CoreException e) {
            WebServiceUIPlugin.logError(0, e.getMessage(), e);
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        switch (resource.getType()) {
            case 8: {
                return true;
            }
            case 4: {
                if (!this.listening || delta.getKind() != 1 && delta.getKind() != 4 || !WebServiceViewerSynchronization.isInteresting(resource.getProject()) || this.synchronization.hasNavigatorGroupBeenAdded()) break;
                return true;
            }
            case 2: {
                if (!this.listening || delta.getKind() != 1 && delta.getKind() != 4) break;
                return true;
            }
            case 1: {
                if (!this.listening || delta.getKind() != 1 || !WebServicesManager.isFileInteresting((IFile)((IFile)resource))) break;
                this.stopListening();
                if (!this.synchronizing) {
                    this.synchronizing = true;
                    this.synchronization.start();
                }
                WebServiceViewerSynchronization.setAreThereWebServices(true);
                if (this.synchronization.hasNavigatorGroupBeenAdded()) break;
                this.synchronization.addWebServiceNode();
                this.synchronization.indexJobScheduled = false;
            }
        }
        return false;
    }

    void startListening() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        this.listening = true;
    }

    void stopListening() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.listening = false;
    }

    boolean isListening() {
        return this.listening;
    }

    boolean isDisposed() {
        return this.isDisposed;
    }
}

