/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.command;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.refactoring.RenameSupport;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.orm.OrmManagedType;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.resource.orm.XmlAttributeMapping;
import org.eclipse.jpt.jpa.core.resource.orm.XmlTypeMapping;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class RenameAttributeCommand
implements Command {
    private PersistentType jpt;
    private String oldName;
    private String newName;

    public RenameAttributeCommand(PersistentType jpt, String oldName, String newName) {
        this.jpt = jpt;
        this.oldName = oldName;
        this.newName = newName;
    }

    public void execute() {
        try {
            this.renameAttribute(this.jpt, this.oldName, this.newName);
            boolean isMethodAnnotated = JpaArtifactFactory.instance().isMethodAnnotated(this.jpt);
            ICompilationUnit jptCompilationUnit = JPAEditorUtil.getCompilationUnit(this.jpt);
            this.renameAttribute(jptCompilationUnit, this.oldName, this.newName, isMethodAnnotated);
            JavaResourceType jrt = this.jpt.getJavaResourceType();
            jrt.getJavaResourceCompilationUnit().synchronizeWithJavaSource();
        }
        catch (Exception e) {
            JPADiagramEditorPlugin.logError("Cannot rename attribute", e);
        }
    }

    private void renameAttribute(PersistentType jpt, String oldName, String newName) {
        MappingFileRef mapFileRef = JpaArtifactFactory.instance().getOrmXmlByForPersistentType(jpt);
        if (mapFileRef != null) {
            EntityMappings root = (EntityMappings)mapFileRef.getMappingFile().getRoot();
            ListIterator managedTypesIter = root.getManagedTypes().iterator();
            while (managedTypesIter.hasNext()) {
                XmlTypeMapping xmlType = (XmlTypeMapping)((OrmManagedType)managedTypesIter.next()).getXmlManagedType();
                if (xmlType.getAttributes() == null) {
                    return;
                }
                List attributeMappings = xmlType.getAttributes().getAttributeMappings();
                for (XmlAttributeMapping attr : attributeMappings) {
                    if (!attr.getName().equals(oldName)) continue;
                    attr.setName(newName);
                }
            }
        }
    }

    private void renameAttribute(ICompilationUnit cu, String oldName, String newName, boolean isMethodAnnotated) throws Exception {
        IMethod setter;
        String getterPrefix;
        String methodName;
        IMethod getter;
        IJavaProject jp = JavaCore.create((IProject)this.jpt.getJpaProject().getProject());
        IType javaType = jp.findType(this.jpt.getName());
        if (javaType == null) {
            return;
        }
        IField attributeField = null;
        String typeSignature = null;
        if (isMethodAnnotated) {
            attributeField = javaType.getField(oldName);
            if (!attributeField.exists()) {
                attributeField = javaType.getField(JPAEditorUtil.revertFirstLetterCase(oldName));
            }
        } else {
            attributeField = javaType.getField(oldName);
        }
        if (!(getter = javaType.getMethod(methodName = String.valueOf(getterPrefix = "get") + JPAEditorUtil.capitalizeFirstLetter(oldName), new String[0])).exists()) {
            getterPrefix = "is";
        }
        methodName = String.valueOf(getterPrefix) + JPAEditorUtil.capitalizeFirstLetter(oldName);
        getter = javaType.getMethod(methodName, new String[0]);
        if (isMethodAnnotated) {
            try {
                typeSignature = getter.getReturnType();
            }
            catch (JavaModelException e1) {
                JPADiagramEditorPlugin.logError("Cannot obtain type signature of the getter of the attribute " + oldName, e1);
                return;
            }
            if (typeSignature == null || !"Z".equals(typeSignature) && !getterPrefix.equals("get")) {
                JPADiagramEditorPlugin.logError("Cannot obtain type signature of the getter of the attribute " + oldName, new NullPointerException());
                return;
            }
        } else {
            try {
                typeSignature = attributeField.getTypeSignature();
            }
            catch (JavaModelException e) {
                JPADiagramEditorPlugin.logError("Cannot obtain type signature of the field of the attribute " + oldName, e);
                return;
            }
        }
        if ((setter = javaType.getMethod(methodName = "set" + JPAEditorUtil.capitalizeFirstLetter(oldName), new String[]{typeSignature})).exists()) {
            this.renameSetter(setter, newName);
        }
        if (isMethodAnnotated) {
            if (attributeField.exists()) {
                this.renameField(attributeField, newName, isMethodAnnotated);
            }
            if (getter.exists()) {
                this.renameGetter(getter, newName);
            }
        } else {
            if (getter.exists()) {
                this.renameGetter(getter, newName);
            }
            if (attributeField.exists()) {
                this.renameField(attributeField, newName, isMethodAnnotated);
            }
        }
    }

    private void renameField(IField field, String newName, boolean isMethodAnnotated) throws InterruptedException {
        if (!field.exists()) {
            return;
        }
        String oldName = field.getElementName();
        if (oldName.equals(newName)) {
            return;
        }
        try {
            RenameSupport s = RenameSupport.create((IField)field, (String)(isMethodAnnotated ? JPAEditorUtil.decapitalizeFirstLetter(newName) : newName), (int)1);
            try {
                IWorkbenchWindow ww = JPADiagramEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                Shell sh = ww.getShell();
                s.perform(sh, (IRunnableContext)ww);
            }
            catch (InvocationTargetException e) {
                JPADiagramEditorPlugin.logError("Cannot rename the field of the attribute " + oldName, e);
            }
        }
        catch (CoreException e1) {
            JPADiagramEditorPlugin.logError("Cannot rename the field of the attribute " + oldName, e1);
        }
    }

    private void renameGetter(IMethod getter, String newName) throws InterruptedException {
        if (!getter.exists()) {
            return;
        }
        String oldName = getter.getElementName();
        String getterType = null;
        try {
            getterType = getter.getReturnType();
        }
        catch (JavaModelException e2) {
            JPADiagramEditorPlugin.logError("Can't obtain getter type", e2);
        }
        String newGetterName = String.valueOf("Z".equals(getterType) ? "is" : "get") + JPAEditorUtil.capitalizeFirstLetter(newName);
        if (oldName.equals(newGetterName)) {
            return;
        }
        try {
            RenameSupport s = RenameSupport.create((IMethod)getter, (String)newGetterName, (int)1);
            try {
                IWorkbenchWindow ww = JPADiagramEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                Shell sh = ww.getShell();
                s.perform(sh, (IRunnableContext)ww);
            }
            catch (InvocationTargetException e) {
                JPADiagramEditorPlugin.logError("Cannot rename the getter of the attribute " + oldName, e);
            }
        }
        catch (CoreException e1) {
            JPADiagramEditorPlugin.logError("Cannot rename the getter of the attribute " + oldName, e1);
        }
    }

    private void renameSetter(IMethod setter, String newName) throws InterruptedException {
        String newSetterName;
        if (!setter.exists()) {
            return;
        }
        String oldName = setter.getElementName();
        if (oldName.equals(newSetterName = "set" + JPAEditorUtil.capitalizeFirstLetter(newName))) {
            return;
        }
        try {
            RenameSupport s = RenameSupport.create((IMethod)setter, (String)newSetterName, (int)1);
            try {
                IWorkbenchWindow ww = JPADiagramEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                Shell sh = ww.getShell();
                s.perform(sh, (IRunnableContext)ww);
            }
            catch (InvocationTargetException e) {
                JPADiagramEditorPlugin.logError("Cannot rename the setter of the attribute " + oldName, e);
            }
        }
        catch (CoreException e1) {
            JPADiagramEditorPlugin.logError("Cannot rename the setter of the attribute " + oldName, e1);
        }
    }
}

