/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.tests;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.profiling.core.tests.CallStackTestBase2;
import org.eclipse.tracecompass.analysis.profiling.core.tests.stubs2.CallStackAnalysisStub;
import org.eclipse.tracecompass.analysis.profiling.core.tests.stubs2.CalledFunctionStub;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.junit.Assert;
import org.junit.Test;

public class CallStackSegmentStoreTest
extends CallStackTestBase2 {
    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testSeriesSegmentStoreIterator() {
        CallStackAnalysisStub module = this.getModule();
        Assert.assertNotNull((Object)((Object)module));
        @NonNull ISegmentStore segmentStore = module.getSegmentStore();
        Assert.assertNotNull((Object)segmentStore);
        @NonNull Iterator iterator = segmentStore.iterator();
        Assert.assertEquals((String)"Segment store iterator count", (long)18L, (long)Iterators.size((Iterator)iterator));
        Assert.assertEquals((String)"Segment store size", (long)18L, (long)segmentStore.size());
        Assert.assertFalse((boolean)segmentStore.isEmpty());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testIntersectingSegmentStore() {
        CallStackAnalysisStub module = this.getModule();
        Assert.assertNotNull((Object)((Object)module));
        @NonNull ISegmentStore segmentStore = module.getSegmentStore();
        Assert.assertNotNull((Object)segmentStore);
        @NonNull Iterable elements = segmentStore.getIntersectingElements(10L);
        Assert.assertEquals((String)"Intersecting 10", (long)9L, (long)Iterables.size((Iterable)elements));
        elements = segmentStore.getIntersectingElements(10L, 15L);
        Assert.assertEquals((String)"Between 10 and 15", (long)12L, (long)Iterables.size((Iterable)elements));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testContainsSegmentStoreInvalidInput() {
        CallStackAnalysisStub module = this.getModule();
        Assert.assertNotNull((Object)((Object)module));
        @NonNull ISegmentStore segmentStore = module.getSegmentStore();
        Assert.assertNotNull((Object)segmentStore);
        Assert.assertFalse((boolean)segmentStore.contains(null));
        Assert.assertFalse((boolean)segmentStore.containsAll(null));
        Assert.assertTrue((boolean)segmentStore.containsAll(Collections.emptyList()));
        CalledFunctionStub fakeSegment = new CalledFunctionStub(0L, 1L);
        Assert.assertFalse((boolean)segmentStore.contains((Object)fakeSegment));
        fakeSegment = new CalledFunctionStub(2L, 321321L);
        Assert.assertFalse((boolean)segmentStore.contains((Object)fakeSegment));
        fakeSegment = new CalledFunctionStub(-10L, -2L);
        Assert.assertFalse((boolean)segmentStore.contains((Object)fakeSegment));
        fakeSegment = new CalledFunctionStub(-10L, 10L);
        Assert.assertFalse((boolean)segmentStore.contains((Object)fakeSegment));
        fakeSegment = new CalledFunctionStub(0L, 10L);
        Assert.assertFalse((boolean)segmentStore.contains((Object)fakeSegment));
        fakeSegment = new CalledFunctionStub(32137216321L, 10L);
        Assert.assertFalse((boolean)segmentStore.contains((Object)fakeSegment));
        fakeSegment = new CalledFunctionStub(32137216321L, 32137216322L);
        Assert.assertFalse((boolean)segmentStore.contains((Object)fakeSegment));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testContainsSegmentStore() {
        CallStackAnalysisStub module = this.getModule();
        Assert.assertNotNull((Object)((Object)module));
        @NonNull ISegmentStore segmentStore = module.getSegmentStore();
        Assert.assertNotNull((Object)segmentStore);
        @NonNull Iterator segmentIterator = segmentStore.iterator();
        ArrayList<ISegment> segments = new ArrayList<ISegment>();
        while (segmentIterator.hasNext()) {
            ISegment segment = (ISegment)segmentIterator.next();
            Assert.assertTrue((boolean)segmentStore.contains((Object)segment));
            segments.add(segment);
            Assert.assertTrue((boolean)segmentStore.containsAll(segments));
        }
        while (!segments.isEmpty()) {
            segments.remove(0);
            Assert.assertTrue((boolean)segmentStore.containsAll(segments));
        }
    }
}

