/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.event.matching;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class TmfEventDependency {
    private final DependencyEvent fSource;
    private final DependencyEvent fDestination;

    public TmfEventDependency(DependencyEvent source, DependencyEvent destination) {
        this.fSource = source;
        this.fDestination = destination;
    }

    public DependencyEvent getSource() {
        return this.fSource;
    }

    public DependencyEvent getDestination() {
        return this.fDestination;
    }

    public static class DependencyEvent {
        private final @NonNull ITmfTrace fTrace;
        private final ITmfTimestamp fTimestamp;

        public DependencyEvent(ITmfEvent event) {
            this.fTrace = event.getTrace();
            this.fTimestamp = event.getTimestamp();
        }

        public ITmfTrace getTrace() {
            return this.fTrace;
        }

        public ITmfTimestamp getTimestamp() {
            return this.fTimestamp;
        }

        public int hashCode() {
            return Objects.hash(this.fTrace, this.fTimestamp);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DependencyEvent)) {
                return false;
            }
            DependencyEvent other = (DependencyEvent)obj;
            return Objects.equals(this.fTrace, other.fTrace) && Objects.equals(this.fTimestamp, other.fTimestamp);
        }
    }
}

