/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types;

import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiData;

public abstract class LamiNumber
extends LamiData {
    private final @Nullable Number fLowLimit;
    private final @Nullable Number fValue;
    private final @Nullable Number fHighLimit;

    public LamiNumber(Number value) {
        this.fValue = value;
        this.fLowLimit = null;
        this.fHighLimit = null;
    }

    public LamiNumber(@Nullable Number lowLimit, @Nullable Number value, @Nullable Number highLimit) {
        this.fLowLimit = lowLimit;
        this.fValue = value;
        this.fHighLimit = highLimit;
    }

    public @Nullable Number getLowerLimit() {
        return this.fLowLimit;
    }

    public @Nullable Number getValue() {
        return this.fValue;
    }

    public @Nullable Number getHigherLimit() {
        return this.fHighLimit;
    }

    @Override
    public @Nullable String toString() {
        if (this.fValue != null) {
            return this.fValue.toString();
        }
        return null;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LamiNumber number = (LamiNumber)object;
        return Objects.equals(this.fLowLimit, number.fLowLimit) && Objects.equals(this.fValue, number.fValue) && Objects.equals(this.fHighLimit, number.fHighLimit);
    }

    public int hashCode() {
        return Objects.hash(this.fLowLimit, this.fValue, this.fHighLimit);
    }
}

