/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.debuginfo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.debuginfo.TmfLibrarySymbol;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.BinaryCallsite;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.FunctionLocation;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.UstDebugInfoAnalysisModule;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.UstDebugInfoBinaryAspect;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.UstDebugInfoFunctionAspect;
import org.eclipse.tracecompass.lttng2.ust.core.trace.LttngUstTrace;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.symbols.DefaultSymbolProvider;
import org.eclipse.tracecompass.tmf.core.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderManager;
import org.eclipse.tracecompass.tmf.core.symbols.TmfResolvedSymbol;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class UstDebugInfoSymbolProvider
extends DefaultSymbolProvider {
    private final List<ISymbolProvider> fOtherProviders = new ArrayList<ISymbolProvider>();

    public UstDebugInfoSymbolProvider(LttngUstTrace trace) {
        super((ITmfTrace)trace);
    }

    void setConfiguredPathPrefix(LttngUstTrace.SymbolProviderConfig newConfig) {
        this.getTrace().setSymbolProviderConfig(newConfig);
    }

    public void loadConfiguration(@Nullable IProgressMonitor monitor) {
        super.loadConfiguration(monitor);
        for (ISymbolProvider provider : SymbolProviderManager.getInstance().getSymbolProviders((ITmfTrace)this.getTrace())) {
            if (provider instanceof DefaultSymbolProvider) continue;
            this.fOtherProviders.add(provider);
        }
    }

    public @NonNull LttngUstTrace getTrace() {
        return (LttngUstTrace)super.getTrace();
    }

    public @Nullable TmfResolvedSymbol getSymbol(int pid, long timestamp, long address) {
        LttngUstTrace trace = this.getTrace();
        BinaryCallsite bc = UstDebugInfoBinaryAspect.getBinaryCallsite(trace, pid, timestamp, address);
        if (bc == null) {
            return null;
        }
        String functionName = UstDebugInfoSymbolProvider.getFunctionNameFromSS(bc, (ITmfTrace)trace);
        if (functionName != null) {
            return new TmfResolvedSymbol(bc.getOffset(), functionName);
        }
        FunctionLocation loc = UstDebugInfoFunctionAspect.getFunctionFromBinaryLocation(bc);
        if (loc != null) {
            return new TmfResolvedSymbol(bc.getOffset(), loc.getFunctionName());
        }
        for (ISymbolProvider provider : this.fOtherProviders) {
            TmfResolvedSymbol symbol = provider.getSymbol(pid, timestamp, bc.getOffset());
            if (symbol == null) continue;
            return symbol;
        }
        return new TmfLibrarySymbol(bc.getOffset(), bc.getBinaryFilePath());
    }

    public static @Nullable String getFunctionNameFromSS(BinaryCallsite bc, ITmfTrace trace) {
        UstDebugInfoAnalysisModule ustDebugModule;
        ITmfStateSystem ustDebugSsb;
        Iterator ustDebugModules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, UstDebugInfoAnalysisModule.class).iterator();
        if (ustDebugModules.hasNext() && (ustDebugSsb = (ustDebugModule = (UstDebugInfoAnalysisModule)((Object)ustDebugModules.next())).getStateSystem()) != null) {
            String binFilePath = bc.getBinaryFilePath();
            long offset = bc.getOffset() + ustDebugSsb.getStartTime();
            try {
                int functionNameQuark = ustDebugSsb.getQuarkAbsolute(new String[]{binFilePath, "functionName"});
                ITmfStateInterval functionInterval = ustDebugSsb.querySingleState(offset, functionNameQuark);
                return functionInterval.getValueString();
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
            }
            catch (StateSystemDisposedException stateSystemDisposedException) {
                // empty catch block
            }
        }
        return null;
    }
}

