/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.menu.legend;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.SeriesListUI;
import org.eclipse.swtchart.extensions.menu.legend.AbstractMenuListener;

public class SeriesVisibilityAction
extends AbstractMenuListener {
    private boolean setVisible;
    private boolean inLegend;

    public SeriesVisibilityAction(SeriesListUI seriesListUI, boolean setVisible, boolean inLegend) {
        super(seriesListUI);
        this.setVisible = setVisible;
        this.inLegend = inLegend;
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        menuManager.add((IAction)new Action(){

            public String getText() {
                return String.valueOf(SeriesVisibilityAction.this.setVisible ? "Show" : "Hide") + " Series" + (SeriesVisibilityAction.this.inLegend ? " in Legend" : "");
            }

            public String getToolTipText() {
                return String.valueOf(SeriesVisibilityAction.this.setVisible ? "Show" : "Hide") + " the selected series " + (SeriesVisibilityAction.this.inLegend ? " in legend" : "") + ".";
            }

            public void run() {
                BaseChart baseChart = SeriesVisibilityAction.this.getBaseChart();
                List<ISeries<?>> selectedSeries = SeriesVisibilityAction.this.getSelectedSeries();
                for (ISeries<?> series : selectedSeries) {
                    ISeriesSettings seriesSettings = baseChart.getSeriesSettings(series.getId());
                    if (SeriesVisibilityAction.this.inLegend) {
                        seriesSettings.setVisibleInLegend(SeriesVisibilityAction.this.setVisible);
                    } else {
                        seriesSettings.setVisible(SeriesVisibilityAction.this.setVisible);
                    }
                    baseChart.applySeriesSettings(series, seriesSettings, true);
                }
                SeriesVisibilityAction.this.refresh();
            }
        });
    }
}

