/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.core.analysis.tasks;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.AbstractRosStateProvider;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.tasks.RosTasksAnalysis;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class RosTasksStateProvider
extends AbstractRosStateProvider {
    private static int VERSION_NUMBER = 0;

    public RosTasksStateProvider(ITmfTrace trace) {
        super(trace, RosTasksAnalysis.getFullAnalysisId());
    }

    @Override
    public int getVersion() {
        return VERSION_NUMBER;
    }

    @Override
    protected void eventHandle(@NonNull ITmfEvent event) {
        super.eventHandle(event);
        if (!RosTasksStateProvider.considerEvent(event)) {
            return;
        }
        ITmfStateSystemBuilder ss = Objects.requireNonNull(this.getStateSystemBuilder());
        if (RosTasksStateProvider.isEvent(event, this.fLayout.eventTaskStart())) {
            long timestamp = event.getTimestamp().toNanos();
            String nodeName = this.getNodeName(event);
            String fullTaskName = (String)RosTasksStateProvider.getField(event, this.fLayout.fieldTaskName());
            String shortTaskName = RosTasksStateProvider.extractGenericTaskName(fullTaskName);
            int taskQuark = ss.getQuarkAbsoluteAndAdd(new String[]{nodeName, shortTaskName});
            ss.modifyAttribute(timestamp, (Object)shortTaskName, taskQuark);
            return;
        }
    }
}

