/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.nls;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.KeyValuePair;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSSubstitution;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.PropertyFileDocumentModel;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.changes.CreateTextFileChange;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

public class NLSPropertyFileModifier {
    public static Change create(NLSSubstitution[] nlsSubstitutions, IPath propertyFilePath) throws CoreException {
        String name = Messages.format(NLSMessages.NLSPropertyFileModifier_change_name, propertyFilePath.toString());
        TextFileChange textChange = null;
        if (!Checks.resourceExists(propertyFilePath)) {
            IProject project = NLSPropertyFileModifier.getFileHandle(propertyFilePath).getProject();
            String lineDelimiter = StubUtility.getLineDelimiterPreference(project);
            Document document = new Document();
            document.setInitialLineDelimiter(lineDelimiter);
            textChange = new DocumentChange(name, (IDocument)document);
            NLSPropertyFileModifier.addChanges((TextChange)textChange, nlsSubstitutions);
            textChange.perform((IProgressMonitor)new NullProgressMonitor());
            String encoding = null;
            IContentType javaPropertiesContentType = Platform.getContentTypeManager().getContentType("org.eclipse.wst.jsdt.core.javaProperties");
            IContentType[] contentTypes = Platform.getContentTypeManager().findContentTypesFor(propertyFilePath.lastSegment());
            if (contentTypes.length == 0 || contentTypes.length > 1 || !contentTypes[0].equals(javaPropertiesContentType)) {
                if (javaPropertiesContentType != null) {
                    encoding = javaPropertiesContentType.getDefaultCharset();
                }
                if (encoding == null) {
                    encoding = "ISO-8859-1";
                }
            }
            return new CreateTextFileChange(propertyFilePath, textChange.getCurrentContent((IProgressMonitor)new NullProgressMonitor()), encoding, "properties");
        }
        textChange = new TextFileChange(name, NLSPropertyFileModifier.getPropertyFile(propertyFilePath));
        textChange.setTextType("properties");
        NLSPropertyFileModifier.addChanges((TextChange)textChange, nlsSubstitutions);
        return textChange;
    }

    private static IFile getPropertyFile(IPath propertyFilePath) {
        return (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(propertyFilePath);
    }

    private static IFile getFileHandle(IPath propertyFilePath) {
        if (propertyFilePath == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile(propertyFilePath);
    }

    private static void addChanges(TextChange textChange, NLSSubstitution[] substitutions) throws CoreException {
        PropertyFileDocumentModel model = new PropertyFileDocumentModel(textChange.getCurrentDocument((IProgressMonitor)new NullProgressMonitor()));
        HashMap newKeyToSubstMap = NLSPropertyFileModifier.getNewKeyToSubstitutionMap(substitutions);
        HashMap oldKeyToSubstMap = NLSPropertyFileModifier.getOldKeyToSubstitutionMap(substitutions);
        NLSPropertyFileModifier.addInsertEdits(textChange, substitutions, newKeyToSubstMap, oldKeyToSubstMap, model);
        NLSPropertyFileModifier.addRemoveEdits(textChange, substitutions, newKeyToSubstMap, oldKeyToSubstMap, model);
        NLSPropertyFileModifier.addReplaceEdits(textChange, substitutions, newKeyToSubstMap, oldKeyToSubstMap, model);
    }

    static HashMap getNewKeyToSubstitutionMap(NLSSubstitution[] substitutions) {
        HashMap<String, NLSSubstitution> keyToSubstMap = new HashMap<String, NLSSubstitution>(substitutions.length);
        int i = 0;
        while (i < substitutions.length) {
            NLSSubstitution val;
            NLSSubstitution curr = substitutions[i];
            if (curr.getState() == 0 && ((val = (NLSSubstitution)keyToSubstMap.get(curr.getKey())) == null || val.hasPropertyFileChange() && !curr.hasPropertyFileChange())) {
                keyToSubstMap.put(curr.getKey(), curr);
            }
            ++i;
        }
        return keyToSubstMap;
    }

    static HashMap getOldKeyToSubstitutionMap(NLSSubstitution[] substitutions) {
        HashMap<String, NLSSubstitution> keyToSubstMap = new HashMap<String, NLSSubstitution>(substitutions.length);
        int i = 0;
        while (i < substitutions.length) {
            NLSSubstitution fav;
            String key;
            NLSSubstitution curr = substitutions[i];
            if (curr.getInitialState() == 0 && (key = curr.getInitialKey()) != null && ((fav = (NLSSubstitution)keyToSubstMap.get(key)) == null || fav.hasStateChanged() && !curr.hasStateChanged())) {
                keyToSubstMap.put(key, curr);
            }
            ++i;
        }
        return keyToSubstMap;
    }

    static boolean doReplace(NLSSubstitution substitution, Map newKeyToSubstMap, Map oldKeyToSubstMap) {
        if (substitution.getState() != 0 || substitution.hasStateChanged() || substitution.getInitialValue() == null) {
            return false;
        }
        if (oldKeyToSubstMap.get(substitution.getInitialKey()) != substitution) {
            return false;
        }
        return (substitution.isKeyRename() || substitution.isValueRename()) && newKeyToSubstMap.get(substitution.getKey()) == substitution;
    }

    private static void addReplaceEdits(TextChange textChange, NLSSubstitution[] substitutions, Map newKeyToSubstMap, Map oldKeyToSubstMap, PropertyFileDocumentModel model) {
        int i = 0;
        while (i < substitutions.length) {
            KeyValuePair newPair;
            KeyValuePair initialPair;
            ReplaceEdit edit;
            NLSSubstitution substitution = substitutions[i];
            if (NLSPropertyFileModifier.doReplace(substitution, newKeyToSubstMap, oldKeyToSubstMap) && (edit = model.replace(initialPair = new KeyValuePair(substitution.getInitialKey(), substitution.getInitialValue()), newPair = new KeyValuePair(substitution.getKey(), substitution.getValueNonEmpty()))) != null) {
                TextChangeCompatibility.addTextEdit(textChange, Messages.format(NLSMessages.NLSPropertyFileModifier_replace_entry, substitution.getKey()), (TextEdit)edit);
            }
            ++i;
        }
    }

    static boolean doInsert(NLSSubstitution substitution, Map newKeyToSubstMap, Map oldKeyToSubstMap) {
        if (substitution.getState() != 0) {
            return false;
        }
        if (!(substitution.hasStateChanged() || substitution.getInitialValue() == null || substitution.isKeyRename() && oldKeyToSubstMap.get(substitution.getInitialKey()) != substitution)) {
            return false;
        }
        return newKeyToSubstMap.get(substitution.getKey()) == substitution;
    }

    private static void addInsertEdits(TextChange textChange, NLSSubstitution[] substitutions, Map newKeyToSubstMap, Map oldKeyToSubstMap, PropertyFileDocumentModel model) {
        int i = 0;
        while (i < substitutions.length) {
            NLSSubstitution substitution = substitutions[i];
            if (NLSPropertyFileModifier.doInsert(substitution, newKeyToSubstMap, oldKeyToSubstMap)) {
                String value = substitution.getValueNonEmpty();
                KeyValuePair curr = new KeyValuePair(substitution.getKey(), value);
                InsertEdit insert = model.insert(curr);
                String message = Messages.format(NLSMessages.NLSPropertyFileModifier_add_entry, curr.getKey());
                TextChangeCompatibility.addTextEdit(textChange, message, (TextEdit)insert);
            }
            ++i;
        }
    }

    static boolean doRemove(NLSSubstitution substitution, Map newKeyToSubstMap, Map oldKeyToSubstMap) {
        if (substitution.getInitialState() != 0 || substitution.getInitialKey() == null) {
            return false;
        }
        if (oldKeyToSubstMap.get(substitution.getInitialKey()) != substitution) {
            return false;
        }
        if (substitution.hasStateChanged()) {
            return true;
        }
        return substitution.hasPropertyFileChange() && newKeyToSubstMap.get(substitution.getKey()) != substitution;
    }

    private static void addRemoveEdits(TextChange textChange, NLSSubstitution[] substitutions, Map newKeyToSubstMap, Map oldKeyToSubstMap, PropertyFileDocumentModel model) {
        int i = 0;
        while (i < substitutions.length) {
            DeleteEdit edit;
            NLSSubstitution substitution = substitutions[i];
            if (NLSPropertyFileModifier.doRemove(substitution, newKeyToSubstMap, oldKeyToSubstMap) && (edit = model.remove(substitution.getInitialKey())) != null) {
                TextChangeCompatibility.addTextEdit(textChange, Messages.format(NLSMessages.NLSPropertyFileModifier_remove_entry, substitution.getInitialKey()), (TextEdit)edit);
            }
            ++i;
        }
    }
}

