/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header;

import java.nio.ByteOrder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceEventFormat;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceEventSystem;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceFileCPU;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceFileType;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceFormatField;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceFunctionAddressNameMapping;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceHeaderEvent;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceOption;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceVersion;

public class BinaryFTraceHeaderInfo {
    private String fFilePath;
    private final BinaryFTraceVersion fVersion;
    private final ByteOrder fEndianess;
    private final int fLongValueSize;
    private final int fHostMachinePageSize;
    private final BinaryFTraceFileType fFileType;
    private List<BinaryFTraceFormatField> fHeaderPageFields;
    private BinaryFTraceHeaderEvent fHeaderEventInfo;
    private Map<Integer, BinaryFTraceEventFormat> fFTraceEventFormats;
    private List<BinaryFTraceEventSystem> fEventSystems;
    private Map<String, BinaryFTraceFunctionAddressNameMapping> fFunctionMapping;
    private Map<String, String> fPrintKPointerStringMapping;
    private Map<Integer, String> fProcessIDNameMapping;
    private List<BinaryFTraceOption> fOptions;
    private Map<String, BinaryFTraceFormatField> fEventCommonFields;
    private List<BinaryFTraceFileCPU> cpus;

    private BinaryFTraceHeaderInfo(BinaryFTraceHeaderInfoBuilder builder) {
        this.fFilePath = builder.fBuilderFilePath;
        this.fVersion = builder.fBuilderVersion;
        this.fEndianess = builder.fBuilderEndianess;
        this.fLongValueSize = builder.fBuilderLongValueSize;
        this.fHostMachinePageSize = builder.fBuilderHostMachinePageSize;
        this.fFileType = builder.fBuilderFileType;
        this.fHeaderPageFields = builder.fBuilderHeaderPageFields;
        this.fHeaderEventInfo = builder.fBuilderHeaderEventInfo;
        this.fFTraceEventFormats = builder.fBuilderFTraceEventFormats;
        this.fEventSystems = builder.fBuilderEventSystems;
        this.fFunctionMapping = builder.fBuilderFunctionMapping;
        this.fPrintKPointerStringMapping = builder.fBuilderPrintKPointerStringMapping;
        this.fProcessIDNameMapping = builder.fBuilderProcessIDNameMapping;
        this.fOptions = builder.fBuilderOptions;
        this.fEventCommonFields = builder.fBuilderEventCommonFields;
        this.cpus = builder.fBuilderCpus;
    }

    public String getFilePath() {
        return this.fFilePath;
    }

    public void setFilePath(String filePath) {
        this.fFilePath = filePath;
    }

    public BinaryFTraceVersion getVersion() {
        return this.fVersion;
    }

    public ByteOrder getEndianess() {
        return this.fEndianess;
    }

    public int getLongValueSize() {
        return this.fLongValueSize;
    }

    public int getHostMachinePageSize() {
        return this.fHostMachinePageSize;
    }

    public Map<Integer, BinaryFTraceEventFormat> getFTraceEventFormats() {
        return this.fFTraceEventFormats;
    }

    public Map<String, BinaryFTraceFormatField> getEventCommonFields() {
        return this.fEventCommonFields;
    }

    public BinaryFTraceHeaderEvent getHeaderEventInfo() {
        return this.fHeaderEventInfo;
    }

    public List<BinaryFTraceFormatField> getHeaderPageFields() {
        return this.fHeaderPageFields;
    }

    public List<BinaryFTraceOption> getOptions() {
        return this.fOptions;
    }

    public List<BinaryFTraceEventSystem> getEventSystems() {
        return this.fEventSystems;
    }

    public Map<String, BinaryFTraceFunctionAddressNameMapping> getFunctionMapping() {
        return this.fFunctionMapping;
    }

    public Map<String, String> getPrintKPointerStringMapping() {
        return this.fPrintKPointerStringMapping;
    }

    public Map<Integer, String> getProcessIDNameMapping() {
        return this.fProcessIDNameMapping;
    }

    public BinaryFTraceEventFormat getEventFormatByID(int eventTypeID) {
        if (this.fFTraceEventFormats.containsKey(eventTypeID)) {
            return this.fFTraceEventFormats.get(eventTypeID);
        }
        for (BinaryFTraceEventSystem eventSystem : this.fEventSystems) {
            if (!eventSystem.getMapEventFormat().containsKey(eventTypeID)) continue;
            return eventSystem.getMapEventFormat().get(eventTypeID);
        }
        return null;
    }

    public List<BinaryFTraceFileCPU> getCpus() {
        return this.cpus;
    }

    public BinaryFTraceFileType getFileType() {
        return this.fFileType;
    }

    public String getTraceHeaderString() {
        String key;
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("Endianess: ");
        if (this.fEndianess == ByteOrder.LITTLE_ENDIAN) {
            strBuilder.append("Little endian");
        } else if (this.fEndianess == ByteOrder.BIG_ENDIAN) {
            strBuilder.append("Big endian");
        }
        strBuilder.append('\n');
        strBuilder.append("Number of byte per long values: ").append(this.fLongValueSize).append('\n');
        strBuilder.append("Host machine page size: ").append(this.fHostMachinePageSize).append('\n');
        strBuilder.append("Header page fields:").append('\n');
        for (BinaryFTraceFormatField field : this.fHeaderPageFields) {
            strBuilder.append(field).append('\n');
        }
        strBuilder.append("Header event info:").append('\n').append(this.fHeaderEventInfo).append('\n');
        strBuilder.append("Number of FTrace formats: ").append(this.fFTraceEventFormats.size()).append('\n');
        String sample = "Sample:";
        if (this.fFTraceEventFormats.size() > 0) {
            strBuilder.append(sample).append('\n');
            int key2 = this.fFTraceEventFormats.keySet().iterator().next();
            strBuilder.append(this.fFTraceEventFormats.get(key2));
        }
        strBuilder.append('\n');
        strBuilder.append("Number of event systems: ").append(this.fEventSystems.size()).append('\n');
        if (!this.fEventSystems.isEmpty()) {
            strBuilder.append("First system:").append('\n');
            BinaryFTraceEventSystem eventSystem = this.fEventSystems.get(0);
            strBuilder.append("Event system name: ").append(eventSystem.getSystemName()).append('\n');
            strBuilder.append("Number of events: ").append(eventSystem.getMapEventFormat().size()).append('\n');
            if (eventSystem.getMapEventFormat().size() > 0) {
                int key3 = eventSystem.getMapEventFormat().keySet().iterator().next();
                strBuilder.append(eventSystem.getMapEventFormat().get(key3));
            }
        }
        strBuilder.append('\n');
        strBuilder.append("Number of address to functions mappings: ").append(this.fFunctionMapping.size()).append('\n');
        if (this.fFunctionMapping.size() > 0) {
            strBuilder.append("Sample: ").append('\n');
            key = this.fFunctionMapping.keySet().iterator().next();
            strBuilder.append(this.fFunctionMapping.get(key));
        }
        strBuilder.append('\n').append('\n');
        strBuilder.append("Number of pointer address to string mappings: ").append(this.fPrintKPointerStringMapping.size()).append('\n');
        if (this.fPrintKPointerStringMapping.size() > 0) {
            strBuilder.append(sample).append('\n');
            key = this.fPrintKPointerStringMapping.keySet().iterator().next();
            strBuilder.append("Pointer address: ").append(key);
            strBuilder.append("; String: ").append(this.fPrintKPointerStringMapping.get(key));
        }
        strBuilder.append('\n').append('\n');
        strBuilder.append("File type: ").append((Object)this.fFileType).append('\n');
        strBuilder.append("Number of process ID to name mapping: ").append(this.fProcessIDNameMapping.size()).append('\n');
        if (this.fProcessIDNameMapping.size() > 0) {
            strBuilder.append(sample).append('\n');
            int key4 = this.fProcessIDNameMapping.keySet().iterator().next();
            strBuilder.append("Process ID: ").append(key4);
            strBuilder.append("; Name: ").append(this.fProcessIDNameMapping.get(key4));
        }
        strBuilder.append('\n').append('\n');
        strBuilder.append("Number of options: ").append(this.fOptions.size()).append('\n');
        if (!this.fOptions.isEmpty()) {
            strBuilder.append(sample).append('\n');
            strBuilder.append(this.fOptions.get(0));
        }
        strBuilder.append('\n');
        if (this.fFileType == BinaryFTraceFileType.FLY_RECORD && this.cpus != null && !this.cpus.isEmpty()) {
            strBuilder.append("Number of CPUS: ").append(this.cpus.size()).append('\n');
            for (BinaryFTraceFileCPU cpu : this.cpus) {
                strBuilder.append("CPU#: ").append(cpu.getCpuNumber()).append('\n').append("Section size: ").append(cpu.getSectionSize()).append('\n').append("Number of pages: ").append(cpu.getPages().size()).append('\n');
            }
        }
        return strBuilder.toString();
    }

    public static class BinaryFTraceHeaderInfoBuilder {
        private String fBuilderFilePath = "";
        private BinaryFTraceVersion fBuilderVersion = BinaryFTraceVersion.NOT_SUPPORTED;
        private ByteOrder fBuilderEndianess = ByteOrder.BIG_ENDIAN;
        private int fBuilderLongValueSize = -1;
        private int fBuilderHostMachinePageSize = 0;
        private BinaryFTraceFileType fBuilderFileType = BinaryFTraceFileType.LATENCY;
        private List<BinaryFTraceFormatField> fBuilderHeaderPageFields = null;
        private BinaryFTraceHeaderEvent fBuilderHeaderEventInfo = null;
        private Map<Integer, BinaryFTraceEventFormat> fBuilderFTraceEventFormats = null;
        private List<BinaryFTraceEventSystem> fBuilderEventSystems = null;
        private Map<String, BinaryFTraceFunctionAddressNameMapping> fBuilderFunctionMapping = null;
        private Map<String, String> fBuilderPrintKPointerStringMapping = null;
        private Map<Integer, String> fBuilderProcessIDNameMapping = null;
        private List<BinaryFTraceOption> fBuilderOptions = null;
        private Map<String, BinaryFTraceFormatField> fBuilderEventCommonFields = null;
        private List<BinaryFTraceFileCPU> fBuilderCpus = null;

        public BinaryFTraceHeaderInfoBuilder filePath(String builderFilePath) {
            this.fBuilderFilePath = builderFilePath;
            return this;
        }

        public BinaryFTraceHeaderInfoBuilder version(BinaryFTraceVersion builderVersion) {
            this.fBuilderVersion = builderVersion;
            return this;
        }

        public BinaryFTraceHeaderInfoBuilder endianess(ByteOrder builderEndianess) {
            this.fBuilderEndianess = builderEndianess;
            return this;
        }

        public BinaryFTraceHeaderInfoBuilder longValueSize(int builderLongValueSize) {
            this.fBuilderLongValueSize = builderLongValueSize;
            return this;
        }

        public BinaryFTraceHeaderInfoBuilder hostMachinePageSize(int builderHostMachinePageSize) {
            this.fBuilderHostMachinePageSize = builderHostMachinePageSize;
            return this;
        }

        public BinaryFTraceHeaderInfoBuilder fileType(BinaryFTraceFileType builderFileType) {
            this.fBuilderFileType = builderFileType;
            return this;
        }

        public BinaryFTraceHeaderInfoBuilder headerPageFields(List<BinaryFTraceFormatField> builderHeaderPageFields) {
            this.fBuilderHeaderPageFields = builderHeaderPageFields;
            return this;
        }

        public BinaryFTraceHeaderInfoBuilder headerEventInfo(BinaryFTraceHeaderEvent builderHeaderEventInfo) {
            this.fBuilderHeaderEventInfo = builderHeaderEventInfo;
            return this;
        }

        public BinaryFTraceHeaderInfoBuilder fTraceEventFormats(Map<Integer, BinaryFTraceEventFormat> builderFTraceEventFormats) {
            this.fBuilderFTraceEventFormats = builderFTraceEventFormats;
            return this;
        }

        public BinaryFTraceHeaderInfoBuilder eventSystems(List<BinaryFTraceEventSystem> builderEventSystems) {
            this.fBuilderEventSystems = builderEventSystems;
            return this;
        }

        public BinaryFTraceHeaderInfoBuilder functionMapping(Map<String, BinaryFTraceFunctionAddressNameMapping> builderFunctionMapping) {
            this.fBuilderFunctionMapping = builderFunctionMapping;
            return this;
        }

        public BinaryFTraceHeaderInfoBuilder printKPointerStringMapping(Map<String, String> builderPrintKPointerStringMapping) {
            this.fBuilderPrintKPointerStringMapping = builderPrintKPointerStringMapping;
            return this;
        }

        public BinaryFTraceHeaderInfoBuilder processIDNameMapping(Map<Integer, String> builderProcessIDNameMapping) {
            this.fBuilderProcessIDNameMapping = builderProcessIDNameMapping;
            return this;
        }

        public BinaryFTraceHeaderInfoBuilder options(List<BinaryFTraceOption> builderOptions) {
            this.fBuilderOptions = builderOptions;
            return this;
        }

        public BinaryFTraceHeaderInfoBuilder eventCommonFields(Map<String, BinaryFTraceFormatField> builderEventCommonFields) {
            this.fBuilderEventCommonFields = builderEventCommonFields;
            return this;
        }

        public BinaryFTraceHeaderInfoBuilder cpus(List<BinaryFTraceFileCPU> builderCpus) {
            this.fBuilderCpus = builderCpus;
            return this;
        }

        public BinaryFTraceHeaderInfo build() {
            this.fBuilderEventCommonFields = this.getCommonFields();
            return new BinaryFTraceHeaderInfo(this);
        }

        private Map<String, BinaryFTraceFormatField> getCommonFields() {
            if (!this.fBuilderFTraceEventFormats.isEmpty()) {
                return BinaryFTraceHeaderInfoBuilder.getFirst(this.fBuilderFTraceEventFormats);
            }
            if (!this.fBuilderEventSystems.isEmpty() && this.fBuilderEventSystems.get(0).getMapEventFormat().size() > 0) {
                Map<Integer, BinaryFTraceEventFormat> map = this.fBuilderEventSystems.get(0).getMapEventFormat();
                return BinaryFTraceHeaderInfoBuilder.getFirst(map);
            }
            return Collections.emptyMap();
        }

        private static Map<String, BinaryFTraceFormatField> getFirst(Map<Integer, BinaryFTraceEventFormat> map) {
            Optional<BinaryFTraceEventFormat> first = map.values().stream().findFirst();
            if (first.isPresent()) {
                return first.get().getCommonFields();
            }
            return Collections.emptyMap();
        }
    }
}

