/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.samples;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tm4e.ui.internal.samples.Sample;
import org.eclipse.tm4e.ui.samples.ISample;
import org.eclipse.tm4e.ui.samples.ISampleManager;

public final class SampleManager
implements ISampleManager {
    private static final ISample[] NO_SAMPLES = new ISample[0];
    private static final String SAMPLE_ELT = "sample";
    private static final String SNIPPET_ELT = "snippet";
    private static final String EXTENSION_SAMPLES = "samples";
    private static final String EXTENSION_SNIPPETS = "snippets";
    private final Map<String, List<ISample>> samples = new HashMap<String, List<ISample>>();

    public static ISampleManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private SampleManager() {
    }

    private void load() {
        this.loadGrammarsFromExtensionPoints();
    }

    private void loadGrammarsFromExtensionPoints() {
        IConfigurationElement[] samplesCF;
        IConfigurationElement[] snippetsCF;
        IConfigurationElement[] iConfigurationElementArray = snippetsCF = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.tm4e.ui", EXTENSION_SNIPPETS);
        int n = snippetsCF.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            String extensionName = ce.getName();
            if (SNIPPET_ELT.equals(extensionName)) {
                this.registerSample(new Sample(ce));
            }
            ++n2;
        }
        IConfigurationElement[] iConfigurationElementArray2 = samplesCF = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.tm4e.ui", EXTENSION_SAMPLES);
        int n3 = samplesCF.length;
        n = 0;
        while (n < n3) {
            IConfigurationElement ce = iConfigurationElementArray2[n];
            String extensionName = ce.getName();
            if (SAMPLE_ELT.equals(extensionName)) {
                this.registerSample(new Sample(ce));
            }
            ++n;
        }
    }

    private void registerSample(Sample sample) {
        String scopeName = sample.getScopeName();
        this.samples.computeIfAbsent(scopeName, unused -> new ArrayList()).add(sample);
    }

    @Override
    public ISample[] getSamples(String scopeName) {
        List<ISample> samples = this.samples.get(scopeName);
        return samples != null ? (ISample[])samples.toArray(ISample[]::new) : NO_SAMPLES;
    }

    private static final class InstanceHolder {
        static final SampleManager INSTANCE = new SampleManager();

        static {
            INSTANCE.load();
        }

        private InstanceHolder() {
        }
    }
}

