/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.registry.internal;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.registry.IGrammarSource;
import org.eclipse.tm4e.core.registry.IRegistryOptions;
import org.eclipse.tm4e.registry.IGrammarDefinition;
import org.eclipse.tm4e.registry.IGrammarRegistryManager;
import org.eclipse.tm4e.registry.ITMScope;
import org.eclipse.tm4e.registry.internal.ReloadingRegistry;
import org.eclipse.tm4e.registry.internal.TMScope;

abstract class AbstractGrammarRegistryManager
implements IGrammarRegistryManager {
    protected final GrammarDefinitions pluginDefinitions = new GrammarDefinitions();
    protected final GrammarDefinitions userDefinitions = new GrammarDefinitions();
    protected final Map<IContentType, ContentTypeToScopeBinding> contentTypeToScopeBindings = new HashMap<IContentType, ContentTypeToScopeBinding>();
    protected final Map<String, Collection<String>> injections = new HashMap<String, Collection<String>>();
    private final ReloadingRegistry registry;

    static String getQualifiedScopeName(String scopeName, String pluginId) {
        return scopeName + "@" + pluginId;
    }

    protected AbstractGrammarRegistryManager() {
        this.registry = new ReloadingRegistry(new IRegistryOptions(){

            public @Nullable Collection<String> getInjections(String scopeName) {
                return AbstractGrammarRegistryManager.this.getInjections(scopeName);
            }

            public @Nullable IGrammarSource getGrammarSource(String scopeName) {
                IGrammarDefinition definition = AbstractGrammarRegistryManager.this.userDefinitions.getBestForScope(scopeName);
                if (definition == null) {
                    definition = AbstractGrammarRegistryManager.this.pluginDefinitions.getBestForScope(scopeName);
                }
                if (definition == null) {
                    return null;
                }
                final IGrammarDefinition definition_ = definition;
                return new IGrammarSource(){

                    public URI getURI() {
                        return definition_.getURI();
                    }

                    public Reader getReader() throws IOException {
                        return new InputStreamReader(definition_.getInputStream());
                    }

                    public long getLastModified() {
                        return definition_.getLastModified();
                    }
                };
            }
        });
    }

    AbstractGrammarRegistryManager(IRegistryOptions options) {
        this.registry = new ReloadingRegistry(options);
    }

    @Override
    public @Nullable IGrammar getGrammarFor(IContentType ... contentTypes) {
        IContentType[] iContentTypeArray = contentTypes;
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            @Nullable IContentType contentType = iContentTypeArray[n2];
            while (contentType != null) {
                ContentTypeToScopeBinding binding = this.contentTypeToScopeBindings.get(contentType);
                if (binding == null) {
                    contentType = contentType.getBaseType();
                    continue;
                }
                IGrammar grammar = this.getGrammarForScope(binding.scope.getQualifiedName());
                if (grammar != null) {
                    return grammar;
                }
                grammar = this.getGrammarForScope(binding.scope.getName());
                if (grammar == null) continue;
                return grammar;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public @Nullable IGrammar getGrammarForScope(ITMScope scope) {
        return this.getGrammarForScope(scope.getQualifiedName());
    }

    private @Nullable IGrammar getGrammarForScope(String scopeName) {
        IGrammar grammar = this.registry.grammarForScopeName(scopeName);
        return grammar == null ? this.registry.loadGrammar(scopeName) : grammar;
    }

    @Override
    public @Nullable IGrammar getGrammarForFileExtension(String fileExt) {
        String desiredFileExt;
        String string = desiredFileExt = fileExt.startsWith(".") ? fileExt.substring(1) : fileExt;
        if (desiredFileExt.isBlank()) {
            return null;
        }
        block0: for (ContentTypeToScopeBinding binding : this.contentTypeToScopeBindings.values()) {
            String[] stringArray = binding.contentType.getFileSpecs(8);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String contentTypeFileExt = stringArray[n2];
                if (contentTypeFileExt.equals(desiredFileExt)) {
                    IGrammar grammar = this.getGrammarForScope(binding.scope.getQualifiedName());
                    if (grammar != null) {
                        return grammar;
                    }
                    grammar = this.getGrammarForScope(binding.scope.getName());
                    if (grammar == null) continue block0;
                    return grammar;
                }
                ++n2;
            }
        }
        Optional<IGrammar> result = Stream.concat(this.userDefinitions.stream(), this.pluginDefinitions.stream()).map(definition -> {
            IGrammar grammarForScope = this.getGrammarForScope(definition.getScope());
            return grammarForScope != null && grammarForScope.getFileTypes().contains(desiredFileExt) ? grammarForScope : null;
        }).filter(Objects::nonNull).findFirst();
        return result.isPresent() ? result.get() : null;
    }

    @Override
    public IGrammarDefinition[] getDefinitions() {
        return (IGrammarDefinition[])Stream.concat(this.pluginDefinitions.stream(), this.userDefinitions.stream()).toArray(IGrammarDefinition[]::new);
    }

    @Override
    public @Nullable Collection<String> getInjections(String scopeName) {
        return this.getInjections(TMScope.parse(scopeName));
    }

    @Override
    public @Nullable Collection<String> getInjections(ITMScope scope) {
        return this.injections.get(scope.getName());
    }

    void registerInjection(TMScope scopeName, String injectTo) {
        Collection<String> injectionsOfScope = this.getInjections(injectTo);
        if (injectionsOfScope == null) {
            injectionsOfScope = new ArrayList<String>();
            this.injections.put(injectTo, injectionsOfScope);
        }
        injectionsOfScope.add(scopeName.toString());
    }

    @Override
    public @Nullable Collection<IContentType> getContentTypesForScope(ITMScope scope) {
        return this.contentTypeToScopeBindings.values().stream().filter(binding -> scope.equals(binding.scope)).map(binding -> binding.contentType).toList();
    }

    protected void registerContentTypeToScopeBinding(String pluginId, IContentType contentType, String scopeName) {
        this.contentTypeToScopeBindings.put(contentType, new ContentTypeToScopeBinding(pluginId, contentType, scopeName));
    }

    protected void registerGrammarDefinition(IGrammarDefinition definition) {
        if (definition.getPluginId() == null) {
            this.userDefinitions.add(definition);
        } else {
            this.pluginDefinitions.add(definition);
        }
    }

    protected void unregisterGrammarDefinition(IGrammarDefinition definition) {
        if (definition.getPluginId() == null) {
            this.userDefinitions.remove(definition);
        } else {
            this.pluginDefinitions.remove(definition);
        }
    }

    private record ContentTypeToScopeBinding(IContentType contentType, TMScope scope) {
        ContentTypeToScopeBinding(String pluginId, IContentType contentType, String scopeName) {
            this(contentType, new TMScope(scopeName, pluginId));
        }
    }

    static final class GrammarDefinitions {
        final Map<String, @Nullable IGrammarDefinition> byQualifiedScopeName = new HashMap<String, IGrammarDefinition>();
        final Map<String, List<IGrammarDefinition>> byUnqualifiedScopeName = new HashMap<String, List<IGrammarDefinition>>();

        GrammarDefinitions() {
        }

        void add(IGrammarDefinition definition) {
            ITMScope scope = definition.getScope();
            if (scope.isQualified()) {
                this.byQualifiedScopeName.put(scope.getQualifiedName(), definition);
            }
            this.byUnqualifiedScopeName.computeIfAbsent(scope.getName(), unused -> new ArrayList()).add(definition);
        }

        @Nullable IGrammarDefinition getBestForScope(String scopeName) {
            IGrammarDefinition definition = this.byQualifiedScopeName.get(scopeName);
            if (definition != null) {
                return definition;
            }
            List<IGrammarDefinition> definitionsOfScope = this.byUnqualifiedScopeName.get(scopeName);
            return definitionsOfScope == null ? null : definitionsOfScope.get(0);
        }

        void remove(IGrammarDefinition definition) {
            List<IGrammarDefinition> definitionsOfScope;
            ITMScope scope = definition.getScope();
            if (scope.isQualified()) {
                this.byQualifiedScopeName.remove(scope.getQualifiedName());
            }
            if ((definitionsOfScope = this.byUnqualifiedScopeName.get(scope.getName())) != null) {
                definitionsOfScope.remove(definition);
                if (definitionsOfScope.isEmpty()) {
                    this.byUnqualifiedScopeName.remove(scope.getName());
                }
            }
        }

        Stream<IGrammarDefinition> stream() {
            return this.byUnqualifiedScopeName.values().stream().flatMap(Collection::stream);
        }
    }
}

