/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver;

import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.rse.services.clientserver.IMatcher;

public class FileTypeMatcher
implements IMatcher {
    public static final char SEP_EXTENSION = '.';
    private String[] orgTypes;
    private String[] types;
    private String[] orgNames;
    private String[] names;
    private boolean caseSensitive = false;

    public FileTypeMatcher(String[] types) {
        this(types, false);
    }

    public FileTypeMatcher(String[] types, boolean caseSensitive) {
        this.setTypes(types);
        this.setCaseSensitive(caseSensitive);
    }

    public void setTypes(String[] types) {
        this.types = types;
        this.orgTypes = types;
        this.setCaseSensitive(this.caseSensitive);
    }

    public void setTypesAndNames(String[] types, String[] names) {
        this.types = types;
        this.orgTypes = types;
        this.names = names;
        this.orgNames = names;
        this.setCaseSensitive(this.caseSensitive);
    }

    public void setTypesAndNames(String[] typesAndNames) {
        Vector<String> typesVector = new Vector<String>();
        Vector<String> namesVector = new Vector<String>();
        int idx = 0;
        while (idx < typesAndNames.length) {
            if (typesAndNames[idx].indexOf(46) != -1) {
                namesVector.add(typesAndNames[idx]);
            } else {
                typesVector.add(typesAndNames[idx]);
            }
            ++idx;
        }
        this.orgTypes = new String[typesVector.size()];
        this.orgNames = new String[namesVector.size()];
        idx = 0;
        while (idx < this.orgTypes.length) {
            this.orgTypes[idx] = (String)typesVector.elementAt(idx);
            ++idx;
        }
        idx = 0;
        while (idx < this.orgNames.length) {
            this.orgNames[idx] = (String)namesVector.elementAt(idx);
            ++idx;
        }
        this.types = this.orgTypes;
        this.names = this.orgNames;
        this.setCaseSensitive(this.caseSensitive);
    }

    public String[] getTypes() {
        return this.orgTypes;
    }

    public String[] getNames() {
        return this.orgNames;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        int idx;
        this.caseSensitive = caseSensitive;
        if (!caseSensitive && this.types != null) {
            this.types = new String[this.orgTypes.length];
            idx = 0;
            while (idx < this.types.length) {
                this.types[idx] = this.orgTypes[idx].toLowerCase();
                ++idx;
            }
        } else {
            this.types = this.orgTypes;
        }
        if (!caseSensitive && this.names != null) {
            this.names = new String[this.orgNames.length];
            idx = 0;
            while (idx < this.names.length) {
                this.names[idx] = this.orgNames[idx].toLowerCase();
                ++idx;
            }
        } else {
            this.names = this.orgNames;
        }
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean matches(String fileName) {
        boolean matches;
        block10: {
            int dotIdx;
            block11: {
                matches = false;
                String type = null;
                if (fileName == null) break block10;
                if (this.names != null) {
                    String name = null;
                    name = !this.caseSensitive ? fileName.toLowerCase() : fileName;
                    int idx = 0;
                    while (!matches && idx < this.names.length) {
                        if (name.equals(this.names[idx])) {
                            matches = true;
                        } else if (this.names[idx].endsWith(".null") && name.equals(this.names[idx].substring(0, this.names[idx].indexOf(".null")))) {
                            matches = true;
                        }
                        ++idx;
                    }
                    if (matches) {
                        return true;
                    }
                }
                dotIdx = fileName.lastIndexOf(46);
                int lastPos = fileName.length() - 1;
                if (dotIdx < 0 || dotIdx >= lastPos) break block11;
                type = !this.caseSensitive ? fileName.substring(dotIdx + 1).toLowerCase() : fileName.substring(dotIdx + 1);
                int idx = 0;
                while (!matches && idx < this.types.length) {
                    if (type.equals(this.types[idx])) {
                        matches = true;
                    }
                    ++idx;
                }
                break block10;
            }
            if (dotIdx != -1) break block10;
            int idx = 0;
            while (!matches && idx < this.types.length) {
                if ("null".equals(this.types[idx])) {
                    matches = true;
                }
                ++idx;
            }
        }
        return matches;
    }

    public String toString() {
        int idx;
        StringBuffer typesBuffer = new StringBuffer("");
        if (this.orgTypes != null) {
            idx = 0;
            while (idx < this.orgTypes.length) {
                typesBuffer.append(String.valueOf(this.orgTypes[idx]) + ",");
                ++idx;
            }
        }
        if (this.orgNames != null) {
            idx = 0;
            while (idx < this.orgNames.length) {
                typesBuffer.append(String.valueOf(this.orgNames[idx]) + ",");
                ++idx;
            }
        }
        return typesBuffer.toString();
    }

    public static String[] parseTypes(String typeList) {
        StringTokenizer tokens = new StringTokenizer(typeList, ",");
        Vector<String> v = new Vector<String>();
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.length() <= 0 || token.indexOf(46) != -1) continue;
            v.addElement(token);
        }
        String[] types = new String[v.size()];
        int idx = 0;
        while (idx < v.size()) {
            types[idx] = (String)v.elementAt(idx);
            ++idx;
        }
        return types;
    }

    public static String[] parseNames(String typeList) {
        StringTokenizer tokens = new StringTokenizer(typeList, ",");
        Vector<String> v = new Vector<String>();
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.length() <= 0 || token.indexOf(46) == -1) continue;
            v.addElement(token);
        }
        String[] names = new String[v.size()];
        int idx = 0;
        while (idx < v.size()) {
            names[idx] = (String)v.elementAt(idx);
            ++idx;
        }
        return names;
    }
}

