/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.synchronize.provisional;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.internal.importexport.SystemImportExportResources;
import org.eclipse.rse.internal.importexport.files.UniFilePlus;
import org.eclipse.rse.internal.synchronize.ISynchronizeData;
import org.eclipse.rse.internal.synchronize.filesystem.FileSystemProvider;
import org.eclipse.rse.internal.synchronize.provisional.ISynchronizeConnectionManager;
import org.eclipse.rse.internal.synchronize.provisional.ISynchronizeOperation;
import org.eclipse.rse.internal.synchronize.provisional.ISynchronizer;
import org.eclipse.rse.internal.synchronize.provisional.SynchronizeConnectionManager;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;

public class Synchronizer
implements ISynchronizer {
    private ISynchronizeData data;
    private ISynchronizeConnectionManager connector;
    private UniFilePlus remoteRoot;

    public Synchronizer(ISynchronizeData data) {
        this.data = data;
        this.connector = new SynchronizeConnectionManager();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean run(ISynchronizeOperation operation) {
        IProject[] projects = null;
        List<IResource> elements = this.data.getElements();
        HashSet<IProject> projectSet = new HashSet<IProject>();
        for (IResource resource : elements) {
            IContainer parent;
            projectSet.add(resource.getProject());
            if (resource.exists() || (parent = resource.getParent()).exists()) continue;
            this.createEmptyFolders(parent);
        }
        projects = projectSet.toArray(new IProject[projectSet.size()]);
        try {
            RepositoryProvider provider;
            IProject project;
            if (this.data.getSynchronizeType() == 2 || this.data.getSynchronizeType() == 1 || this.data.getSynchronizeType() == 5) {
                int i = 0;
                while (i < projects.length) {
                    project = projects[i];
                    if (this.connector.isConnected(project)) {
                        provider = RepositoryProvider.getProvider((IProject)project);
                        if (!(provider instanceof FileSystemProvider)) {
                            String msg = NLS.bind((String)SystemImportExportResources.RESID_SYNCHRONIZE_DISCONNECT_WARNING, (Object)project.getName());
                            SimpleSystemMessage msgObj = new SimpleSystemMessage("org.eclipse.rse.importexport", 2, msg);
                            SystemMessageDialog dlg = new SystemMessageDialog(SystemBasePlugin.getActiveWorkbenchShell(), (SystemMessage)msgObj);
                            if (!dlg.openQuestionNoException(true)) {
                                return false;
                            }
                        }
                        this.connector.disconnect(project);
                    }
                    ++i;
                }
            }
            int i = 0;
            while (true) {
                if (i >= projects.length) {
                    operation.synchronize(this.data.getElements(), this.remoteRoot.remoteFile, null, null, this.data.getSynchronizeType());
                    return true;
                }
                project = projects[i];
                this.connector.connect(project);
                provider = (FileSystemProvider)RepositoryProvider.getProvider((IProject)project);
                provider.reset();
                String remoteLocation = this.data.getRemoteLocation();
                IPath localLocation = this.data.getLocalLocation();
                provider.setRemoteLocation(remoteLocation);
                provider.setLocalLocation(localLocation);
                this.remoteRoot = provider.getRemoteRootFolder();
                ++i;
            }
        }
        catch (TeamException e1) {
            e1.printStackTrace();
            return true;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return true;
    }

    private void createEmptyFolders(IContainer container) {
        ArrayList<IContainer> emptyParent = new ArrayList<IContainer>();
        boolean go = true;
        IContainer empty = container;
        while (go) {
            if (!empty.exists() && empty instanceof IFolder) {
                emptyParent.add(empty);
            } else {
                go = false;
            }
            empty = empty.getParent();
        }
        IFolder emptyFolder = null;
        int j = emptyParent.size() - 1;
        while (j >= 0) {
            emptyFolder = (IFolder)emptyParent.get(j);
            if (!emptyFolder.exists()) {
                try {
                    emptyFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {}
            }
            --j;
        }
    }
}

