/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.dialogs;

import java.util.List;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.dialogs.SystemCopyTableProvider;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class SystemCopyDialog
extends SystemPromptDialog {
    private String verbiage;
    private SystemCopyTableProvider sctp;
    private Table table;
    private TableViewer tableViewer;
    private GridData tableData;
    private List collisions;
    private ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnPixelData(19, false), new ColumnWeightData(150, 150, true)};
    private String[] columnHeaders = new String[]{"", SystemResources.RESID_COLLISION_COPY_COLHDG_OLDNAME};

    public SystemCopyDialog(Shell shell, List files) {
        this(shell, SystemResources.RESID_COPY_TITLE, files);
    }

    public SystemCopyDialog(Shell shell, String title, List files) {
        super(shell, title);
        this.setOkButtonLabel(SystemResources.BUTTON_OVERWRITE_ALL);
        this.setOkButtonToolTipText(SystemResources.BUTTON_OVERWRITE_ALL_TOOLTIP);
        this.setCancelButtonLabel(SystemResources.BUTTON_CANCEL_ALL);
        this.setCancelButtonToolTipText(SystemResources.BUTTON_CANCEL_ALL_TOOLTIP);
        this.collisions = files;
    }

    protected Control createInner(Composite parent) {
        int height;
        int nbrColumns = 1;
        Composite composite = SystemWidgetHelpers.createComposite(parent, nbrColumns);
        if (this.verbiage != null) {
            SystemWidgetHelpers.createVerbiage(composite, this.verbiage, nbrColumns, false, 200);
        } else {
            SystemWidgetHelpers.createVerbiage(composite, SystemResources.RESID_COLLISION_COPY_VERBIAGE, nbrColumns, false, 200);
        }
        this.tableViewer = this.createTableViewer(composite, nbrColumns);
        this.createColumns();
        this.sctp = new SystemCopyTableProvider();
        int width = this.tableData.widthHint;
        int nbrRows = Math.min(this.collisions.size(), 8);
        int rowHeight = this.table.getItemHeight() + this.table.getGridLineWidth();
        int sbHeight = this.table.getHorizontalBar().getSize().y;
        this.tableData.heightHint = height = nbrRows * rowHeight + sbHeight;
        this.table.setLayoutData((Object)this.tableData);
        this.table.setSize(width, height);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.sctp);
        this.tableViewer.setContentProvider((IContentProvider)this.sctp);
        this.tableViewer.setInput((Object)this.collisions);
        return composite;
    }

    private TableViewer createTableViewer(Composite parent, int nbrColumns) {
        this.table = new Table(parent, 35584);
        this.table.setLinesVisible(true);
        this.tableViewer = new TableViewer(this.table);
        this.tableData = new GridData();
        this.tableData.horizontalAlignment = 4;
        this.tableData.grabExcessHorizontalSpace = true;
        this.tableData.widthHint = 350;
        this.tableData.heightHint = 30;
        this.tableData.verticalAlignment = 2;
        this.tableData.grabExcessVerticalSpace = true;
        this.tableData.horizontalSpan = nbrColumns;
        this.table.setLayoutData((Object)this.tableData);
        return this.tableViewer;
    }

    protected Control getInitialFocusControl() {
        return null;
    }

    private void createColumns() {
        TableLayout layout = new TableLayout();
        this.table.setLayout((Layout)layout);
        this.table.setHeaderVisible(true);
        int i = 0;
        while (i < this.columnHeaders.length) {
            layout.addColumnData(this.columnLayouts[i]);
            TableColumn tc = new TableColumn(this.table, 0, i);
            tc.setResizable(this.columnLayouts[i].resizable);
            tc.setText(this.columnHeaders[i]);
            ++i;
        }
    }
}

