/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.validators;

import java.util.Collection;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorUniqueString;
import org.eclipse.swt.widgets.Shell;

public class ValidatorConnectionName
extends ValidatorUniqueString
implements ISystemValidator {
    public static final int MAX_CONNECTIONNAME_LENGTH = 100;

    public ValidatorConnectionName(Collection existingNameList) {
        super(existingNameList, false);
        this.setErrorMessages(RSEUIPlugin.getPluginMessage("RSEG1021"), RSEUIPlugin.getPluginMessage("RSEG1022"));
    }

    public static boolean validateNameNotInUse(String proposedName, Shell shell) {
        SystemMessage msg = null;
        String[] names = RSECorePlugin.getTheSystemRegistry().getSystemProfileManager().getSystemProfileNames();
        String profileName = null;
        int idx = 0;
        while (msg == null && idx < names.length) {
            profileName = names[idx];
            IHost[] conns = RSECorePlugin.getTheSystemProfileManager().getSystemProfile(profileName).getHosts();
            int jdx = 0;
            while (msg == null && jdx < conns.length) {
                if (conns[jdx].getAliasName().equalsIgnoreCase(proposedName)) {
                    msg = RSEUIPlugin.getPluginMessage("RSEG1041");
                }
                ++jdx;
            }
            ++idx;
        }
        if (msg != null) {
            msg.makeSubstitution((Object)proposedName, profileName);
            SystemMessageDialog dlg = new SystemMessageDialog(shell, msg);
            boolean yesToContinue = dlg.openQuestionNoException();
            if (yesToContinue) {
                msg = null;
            }
        }
        return msg == null;
    }

    public int getMaximumNameLength() {
        return 100;
    }
}

