/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemRemoteChangeEvent;
import org.eclipse.rse.core.events.ISystemRemoteChangeListener;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.ISystemResourceChangeListener;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemContainer;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.actions.SystemCommonDeleteAction;
import org.eclipse.rse.internal.ui.actions.SystemCommonRenameAction;
import org.eclipse.rse.internal.ui.actions.SystemCommonSelectAllAction;
import org.eclipse.rse.internal.ui.actions.SystemImportConnectionAction;
import org.eclipse.rse.internal.ui.actions.SystemOpenExplorerPerspectiveAction;
import org.eclipse.rse.internal.ui.actions.SystemShowInTableAction;
import org.eclipse.rse.internal.ui.actions.SystemSubMenuManager;
import org.eclipse.rse.internal.ui.view.SystemDecoratingLabelProvider;
import org.eclipse.rse.internal.ui.view.SystemInheritableTextCellEditor;
import org.eclipse.rse.internal.ui.view.SystemTableViewColumnManager;
import org.eclipse.rse.internal.ui.view.SystemTableViewFilter;
import org.eclipse.rse.internal.ui.view.SystemTableViewSorter;
import org.eclipse.rse.internal.ui.view.SystemView;
import org.eclipse.rse.internal.ui.view.SystemViewDataDragAdapter;
import org.eclipse.rse.internal.ui.view.SystemViewDataDropAdapter;
import org.eclipse.rse.internal.ui.view.SystemViewMenuListener;
import org.eclipse.rse.services.clientserver.StringCompare;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.ISystemDeleteTarget;
import org.eclipse.rse.ui.ISystemRenameTarget;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.actions.ISystemAction;
import org.eclipse.rse.ui.actions.SystemNewConnectionAction;
import org.eclipse.rse.ui.actions.SystemRefreshAction;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.model.ISystemShellProvider;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemSelectAllTarget;
import org.eclipse.rse.ui.view.ISystemTableViewColumnManager;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;
import org.eclipse.rse.ui.view.SystemTableViewProvider;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.EditorInputTransfer;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SystemTableView
extends TableViewer
implements IMenuListener,
ISystemDeleteTarget,
ISystemRenameTarget,
ISystemSelectAllTarget,
ISystemResourceChangeListener,
ISystemRemoteChangeListener,
ISystemShellProvider,
ISelectionChangedListener,
ISelectionProvider {
    private ICellModifier cellModifier = new ICellModifier(){

        public Object getValue(Object element, String property) {
            ISystemViewElementAdapter adapter = SystemTableView.this.getViewAdapter(element);
            adapter.setPropertySourceInput(element);
            Object value = adapter.getPropertyValue(property);
            if (value == null) {
                value = "";
            }
            return value;
        }

        public boolean canModify(Object element, String property) {
            boolean modifiable = true;
            return modifiable;
        }

        public void modify(Object element, String property, Object value) {
            Object obj;
            ISystemViewElementAdapter adapter;
            if (element instanceof TableItem && value != null && (adapter = SystemTableView.this.getViewAdapter(obj = ((TableItem)element).getData())) != null) {
                adapter.setPropertyValue(property, value);
                SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)SystemTableView.this, SystemTableView.this.getSelection());
                SystemTableView.this.fireSelectionChanged(event);
            }
        }
    };
    private Object _objectInput;
    private TableLayout _layout = new TableLayout();
    protected SystemTableViewProvider _provider;
    private HeaderSelectionListener _columnSelectionListener;
    private MenuManager _menuManager;
    private SystemTableViewFilter _filter;
    private IPropertyDescriptor[] _uniqueDescriptors;
    private SystemTableViewColumnManager _columnManager;
    private SystemNewConnectionAction _newConnectionAction;
    private SystemImportConnectionAction _importConnectionAction;
    protected SystemRefreshAction _refreshAction;
    protected PropertyDialogAction _propertyDialogAction;
    private SystemOpenExplorerPerspectiveAction _openToPerspectiveAction;
    private SystemShowInTableAction _showInTableAction;
    private SystemCommonDeleteAction _deleteAction;
    private SystemCommonRenameAction _renameAction;
    private SystemCommonSelectAllAction _selectAllAction;
    protected boolean _selectionShowRefreshAction;
    protected boolean _selectionShowOpenViewActions;
    protected boolean _selectionShowDeleteAction;
    protected boolean _selectionShowRenameAction;
    protected boolean _selectionShowPropertiesAction;
    protected boolean _selectionEnableDeleteAction;
    protected boolean _selectionEnableRenameAction;
    protected boolean _selectionIsRemoteObject = true;
    protected boolean _selectionFlagsUpdated = false;
    private ISystemMessageLine _messageLine;
    private int[] _lastWidths = null;
    private int _charWidth = 3;
    private boolean _showColumns = true;
    private Image _upI;
    private Image _downI;
    protected boolean menuListenerAdded = false;
    private static final int LEFT_BUTTON = 1;
    private int mouseButtonPressed = 1;
    private Map _cachedColumnWidths;

    public SystemTableView(Table table, ISystemMessageLine msgLine) {
        super(table);
        this._messageLine = msgLine;
        this._columnManager = new SystemTableViewColumnManager((Viewer)this);
        this._provider = this.getProvider();
        this._columnSelectionListener = new HeaderSelectionListener();
        this.setContentProvider((IContentProvider)this._provider);
        this.setLabelProvider((IBaseLabelProvider)new SystemDecoratingLabelProvider(this._provider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this._filter = new SystemTableViewFilter();
        this.addFilter(this._filter);
        this._charWidth = table.getFont().getFontData()[0].getHeight() / 2;
        this.computeLayout();
        this._menuManager = new MenuManager("#PopupMenu");
        this._menuManager.setRemoveAllWhenShown(true);
        this._menuManager.addMenuListener((IMenuListener)this);
        Menu menu = this._menuManager.createContextMenu((Control)table);
        table.setMenu(menu);
        this.addSelectionChangedListener(this);
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        sr.addSystemResourceChangeListener((ISystemResourceChangeListener)this);
        sr.addSystemRemoteChangeListener((ISystemRemoteChangeListener)this);
        this.initDragAndDrop();
        table.setVisible(false);
        this.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                SystemTableView.this.handleKeyPressed(e);
            }
        });
        this.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                SystemTableView.this.mouseButtonPressed = e.button;
            }
        });
        this._upI = RSEUIPlugin.getDefault().getImage("org.eclipse.rse.ui.arrowup_objIcon");
        this._downI = RSEUIPlugin.getDefault().getImage("org.eclipse.rse.ui.arrowdown_objIcon");
        this._cachedColumnWidths = new HashMap();
    }

    protected SystemTableViewProvider getProvider() {
        if (this._provider == null) {
            this._provider = new SystemTableViewProvider(this._columnManager);
        }
        return this._provider;
    }

    public void showColumns(boolean flag) {
        this._showColumns = flag;
    }

    public Layout getLayout() {
        return this._layout;
    }

    public void setViewFilters(String[] filter) {
        if (this._filter.getFilters() != filter) {
            this._filter.setFilters(filter);
            this.refresh();
        }
    }

    public String[] getViewFilters() {
        return this._filter.getFilters();
    }

    public Menu getContextMenu() {
        return this.getTable().getMenu();
    }

    public MenuManager getContextMenuManager() {
        return this._menuManager;
    }

    public void inputChanged(Object newObject, Object oldObject) {
        if (newObject instanceof IAdaptable) {
            ISystemViewElementAdapter contentsAdapter;
            boolean wasShowColumns = this._showColumns;
            this._showColumns = true;
            this.getTable().setVisible(true);
            int[] lastWidths = this.getCurrentColumnWidths();
            if (lastWidths.length > 0 && (contentsAdapter = this.getAdapterForContents()) != null) {
                String adapterName = contentsAdapter.getClass().getName();
                this._cachedColumnWidths.put(adapterName, lastWidths);
            }
            this._objectInput = newObject;
            this.computeLayout();
            if (this._showColumns || wasShowColumns) {
                super.inputChanged(newObject, oldObject);
            }
        } else if (newObject == null) {
            this.getTable().setVisible(false);
            this._objectInput = null;
            this.computeLayout();
            this.setViewFilters(null);
        }
    }

    public Object getInput() {
        return this._objectInput;
    }

    protected ISystemViewElementAdapter getViewAdapter(Object obj) {
        ISystemViewElementAdapter adapter = SystemAdapterHelpers.getViewAdapter(obj, (Viewer)this);
        if (adapter != null) {
            adapter.setPropertySourceInput(obj);
        }
        return adapter;
    }

    public ISystemViewElementAdapter getAdapterForContents() {
        SystemTableViewProvider provider = (SystemTableViewProvider)this.getContentProvider();
        Object[] children = provider.getChildren(this.getInput());
        if (children != null && children.length > 0) {
            IAdaptable child = (IAdaptable)children[0];
            return this.getViewAdapter(child);
        }
        return null;
    }

    public IPropertyDescriptor[] getVisibleDescriptors(Object object) {
        SystemTableViewProvider provider = (SystemTableViewProvider)this.getContentProvider();
        Object[] children = provider.getChildren(object);
        return this.getVisibleDescriptors(children);
    }

    private IPropertyDescriptor[] getVisibleDescriptors(Object[] children) {
        if (children != null && children.length > 0) {
            IAdaptable child = (IAdaptable)children[0];
            return this.getCustomDescriptors(this.getViewAdapter(child));
        }
        return new IPropertyDescriptor[0];
    }

    public ISystemTableViewColumnManager getColumnManager() {
        return this._columnManager;
    }

    public IPropertyDescriptor getNameDescriptor(Object object) {
        SystemTableViewProvider provider = (SystemTableViewProvider)this.getContentProvider();
        Object[] children = provider.getChildren(object);
        return this.getNameDescriptor(children);
    }

    private IPropertyDescriptor getNameDescriptor(Object[] children) {
        if (children != null && children.length > 0) {
            IAdaptable child = (IAdaptable)children[0];
            return this.getViewAdapter(child).getPropertyDescriptors()[0];
        }
        return null;
    }

    private ArrayList getFormatsIn() {
        SystemTableViewProvider provider = (SystemTableViewProvider)this.getContentProvider();
        Object[] children = provider.getChildren(this._objectInput);
        return this.getFormatsIn(children);
    }

    private IPropertyDescriptor[] getCustomDescriptors(ISystemViewElementAdapter adapter) {
        return this._columnManager.getVisibleDescriptors(adapter);
    }

    private ArrayList getFormatsIn(Object[] children) {
        IAdaptable child;
        Object adapter;
        ArrayList results = new ArrayList();
        if (children != null && children.length > 0 && (adapter = (child = (IAdaptable)children[0]).getAdapter(ISystemViewElementAdapter.class)) instanceof ISystemViewElementAdapter) {
            ISystemViewElementAdapter ad = (ISystemViewElementAdapter)adapter;
            ad.setPropertySourceInput(child);
            IPropertyDescriptor[] descriptors = this.getCustomDescriptors(ad);
            int i = 0;
            while (i < descriptors.length) {
                IPropertyDescriptor descriptor = descriptors[i];
                try {
                    Object key = descriptor.getId();
                    Object propertyValue = ad.getPropertyValue(key, false);
                    if (propertyValue != null) {
                        results.add(propertyValue.getClass());
                    } else {
                        results.add(String.class);
                    }
                }
                catch (Exception exception) {
                    results.add(String.class);
                }
                ++i;
            }
        }
        return results;
    }

    public void computeLayout() {
        this.computeLayout(false);
    }

    private CellEditor getCellEditor(Table parent, IPropertyDescriptor descriptor) {
        CellEditor editor = descriptor.createPropertyEditor((Composite)parent);
        if (editor instanceof SystemInheritableTextCellEditor) {
            ((SystemInheritableTextCellEditor)editor).getInheritableEntryField().setAllowEditingOfInheritedText(true);
        }
        return editor;
    }

    private boolean sameDescriptors(IPropertyDescriptor[] descriptors1, IPropertyDescriptor[] descriptors2) {
        if (descriptors1 == null || descriptors2 == null) {
            return false;
        }
        if (descriptors1.length == descriptors2.length) {
            boolean same = true;
            int i = 0;
            while (i < descriptors1.length && same) {
                same = descriptors1[i] == descriptors2[i];
                ++i;
            }
            return same;
        }
        return false;
    }

    private Object[] internalGetSampleChildren() {
        SystemTableViewProvider provider = (SystemTableViewProvider)this.getContentProvider();
        Object lastObj = provider._lastObject;
        if (lastObj != this.getInput() || provider._lastResults == null) {
            Object[] children = provider.getChildren(this._objectInput);
            return children;
        }
        return provider._lastResults;
    }

    public void computeLayout(boolean force) {
        if (!this._showColumns) {
            return;
        }
        if (this._objectInput == null) {
            return;
        }
        SystemTableViewProvider provider = (SystemTableViewProvider)this.getContentProvider();
        Object[] children = this.internalGetSampleChildren();
        if (children == null || children.length == 0) {
            this._showColumns = false;
            return;
        }
        IPropertyDescriptor[] descriptors = this.getVisibleDescriptors(children);
        IPropertyDescriptor nameDescriptor = this.getNameDescriptor(children);
        int n = descriptors.length;
        if (nameDescriptor != null) {
            ++n;
        }
        if (n == 0) {
            return;
        }
        if (this.sameDescriptors(descriptors, this._uniqueDescriptors) && !force) {
            this.setLastColumnWidths(this.getCurrentColumnWidths());
            return;
        }
        this._uniqueDescriptors = descriptors;
        Table table = this.getTable();
        if (table == null || table.isDisposed()) {
            return;
        }
        TableColumn[] columns = table.getColumns();
        int numColumns = columns.length;
        CellEditor[] editors = new CellEditor[n];
        String[] headings = new String[n];
        String[] propertyIds = new String[n];
        ArrayList formats = this.getFormatsIn();
        this._layout = new TableLayout();
        int i = 0;
        while (i < n) {
            String name = null;
            String propertyId = null;
            CellEditor editor = null;
            int alignment = 16384;
            int weight = 100;
            if (i == 0) {
                name = SystemResources.RESID_RENAME_COLHDG_OLDNAME;
                if (nameDescriptor != null) {
                    propertyId = (String)nameDescriptor.getId();
                    editor = this.getCellEditor(table, nameDescriptor);
                    weight = 200;
                }
            } else {
                IPropertyDescriptor descriptor = descriptors[i - 1];
                Class format = (Class)formats.get(i - 1);
                name = descriptor.getDisplayName();
                propertyId = (String)descriptor.getId();
                editor = this.getCellEditor(table, descriptor);
                if (format != String.class) {
                    alignment = 131072;
                }
            }
            TableColumn tc = null;
            if (i >= numColumns) {
                tc = new TableColumn(table, alignment, i);
                tc.setMoveable(true);
                tc.addSelectionListener((SelectionListener)this._columnSelectionListener);
            } else {
                tc = columns[i];
                tc.setAlignment(alignment);
            }
            this._layout.addColumnData((ColumnLayoutData)new ColumnWeightData(weight));
            tc.setText(name);
            headings[i] = name;
            editors[i] = editor;
            propertyIds[i] = propertyId;
            ++i;
        }
        this.setColumnProperties(propertyIds);
        this.setCellEditors(editors);
        this.setCellModifier(this.cellModifier);
        i = n;
        while (i < numColumns) {
            columns[i].dispose();
            columns[i] = null;
            ++i;
        }
        columns = table.getColumns();
        numColumns = columns.length;
        Rectangle clientA = table.getClientArea();
        int totalWidth = clientA.width - 5;
        if (totalWidth <= 0) {
            totalWidth = 500;
        }
        int[] lastWidths = this.getLastColumnWidths();
        if (numColumns > 1) {
            ISystemViewElementAdapter adapter = this.getAdapterForContents();
            String adapterName = adapter.getClass().getName();
            int[] cachedWidths = (int[])this._cachedColumnWidths.get(adapterName);
            if (cachedWidths != null) {
                this.setCurrentColumnWidths(cachedWidths);
            } else if (lastWidths != null && lastWidths.length == numColumns) {
                this.setCurrentColumnWidths(lastWidths);
            } else if (totalWidth > 0) {
                int averageWidth = totalWidth / numColumns;
                int firstWidth = Math.max(averageWidth, 150);
                averageWidth = (totalWidth - firstWidth) / (numColumns - 1);
                averageWidth = Math.max(averageWidth, 80);
                columns[0].setWidth(firstWidth);
                int i2 = 1;
                while (i2 < numColumns) {
                    columns[i2].setWidth(averageWidth);
                    ++i2;
                }
                this.setLastColumnWidths(this.getCurrentColumnWidths());
            }
            table.setHeaderVisible(true);
        } else if (numColumns == 1) {
            int maxWidth;
            int width = totalWidth;
            if (lastWidths != null && lastWidths.length == 1) {
                int n2 = width = totalWidth > lastWidths[0] ? totalWidth : lastWidths[0];
            }
            if ((maxWidth = provider.getMaxCharsInColumnZero() * this._charWidth) > width) {
                width = maxWidth;
            }
            if (width > 0) {
                columns[0].setWidth(width);
            }
            table.setHeaderVisible(false);
        }
    }

    public int[] getCurrentColumnWidths() {
        Table table = this.getTable();
        if (table != null && !table.isDisposed()) {
            int[] widths = new int[table.getColumnCount()];
            TableColumn[] columns = table.getColumns();
            int i = 0;
            while (i < columns.length) {
                widths[i] = columns[i].getWidth();
                ++i;
            }
            return widths;
        }
        return new int[0];
    }

    public void setCurrentColumnWidths(int[] widths) {
        Table table = this.getTable();
        if (table != null && !table.isDisposed()) {
            int[] colOrder = table.getColumnOrder();
            TableColumn[] columns = table.getColumns();
            int i = 0;
            while (i < columns.length) {
                TableColumn column = columns[i];
                int position = colOrder[i];
                if (position < widths.length) {
                    column.setWidth(widths[position]);
                } else if (column.getWidth() == 0) {
                    column.setWidth(100);
                }
                ++i;
            }
        }
    }

    public int[] getLastColumnWidths() {
        return this._lastWidths;
    }

    public void setLastColumnWidths(int[] widths) {
        this._lastWidths = widths;
    }

    protected void initDragAndDrop() {
        int ops = 3;
        Transfer[] dragtransfers = new Transfer[]{PluginTransfer.getInstance(), EditorInputTransfer.getInstance()};
        Transfer[] droptransfers = new Transfer[]{PluginTransfer.getInstance(), FileTransfer.getInstance(), EditorInputTransfer.getInstance()};
        this.addDragSupport(ops | 0x10, dragtransfers, (DragSourceListener)new SystemViewDataDragAdapter(this));
        this.addDropSupport(ops | 0x10, droptransfers, (DropTargetListener)new SystemViewDataDropAdapter((StructuredViewer)this));
    }

    public void systemResourceChanged(ISystemResourceChangeEvent event) {
        SystemTableViewProvider provider;
        boolean madeChange = false;
        Object parent = event.getParent();
        Object child = event.getSource();
        int eventType = event.getType();
        switch (eventType) {
            case 15: 
            case 25: 
            case 43: {
                SystemTableViewProvider provider2;
                if (!(this._objectInput instanceof ISystemFilterReference) || child != ((ISystemFilterReference)this._objectInput).getReferencedFilter() || (provider2 = (SystemTableViewProvider)this.getContentProvider()) == null) break;
                if (!madeChange) {
                    provider2.flushCache();
                    madeChange = true;
                }
                this.computeLayout();
                try {
                    this.internalRefresh(this._objectInput);
                }
                catch (Exception e) {
                    SystemBasePlugin.logError(e.getMessage());
                }
                break;
            }
            case 81: 
            case 86: 
            case 87: {
                try {
                    Object first;
                    ISelection selection;
                    Widget w = this.findItem(child);
                    if (w != null) {
                        this.updateItem(w, child);
                    }
                    if ((selection = this.getSelection()) instanceof IStructuredSelection && (first = ((IStructuredSelection)selection).getFirstElement()).equals(child)) {
                        this.updatePropertySheet(true);
                    }
                }
                catch (Exception exception) {}
                return;
            }
            case 55: 
            case 60: {
                Widget w;
                if (!(child instanceof ISystemFilterReference) || (w = this.findItem(child)) == null) break;
                this.remove(child);
                break;
            }
            case 50: 
            case 53: {
                SystemTableViewProvider provider3;
                boolean addingConnection = child instanceof IHost;
                if (!(this._objectInput instanceof ISystemRegistry) || !addingConnection || (provider3 = (SystemTableViewProvider)this.getContentProvider()) == null) break;
                if (!madeChange) {
                    provider3.flushCache();
                    madeChange = true;
                }
                this.computeLayout();
                this.internalRefresh(this._objectInput);
                break;
            }
            case 82: 
            case 85: {
                if (child == RSECorePlugin.getTheSystemRegistry()) {
                    child = this._objectInput;
                    break;
                }
                try {
                    Widget w = this.findItem(child);
                    if (w == null || w.getData() == this._objectInput) break;
                    if (this._objectInput instanceof ISystemContainer) {
                        ((ISystemContainer)this._objectInput).markStale(true);
                    }
                    child = this._objectInput;
                }
                catch (Exception e) {
                    SystemBasePlugin.logError(e.getMessage());
                }
                break;
            }
        }
        if ((child == this._objectInput || parent == this._objectInput) && (provider = (SystemTableViewProvider)this.getContentProvider()) != null) {
            if (!madeChange) {
                provider.flushCache();
                madeChange = true;
            }
            this.computeLayout();
            try {
                this.internalRefresh(this._objectInput);
            }
            catch (Exception e) {
                SystemBasePlugin.logError(e.getMessage());
            }
        }
    }

    private void updatePropertySheet(boolean force) {
        ISelection selection = this.getSelection();
        if (selection == null) {
            return;
        }
        if (force || this.getControl().isFocusControl()) {
            Object first;
            ISystemViewElementAdapter adapter;
            Object parent;
            StructuredSelection parentSelection = null;
            if (selection instanceof IStructuredSelection && (parent = (adapter = this.getViewAdapter(first = ((IStructuredSelection)selection).getFirstElement())).getParent(first)) != null) {
                parentSelection = new StructuredSelection(parent);
            }
            SelectionChangedEvent dummyEvent = new SelectionChangedEvent((ISelectionProvider)this, parentSelection);
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
            this.fireSelectionChanged(dummyEvent);
            this.fireSelectionChanged(event);
        }
    }

    public void systemRemoteResourceChanged(ISystemRemoteChangeEvent event) {
        boolean madeChange = false;
        int eventType = event.getEventType();
        Object remoteResourceParent = event.getResourceParent();
        Object remoteResource = event.getResource();
        List remoteResourceNames = null;
        if (remoteResource instanceof List) {
            remoteResourceNames = (List)remoteResource;
            remoteResource = remoteResourceNames.get(0);
        }
        String remoteResourceParentName = this.getRemoteResourceAbsoluteName(remoteResourceParent);
        String remoteResourceName = this.getRemoteResourceAbsoluteName(remoteResource);
        if (remoteResourceName == null) {
            return;
        }
        SystemTableViewProvider provider = (SystemTableViewProvider)this.getContentProvider();
        if (this._objectInput instanceof ISystemContainer && ((ISystemContainer)this._objectInput).isStale()) {
            provider.flushCache();
            this.refresh();
            return;
        }
        switch (eventType) {
            case 4: {
                Widget w;
                if (remoteResourceParent != this.getInput() || (w = this.findItem(remoteResource)) == null) break;
                this.updateItem(w, remoteResource);
                break;
            }
            case 1: {
                String inputResourceName = this.getRemoteResourceAbsoluteName(this.getInput());
                if (remoteResourceParentName == null || !remoteResourceParentName.equals(inputResourceName)) break;
                if (provider == null) {
                    return;
                }
                if (!madeChange) {
                    if (this._objectInput instanceof ISystemContainer) {
                        ((ISystemContainer)this._objectInput).markStale(true);
                    }
                    provider.flushCache();
                    madeChange = true;
                }
                this.refresh();
                break;
            }
            case 2: {
                Object dchild = remoteResource;
                ISystemViewElementAdapter dadapt = this.getViewAdapter(dchild);
                if (dadapt == null) break;
                ISubSystem dSubSystem = dadapt.getSubSystem(dchild);
                String dkey = dadapt.getAbsoluteName(dchild);
                if (provider == null) break;
                Object[] children = provider.getChildren(this._objectInput);
                int i = 0;
                while (i < children.length) {
                    String ekey;
                    ISystemViewElementAdapter eadapt;
                    ISubSystem eSubSystem;
                    Object existingChild = children[i];
                    if (existingChild != null && dSubSystem == (eSubSystem = (eadapt = this.getViewAdapter(existingChild)).getSubSystem(existingChild)) && (ekey = eadapt.getAbsoluteName(existingChild)).equals(dkey) && !madeChange) {
                        if (this._objectInput instanceof ISystemContainer) {
                            ((ISystemContainer)this._objectInput).markStale(true);
                        }
                        provider.flushCache();
                        madeChange = true;
                        this.refresh();
                    }
                    ++i;
                }
                break;
            }
            case 8: {
                Object[] previousResults;
                String oldName = event.getOldNames()[0];
                Object child = event.getResource();
                if (provider == null || (previousResults = provider.getCache()) == null) break;
                int i = 0;
                while (i < previousResults.length) {
                    Object previousResult = previousResults[i];
                    if (previousResult == child) {
                        Widget widget = this.findItem(previousResult);
                        if (widget != null) {
                            widget.setData(child);
                            this.updateItem(widget, child);
                            return;
                        }
                    } else {
                        String previousName = this.getViewAdapter(previousResult).getAbsoluteName(previousResult);
                        if (previousName != null && previousName.equals(oldName)) {
                            provider.flushCache();
                            this.internalRefresh(this._objectInput);
                            return;
                        }
                    }
                    ++i;
                }
                break;
            }
        }
    }

    private String getRemoteResourceAbsoluteName(Object remoteResource) {
        if (remoteResource == null) {
            return null;
        }
        String remoteResourceName = null;
        if (remoteResource instanceof String) {
            remoteResourceName = (String)remoteResource;
        } else {
            ISystemViewElementAdapter ra = this.getViewAdapter(remoteResource);
            if (ra == null) {
                return null;
            }
            remoteResourceName = ra.getAbsoluteName(remoteResource);
        }
        return remoteResourceName;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        Object firstSelection = sel.getFirstElement();
        if (firstSelection == null) {
            return;
        }
        this._selectionFlagsUpdated = false;
        ISystemViewElementAdapter adapter = this.getViewAdapter(firstSelection);
        if (adapter != null) {
            this.displayMessage(adapter.getStatusLineText(firstSelection));
            if (this.mouseButtonPressed == 1) {
                adapter.selectionChanged(firstSelection);
            }
        } else {
            this.clearMessage();
        }
    }

    public void dispose() {
        this.removeSelectionChangedListener(this);
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        sr.removeSystemResourceChangeListener((ISystemResourceChangeListener)this);
        sr.removeSystemRemoteChangeListener((ISystemRemoteChangeListener)this);
        this._menuManager.removeAll();
        Table table = this.getTable();
        if (!table.isDisposed()) {
            table.removeAll();
            TableColumn[] columns = table.getColumns();
            int i = 0;
            while (i < columns.length) {
                TableColumn column = columns[i];
                if (column != null && !column.isDisposed()) {
                    column.removeSelectionListener((SelectionListener)this._columnSelectionListener);
                    column.dispose();
                    column = null;
                }
                ++i;
            }
            table.dispose();
        }
    }

    protected PropertyDialogAction getPropertyDialogAction() {
        if (this._propertyDialogAction == null) {
            this._propertyDialogAction = new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)this.getShell()), (ISelectionProvider)this);
        }
        this._propertyDialogAction.selectionChanged(this.getSelection());
        return this._propertyDialogAction;
    }

    protected IAction getSelectAllAction() {
        if (this._selectAllAction == null) {
            this._selectAllAction = new SystemCommonSelectAllAction(this.getShell(), this, this);
        }
        return this._selectAllAction;
    }

    protected IAction getRenameAction() {
        if (this._renameAction == null) {
            this._renameAction = new SystemCommonRenameAction(this.getShell(), this);
        }
        return this._renameAction;
    }

    protected IAction getDeleteAction() {
        if (this._deleteAction == null) {
            this._deleteAction = new SystemCommonDeleteAction(this.getShell(), this);
        }
        return this._deleteAction;
    }

    protected IAction getRefreshAction() {
        if (this._refreshAction == null) {
            this._refreshAction = new SystemRefreshAction(this.getShell());
        }
        return this._refreshAction;
    }

    public IAction getNewConnectionAction() {
        if (this._newConnectionAction == null) {
            this._newConnectionAction = new SystemNewConnectionAction(this.getShell(), true, this);
        }
        return this._newConnectionAction;
    }

    private IAction getImportConnectionAction() {
        if (this._importConnectionAction == null) {
            this._importConnectionAction = new SystemImportConnectionAction();
            this._importConnectionAction.setShell(this.getShell());
            this._importConnectionAction.setText(SystemResources.RESID_IMPORT_CONNECTION_LABEL_LONG);
        }
        return this._importConnectionAction;
    }

    private SystemOpenExplorerPerspectiveAction getOpenToPerspectiveAction() {
        if (this._openToPerspectiveAction == null) {
            IWorkbench desktop = PlatformUI.getWorkbench();
            IWorkbenchWindow win = desktop.getActiveWorkbenchWindow();
            this._openToPerspectiveAction = new SystemOpenExplorerPerspectiveAction(this.getShell(), win);
        }
        return this._openToPerspectiveAction;
    }

    private SystemShowInTableAction getShowInTableAction() {
        if (this._showInTableAction == null) {
            this._showInTableAction = new SystemShowInTableAction(this.getShell());
        }
        return this._showInTableAction;
    }

    public Shell getShell() {
        return this.getTable().getShell();
    }

    public boolean showDelete() {
        if (!this._selectionFlagsUpdated) {
            this.scanSelections();
        }
        return this._selectionShowDeleteAction;
    }

    public boolean canDelete() {
        if (!this._selectionFlagsUpdated) {
            this.scanSelections();
        }
        return this._selectionEnableDeleteAction;
    }

    public boolean doDelete(IProgressMonitor monitor) {
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        Iterator elements = selection.iterator();
        Object element = null;
        ISystemViewElementAdapter adapter = null;
        boolean ok = true;
        boolean anyOk = false;
        Vector deletedVector = new Vector();
        try {
            while (ok && elements.hasNext()) {
                element = elements.next();
                adapter = this.getViewAdapter(element);
                ok = adapter.doDelete(this.getShell(), element, monitor);
                if (!ok) continue;
                anyOk = true;
                deletedVector.addElement(element);
            }
        }
        catch (SystemMessageException exc) {
            SystemMessageDialog.displayErrorMessage(this.getShell(), exc.getSystemMessage());
            ok = false;
        }
        catch (Exception exc) {
            String msg = exc.getMessage();
            if (msg == null || exc instanceof ClassCastException) {
                msg = exc.getClass().getName();
            }
            SystemMessageDialog.displayErrorMessage(this.getShell(), RSEUIPlugin.getPluginMessage("RSEG1063").makeSubstitution(element, (Object)msg));
            ok = false;
        }
        if (anyOk) {
            Object[] deleted = new Object[deletedVector.size()];
            int idx = 0;
            while (idx < deleted.length) {
                deleted[idx] = deletedVector.elementAt(idx);
                ++idx;
            }
            if (this._selectionIsRemoteObject) {
                sr.fireRemoteResourceChangeEvent(2, deletedVector, null, null, null, (Object)this);
            } else {
                sr.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent(deleted, 60, this.getInput()));
            }
        }
        return ok;
    }

    protected boolean showProperties() {
        return this._selectionShowPropertiesAction;
    }

    public boolean showRename() {
        if (!this._selectionFlagsUpdated) {
            this.scanSelections();
        }
        return this._selectionShowRenameAction;
    }

    public boolean canRename() {
        if (!this._selectionFlagsUpdated) {
            this.scanSelections();
        }
        return this._selectionEnableRenameAction;
    }

    protected Object getParentForContent(Object element) {
        return this._objectInput;
    }

    protected SystemMessage getRenamingMessage(String oldName) {
        SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEG1142");
        msg.makeSubstitution((Object)oldName);
        return msg;
    }

    public boolean doRename(String[] newNames) {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        Iterator elements = selection.iterator();
        Object[] renameElements = new Object[newNames.length];
        Object[] elementAdapters = new Object[newNames.length];
        int i = 0;
        while (elements.hasNext()) {
            renameElements[i] = elements.next();
            elementAdapters[i] = this.getViewAdapter(renameElements[i]);
            ++i;
        }
        SystemMessage renameMessage = RSEUIPlugin.getPluginMessage("RSEG1142");
        renameMessage.makeSubstitution((Object)"");
        String renameMessageText = renameMessage.getLevelOneText();
        RenameJob renameJob = new RenameJob(newNames, renameElements, elementAdapters, renameMessageText);
        renameJob.schedule();
        return true;
    }

    protected ISystemRemoteElementAdapter getRemoteAdapter(Object o) {
        ISystemRemoteElementAdapter adapter = null;
        adapter = !(o instanceof IAdaptable) ? (ISystemRemoteElementAdapter)Platform.getAdapterManager().getAdapter(o, ISystemRemoteElementAdapter.class) : (ISystemRemoteElementAdapter)((IAdaptable)o).getAdapter(ISystemRemoteElementAdapter.class);
        if (adapter != null && adapter instanceof ISystemViewElementAdapter) {
            ((ISystemViewElementAdapter)((Object)adapter)).setViewer((Viewer)this);
        }
        return adapter;
    }

    public boolean enableSelectAll(IStructuredSelection selection) {
        return true;
    }

    public void doSelectAll(IStructuredSelection selection) {
        Table table = this.getTable();
        TableItem[] items = table.getItems();
        table.setSelection(items);
        Object[] objects = new Object[items.length];
        int idx = 0;
        while (idx < items.length) {
            objects[idx] = items[idx].getData();
            ++idx;
        }
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)new StructuredSelection(objects)));
    }

    public void menuAboutToShow(IMenuManager manager) {
        Menu m;
        this.fillContextMenu(manager);
        if (!this.menuListenerAdded && manager instanceof MenuManager && (m = ((MenuManager)manager).getMenu()) != null) {
            this.menuListenerAdded = true;
            SystemViewMenuListener ml = new SystemViewMenuListener();
            if (this._messageLine != null) {
                ml.setShowToolTipText(true, this._messageLine);
            }
            m.addMenuListener((MenuListener)ml);
        }
    }

    public ISelection getSelection() {
        ISelection selection = super.getSelection();
        if (selection == null || selection.isEmpty()) {
            ArrayList<Object> list = new ArrayList<Object>();
            if (this._objectInput != null) {
                list.add(this._objectInput);
                selection = new StructuredSelection(list);
            }
        }
        return selection;
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        Object firstIn = selection.getFirstElement();
        if (firstIn instanceof ISystemRegistry) {
            menu.add(this.getNewConnectionAction());
            menu.add(this.getImportConnectionAction());
            menu.add((IContributionItem)new GroupMarker("additions"));
        } else {
            PropertyDialogAction pdAction;
            SystemView.createStandardGroups(menu);
            menu.appendToGroup("group.build", this.getRefreshAction());
            if (this.canRename() && this.showRename()) {
                menu.appendToGroup("group.reorganize", this.getRenameAction());
            }
            SystemMenuManager ourMenu = new SystemMenuManager(menu);
            Iterator elements = selection.iterator();
            Hashtable adapters = new Hashtable();
            while (elements.hasNext()) {
                Object element = elements.next();
                ISystemViewElementAdapter adapter = this.getViewAdapter(element);
                adapters.put(adapter, element);
            }
            Enumeration uniqueAdapters = adapters.keys();
            Shell shell = this.getShell();
            while (uniqueAdapters.hasMoreElements()) {
                ISystemViewElementAdapter nextAdapter = (ISystemViewElementAdapter)uniqueAdapters.nextElement();
                nextAdapter.addActions(ourMenu, selection, shell, "group.adapters");
                if (!(nextAdapter instanceof AbstractSystemViewAdapter)) continue;
                AbstractSystemViewAdapter aVA = (AbstractSystemViewAdapter)nextAdapter;
                aVA.addCommonRemoteActions(ourMenu, selection, shell, "group.adapters");
                aVA.addDynamicPopupMenuActions(ourMenu, selection, shell, "additions");
            }
            IContributionItem[] items = menu.getItems();
            int idx = 0;
            while (idx < items.length) {
                Object item;
                if (items[idx] instanceof ActionContributionItem && ((ActionContributionItem)items[idx]).getAction() instanceof ISystemAction) {
                    item = (ISystemAction)((ActionContributionItem)items[idx]).getAction();
                    item.setInputs(this.getShell(), (Viewer)this, (ISelection)selection);
                } else if (items[idx] instanceof SystemSubMenuManager) {
                    item = (SystemSubMenuManager)items[idx];
                    ((SystemSubMenuManager)((Object)item)).setInputs(this.getShell(), (Viewer)this, (ISelection)selection);
                }
                ++idx;
            }
            if (this.canDelete() && this.showDelete()) {
                menu.appendToGroup("group.reorganize", this.getDeleteAction());
                ((ISystemAction)this.getDeleteAction()).setInputs(this.getShell(), (Viewer)this, (ISelection)selection);
                menu.add((IContributionItem)new Separator());
            }
            if (this.showProperties() && (pdAction = this.getPropertyDialogAction()).isApplicableForSelection()) {
                menu.appendToGroup("group.properties", (IAction)pdAction);
            }
            if (!this._selectionIsRemoteObject) {
                SystemOpenExplorerPerspectiveAction openToPerspectiveAction = this.getOpenToPerspectiveAction();
                SystemShowInTableAction showInTableAction = this.getShowInTableAction();
                openToPerspectiveAction.setSelection((ISelection)selection);
                showInTableAction.setSelection((ISelection)selection);
                if (this._selectionShowOpenViewActions) {
                    menu.appendToGroup("group.open", (IAction)openToPerspectiveAction);
                    menu.appendToGroup("group.open", (IAction)showInTableAction);
                }
            }
        }
    }

    protected void scanSelections() {
        this._selectionShowRefreshAction = true;
        this._selectionShowOpenViewActions = true;
        this._selectionShowDeleteAction = true;
        this._selectionShowRenameAction = true;
        this._selectionShowPropertiesAction = true;
        this._selectionEnableDeleteAction = true;
        this._selectionEnableRenameAction = true;
        this._selectionIsRemoteObject = true;
        this._selectionFlagsUpdated = true;
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        for (Object element : selection) {
            ISystemViewElementAdapter adapter = this.getViewAdapter(element);
            if (this._selectionShowRefreshAction) {
                this._selectionShowRefreshAction = adapter.showRefresh(element);
            }
            if (this._selectionShowOpenViewActions) {
                this._selectionShowOpenViewActions = adapter.showOpenViewActions(element);
            }
            if (this._selectionShowDeleteAction) {
                this._selectionShowDeleteAction = adapter.showDelete(element);
            }
            if (this._selectionShowRenameAction) {
                this._selectionShowRenameAction = adapter.showRename(element);
            }
            if (this._selectionShowPropertiesAction) {
                this._selectionShowPropertiesAction = adapter.showProperties(element);
            }
            if (this._selectionEnableDeleteAction) {
                boolean bl = this._selectionEnableDeleteAction = this._selectionShowDeleteAction && adapter.canDelete(element);
            }
            if (this._selectionEnableRenameAction) {
                boolean bl = this._selectionEnableRenameAction = this._selectionShowRenameAction && adapter.canRename(element);
            }
            if (!this._selectionIsRemoteObject) continue;
            this._selectionIsRemoteObject = adapter.isRemote(element);
        }
    }

    public void positionTo(String name) {
        ArrayList<TableItem> selectedItems = new ArrayList<TableItem>();
        Table table = this.getTable();
        int topIndex = 0;
        int i = 0;
        while (i < table.getItemCount()) {
            ISystemViewElementAdapter adapter;
            String itemName;
            TableItem item = table.getItem(i);
            Object data = item.getData();
            if (data instanceof IAdaptable && StringCompare.compare((String)name, (String)(itemName = (adapter = this.getViewAdapter(data)).getName(data)), (boolean)false)) {
                if (topIndex == 0) {
                    topIndex = i;
                }
                selectedItems.add(item);
            }
            ++i;
        }
        if (selectedItems.size() > 0) {
            TableItem[] tItems = new TableItem[selectedItems.size()];
            int i2 = 0;
            while (i2 < selectedItems.size()) {
                tItems[i2] = (TableItem)selectedItems.get(i2);
                ++i2;
            }
            table.setSelection(tItems);
            table.setTopIndex(topIndex);
            this.setSelection(this.getSelection(), true);
        }
    }

    void handleKeyPressed(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0 && ((IStructuredSelection)this.getSelection()).size() > 0) {
            this.scanSelections();
        }
    }

    public void displayMessage(String msg) {
        if (this._messageLine != null) {
            this._messageLine.setMessage(msg);
        }
    }

    public void clearMessage() {
        if (this._messageLine != null) {
            this._messageLine.clearMessage();
        }
    }

    public Map getCachedColumnWidths() {
        return this._cachedColumnWidths;
    }

    public void setCachedColumnWidths(Map cachedColumnWidths) {
        this._cachedColumnWidths = cachedColumnWidths;
    }

    private class HeaderSelectionListener
    extends SelectionAdapter {
        public HeaderSelectionListener() {
            SystemTableView.this._upI = RSEUIPlugin.getDefault().getImage("org.eclipse.rse.ui.upIcon");
            SystemTableView.this._downI = RSEUIPlugin.getDefault().getImage("org.eclipse.rse.ui.downIcon");
        }

        public void widgetSelected(SelectionEvent e) {
            Table table = SystemTableView.this.getTable();
            if (!table.isDisposed()) {
                TableColumn tcolumn = (TableColumn)e.widget;
                int column = table.indexOf(tcolumn);
                SystemTableViewSorter oldSorter = (SystemTableViewSorter)SystemTableView.this.getSorter();
                if (oldSorter != null) {
                    if (column == oldSorter.getColumnNumber()) {
                        boolean isReversed = !oldSorter.isReversed();
                        oldSorter.setReversed(isReversed);
                        if (isReversed) {
                            tcolumn.setImage(SystemTableView.this._downI);
                        } else {
                            tcolumn.setImage(SystemTableView.this._upI);
                        }
                    } else {
                        oldSorter.setColumnNumber(column);
                        oldSorter.setReversed(false);
                        tcolumn.setImage(SystemTableView.this._upI);
                    }
                } else {
                    SystemTableView.this.setSorter(new SystemTableViewSorter(column, (StructuredViewer)SystemTableView.this, SystemTableView.this._columnManager));
                    tcolumn.setImage(SystemTableView.this._downI);
                }
                TableColumn[] allColumns = table.getColumns();
                int i = 0;
                while (i < allColumns.length) {
                    if (i != column && allColumns[i].getImage() != null) {
                        allColumns[i].setImage(null);
                    }
                    ++i;
                }
                SystemTableView.this.refresh();
            }
        }
    }

    private class RenameJob
    extends WorkspaceJob {
        String[] newNames;
        Object[] elements;
        Object[] elementAdapters;
        Object parentElement;
        String renameMessage;

        public RenameJob(String[] newNames, Object[] elements, Object[] elementAdapters, String renameMessage) {
            super(renameMessage);
            this.newNames = null;
            this.elements = null;
            this.elementAdapters = null;
            this.parentElement = null;
            this.renameMessage = null;
            this.newNames = newNames;
            this.elements = elements;
            this.elementAdapters = elementAdapters;
            this.setUser(true);
        }

        /*
         * Unable to fully structure code
         */
        public IStatus runInWorkspace(IProgressMonitor monitor) {
            block10: {
                block9: {
                    sr = RSECorePlugin.getTheSystemRegistry();
                    element = null;
                    adapter = null;
                    remoteAdapter = null;
                    oldFullName = null;
                    oldName = null;
                    fileNamesRenamed = new Vector<String>();
                    ok = true;
                    try {
                        steps = this.elements.length;
                        monitor.beginTask(this.renameMessage, steps);
                        i = 0;
                        while (i < this.elements.length) {
                            element = this.elements[i];
                            adapter = (ISystemViewElementAdapter)this.elementAdapters[i];
                            remoteAdapter = SystemTableView.this.getRemoteAdapter(element);
                            parentElement = SystemTableView.this.getParentForContent(element);
                            if (remoteAdapter != null) {
                                oldName = remoteAdapter.getName(element);
                                oldFullName = remoteAdapter.getAbsoluteName(element);
                                monitor.subTask(SystemTableView.this.getRenamingMessage(oldName).getLevelOneText());
                            }
                            if (ok = adapter.doRename(null, element, this.newNames[i], monitor)) {
                                fileNamesRenamed.add(oldName);
                                if (remoteAdapter != null) {
                                    sr.fireRemoteResourceChangeEvent(8, element, parentElement, adapter.getSubSystem(element), new String[]{oldFullName}, (Object)this);
                                } else {
                                    sr.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent(element, 65, parentElement));
                                }
                            }
                            monitor.worked(1);
                            ++i;
                        }
                    }
                    catch (SystemMessageException exc) {
                        ok = false;
                        if (!monitor.isCanceled() || fileNamesRenamed.size() <= 0) break block9;
                        renamedFileNames = (String)fileNamesRenamed.get(0);
                        i = 1;
                        ** while (i < fileNamesRenamed.size())
                    }
lbl-1000:
                    // 1 sources

                    {
                        renamedFileNames = String.valueOf(renamedFileNames) + "\n" + fileNamesRenamed.get(i);
                        ++i;
                        continue;
                    }
lbl42:
                    // 1 sources

                    thisMessage = RSEUIPlugin.getPluginMessage("RSEG1246");
                    thisMessage.makeSubstitution((Object)renamedFileNames);
                    SystemMessageDialog.displayErrorMessage(null, thisMessage);
                    break block10;
                }
                SystemMessageDialog.displayErrorMessage(null, exc.getSystemMessage());
                break block10;
                catch (Exception exc) {
                    exc.printStackTrace();
                    SystemMessageDialog.displayErrorMessage(null, RSEUIPlugin.getPluginMessage("RSEG1064").makeSubstitution(element, (Object)exc), exc);
                    ok = false;
                }
            }
            return Status.OK_STATUS;
        }
    }
}

