/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.importexport.files;

import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TreeExpandDropListener
extends DropTargetAdapter {
    public static final long DEFAULT_EXPAND_DELAY = 1000L;
    private long hoverThreshhold = 1000L;
    private long hoverBegin = 0L;
    private TreeItem hoverItem = null;
    private Tree tree;

    public TreeExpandDropListener(Tree tree) {
        this.tree = tree;
    }

    public void dragEnter(DropTargetEvent event) {
        this.hoverItem = null;
    }

    public void dragOver(DropTargetEvent event) {
        long hoverCurrent;
        Point point = this.tree.toControl(new Point(event.x, event.y));
        TreeItem item = this.tree.getItem(point);
        if (item != this.hoverItem) {
            if (item != null && !item.getExpanded()) {
                this.hoverBegin = System.currentTimeMillis();
                this.hoverItem = item;
            } else {
                this.hoverItem = null;
            }
        } else if (this.hoverItem != null && (hoverCurrent = System.currentTimeMillis()) - this.hoverBegin >= this.hoverThreshhold) {
            Event hoverEvent = new Event();
            hoverEvent.x = event.x;
            hoverEvent.y = event.y;
            hoverEvent.item = this.hoverItem;
            hoverEvent.time = (int)hoverCurrent;
            this.hoverItem.setExpanded(true);
            this.hoverItem = null;
            this.tree.notifyListeners(17, hoverEvent);
        }
    }
}

