/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.subsystems.files;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.core.model.ISystemResourceSet;
import org.eclipse.rse.core.model.SystemRemoteResourceSet;
import org.eclipse.rse.core.model.SystemWorkspaceResourceSet;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISystemDragDropAdapter;
import org.eclipse.rse.files.ui.resources.UniversalFileTransferUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.tests.subsystems.files.FileServiceBaseTest;

public abstract class FileServiceArchiveBaseTest
extends FileServiceBaseTest {
    protected String folderToCopyName1 = "RemoteSystemsConnections";
    protected String folderToCopyName2 = "6YLT5Xa";
    protected String folderToCopyName3 = "folderToCopy";
    protected String tarSourceFileName1;
    protected String tarSourceFileName2;
    protected String tarSourceFolderName1 = "META-INF";
    protected String tarSourceFolderName2 = "org";
    protected String tarSourceForOpenTest;
    protected String tarSourceForOpenFolderName1 = "META-INF";
    protected String tarSourceForOpenFolderName2 = "org";
    protected String testName;
    protected String fileContentString1 = "this is just some dummy content \n to a remote file \n to test an open operation";

    public FileServiceArchiveBaseTest(String name) {
        super(name);
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public void createSourceFolders() throws Exception {
        String tempPath = FileServiceArchiveBaseTest.getWorkspace().getRoot().getLocation().append("temp").toString();
        IFileStore temp = this.createDir(tempPath, true);
        String content = this.getRandomString();
        IFileStore folderToCopy = temp.getChild(this.folderToCopyName3);
        this.createDir(folderToCopy, true);
        IFileStore aaaaaaaa = folderToCopy.getChild("aaaaaaaa");
        this.createDir(aaaaaaaa, true);
        IFileStore adsf = aaaaaaaa.getChild("adsf");
        content = this.getRandomString();
        this.createFile(adsf, content);
        IFileStore eclipse_SDK_3_3M6_win32_zip = aaaaaaaa.getChild("eclipse-SDK-3.3M6-win32.zip");
        this.createFile(eclipse_SDK_3_3M6_win32_zip, "");
        IFileStore epdcdump01_hex12 = aaaaaaaa.getChild("epdcdump01.hex12");
        content = this.getRandomString();
        this.createFile(epdcdump01_hex12, content);
        IFileStore epdcdump01_hex12aaaa = aaaaaaaa.getChild("epdcdump01.hex12aaaa");
        content = this.getRandomString();
        this.createFile(epdcdump01_hex12aaaa, content);
        IFileStore aaaab = folderToCopy.getChild("aaaab");
        this.createDir(aaaab, true);
        IFileStore features = aaaab.getChild("features");
        this.createDir(features, true);
        IFileStore dummyFile = features.getChild("dummy.txt");
        content = this.getRandomString();
        this.createFile(dummyFile, content);
        content = "this is just a simple content \n to a simple file \n to test a 'simple' copy";
        IFileStore epdcdump01_hex12a = aaaab.getChild("epdcdump01.hex12a");
        content = this.getRandomString();
        this.createFile(epdcdump01_hex12a, content);
        IFileStore epdcdump01_hex12a1 = folderToCopy.getChild("epdcdump01.hex12a");
        content = this.getRandomString();
        this.createFile(epdcdump01_hex12a1, content);
        IFileStore RSE_SDK_2_0RC1_zip = folderToCopy.getChild("RSE-SDK-2.0RC1.zip");
        content = this.getRandomString();
        this.createFile(RSE_SDK_2_0RC1_zip, content);
        IRemoteFile sourceFolderToCopy3 = this.localFss.getRemoteFileObject(String.valueOf(tempPath) + '\\' + this.folderToCopyName3, this.mon);
        ISystemDragDropAdapter srcAdapter3 = (ISystemDragDropAdapter)((IAdaptable)sourceFolderToCopy3).getAdapter(ISystemDragDropAdapter.class);
        SystemRemoteResourceSet fromSet3 = new SystemRemoteResourceSet((ISubSystem)this.localFss, srcAdapter3);
        fromSet3.addResource((Object)sourceFolderToCopy3);
        ISystemResourceSet tempObjects3 = srcAdapter3.doDrag(fromSet3, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects3), (IRemoteFile)this.tempDir, (IProgressMonitor)this.mon, (boolean)true);
        this.fss.resolveFilterString((Object)this.tempDir, null, this.mon);
        temp.delete(0, this.mon);
    }

    protected void createSuperTransferFolder(IFileStore temp) throws Exception {
        String content = this.getRandomString();
        IFileStore folderToCopy = temp.getChild(this.folderToCopyName3);
        this.createDir(folderToCopy, true);
        IFileStore aaaaaaaa = folderToCopy.getChild("aaaaaaaa");
        this.createDir(aaaaaaaa, true);
        IFileStore adsf = aaaaaaaa.getChild("adsf");
        content = this.getRandomString();
        this.createFile(adsf, content);
        IFileStore eclipse_SDK_3_3M6_win32_zip = aaaaaaaa.getChild("eclipse-SDK-3.3M6-win32.zip");
        this.createFile(eclipse_SDK_3_3M6_win32_zip, "");
        IFileStore epdcdump01_hex12 = aaaaaaaa.getChild("epdcdump01.hex12");
        content = this.getRandomString();
        this.createFile(epdcdump01_hex12, content);
        IFileStore epdcdump01_hex12aaaa = aaaaaaaa.getChild("epdcdump01.hex12aaaa");
        content = this.getRandomString();
        this.createFile(epdcdump01_hex12aaaa, content);
        IFileStore aaaab = folderToCopy.getChild("aaaab");
        this.createDir(aaaab, true);
        IFileStore features = aaaab.getChild("features");
        this.createDir(features, true);
        IFileStore dummyFile = features.getChild("dummy.txt");
        content = this.getRandomString();
        this.createFile(dummyFile, content);
        content = "this is just a simple content \n to a simple file \n to test a 'simple' copy";
        IFileStore epdcdump01_hex12a = aaaab.getChild("epdcdump01.hex12a");
        content = this.getRandomString();
        this.createFile(epdcdump01_hex12a, content);
        IFileStore epdcdump01_hex12a1 = folderToCopy.getChild("epdcdump01.hex12a");
        content = this.getRandomString();
        this.createFile(epdcdump01_hex12a1, content);
        IFileStore RSE_SDK_2_0RC1_zip = folderToCopy.getChild("RSE-SDK-2.0RC1.zip");
        content = this.getRandomString();
        this.createFile(RSE_SDK_2_0RC1_zip, content);
    }

    public void createTarSourceForOpen() throws Exception {
        String tempPath = FileServiceArchiveBaseTest.getWorkspace().getRoot().getLocation().append("temp").toString();
        IFileStore temp = this.createDir(tempPath, true);
        String content = this.getRandomString();
        IFileStore META_INF = temp.getChild(this.tarSourceForOpenFolderName1);
        this.createDir(META_INF, true);
        IFileStore MANIFEST_MF = META_INF.getChild("MANIFEST.MF");
        content = this.fileContentString1;
        this.createFile(MANIFEST_MF, content);
        IFileStore org = temp.getChild("org");
        this.createDir(org, true);
        IFileStore eclipse = org.getChild("eclipse");
        this.createDir(eclipse, true);
        IFileStore dstore = eclipse.getChild("dstore");
        this.createDir(dstore, true);
        IFileStore core = dstore.getChild("core");
        this.createDir(core, true);
        IFileStore internal = dstore.getChild("internal");
        this.createDir(internal, true);
        IFileStore client = core.getChild("client");
        this.createDir(client, true);
        IFileStore java = core.getChild("java");
        this.createDir(java, true);
        IFileStore miners = core.getChild("miners");
        this.createDir(miners, true);
        IFileStore model = core.getChild("model");
        this.createDir(model, true);
        IFileStore server = core.getChild("server");
        this.createDir(server, true);
        IFileStore util = core.getChild("util");
        this.createDir(util, true);
        IFileStore Activator_java = core.getChild("Activator.java");
        content = this.fileContentString1;
        this.createFile(Activator_java, content);
        IFileStore ClientConnection_java = client.getChild("ClientConnection.java");
        content = this.getRandomString();
        this.createFile(ClientConnection_java, content);
        IFileStore ConnectionStatus_java = client.getChild("ConnectionStatus.java");
        content = this.fileContentString1;
        this.createFile(ConnectionStatus_java, content);
        IFileStore ClassByteStreamHandler$ReceiveClassInstanceThread_java = java.getChild("ClassByteStreamHandler$ReceiveClassInstanceThread.java");
        content = this.getRandomString();
        this.createFile(ClassByteStreamHandler$ReceiveClassInstanceThread_java, content);
        IFileStore Miner_java = miners.getChild("Miner.java");
        content = this.getRandomString();
        this.createFile(Miner_java, content);
        IFileStore MinerThread_java = miners.getChild("MinerThread.java");
        content = this.getRandomString();
        this.createFile(MinerThread_java, content);
        IFileStore ByteStreamHandler_java = model.getChild("ByteStreamHandler.java");
        content = this.getRandomString();
        this.createFile(ByteStreamHandler_java, content);
        IFileStore DE_java = model.getChild("DE.java");
        content = this.getRandomString();
        this.createFile(DE_java, content);
        IFileStore Handler_java = model.getChild("Handler.java");
        content = this.getRandomString();
        this.createFile(Handler_java, content);
        IFileStore Server_java = server.getChild("Server.java");
        content = this.getRandomString();
        this.createFile(Server_java, content);
        IFileStore StringCompare_java = util.getChild("StringCompare.java");
        content = this.fileContentString1;
        this.createFile(StringCompare_java, content);
        IFileStore core1 = internal.getChild("core");
        this.createDir(core1, true);
        IFileStore client1 = core1.getChild("client");
        this.createDir(client1, true);
        IFileStore model1 = core1.getChild("model");
        this.createDir(model1, true);
        IFileStore server1 = core1.getChild("server");
        this.createDir(server1, true);
        IFileStore util1 = core1.getChild("util");
        this.createDir(util1, true);
        IFileStore ClientConnection_java1 = client1.getChild("ClientConnection.java");
        content = this.getRandomString();
        this.createFile(ClientConnection_java1, content);
        IFileStore ConnectionStatus_java1 = client1.getChild("ConnectionStatus.java");
        content = this.getRandomString();
        this.createFile(ConnectionStatus_java1, content);
        IFileStore ByteStreamHandler_java1 = model1.getChild("ByteStreamHandler.java");
        content = this.getRandomString();
        this.createFile(ByteStreamHandler_java1, content);
        IFileStore DE_java1 = model1.getChild("DE.java");
        content = this.getRandomString();
        this.createFile(DE_java1, content);
        IFileStore Handler_java1 = model1.getChild("Handler.java");
        content = this.getRandomString();
        this.createFile(Handler_java1, content);
        IFileStore Server_java1 = server1.getChild("Server.java");
        content = this.getRandomString();
        this.createFile(Server_java1, content);
        IFileStore StringCompare_java1 = util1.getChild("StringCompare.java");
        content = this.getRandomString();
        this.createFile(StringCompare_java1, content);
        IRemoteFile META_INF_folder = this.localFss.getRemoteFileObject(String.valueOf(tempPath) + '\\' + this.tarSourceForOpenFolderName1, this.mon);
        FileServiceArchiveBaseTest.assertNotNull((Object)META_INF_folder);
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)((IAdaptable)META_INF_folder).getAdapter(ISystemDragDropAdapter.class);
        SystemRemoteResourceSet fromSet = new SystemRemoteResourceSet((ISubSystem)this.localFss, srcAdapter1);
        fromSet.addResource((Object)META_INF_folder);
        ISystemResourceSet tempObjects1 = srcAdapter1.doDrag(fromSet, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects1), (IRemoteFile)this.tempDir, (IProgressMonitor)this.mon, (boolean)true);
        IRemoteFile org_folder = this.localFss.getRemoteFileObject(String.valueOf(tempPath) + '\\' + this.tarSourceForOpenFolderName2, this.mon);
        FileServiceArchiveBaseTest.assertNotNull((Object)org_folder);
        ISystemDragDropAdapter srcAdapter2 = (ISystemDragDropAdapter)((IAdaptable)org_folder).getAdapter(ISystemDragDropAdapter.class);
        SystemRemoteResourceSet fromSet2 = new SystemRemoteResourceSet((ISubSystem)this.localFss, srcAdapter2);
        fromSet2.addResource((Object)org_folder);
        ISystemResourceSet tempObjects2 = srcAdapter2.doDrag(fromSet2, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects2), (IRemoteFile)this.tempDir, (IProgressMonitor)this.mon, (boolean)true);
        IRemoteFile tarSource = this.createFileOrFolder(this.tempDir.getAbsolutePath(), this.tarSourceForOpenTest, false);
        FileServiceArchiveBaseTest.assertNotNull((Object)tarSource);
        IRemoteFile tarSourceFolder1 = (IRemoteFile)this.getChildFromFolder(this.tempDir, this.tarSourceForOpenFolderName1);
        FileServiceArchiveBaseTest.assertNotNull((Object)tarSourceFolder1);
        IRemoteFile tarSourceFolder2 = (IRemoteFile)this.getChildFromFolder(this.tempDir, this.tarSourceForOpenFolderName2);
        this.fss.copy(tarSourceFolder1, tarSource, this.tarSourceForOpenFolderName1, this.mon);
        this.fss.copy(tarSourceFolder2, tarSource, this.tarSourceForOpenFolderName2, this.mon);
        this.fss.resolveFilterString((Object)this.tempDir, null, this.mon);
        temp.delete(0, this.mon);
    }

    public void createSourceTarFiles() throws Exception {
        String tempPath = FileServiceArchiveBaseTest.getWorkspace().getRoot().getLocation().append("temp").toString();
        IFileStore temp = this.createDir(tempPath, true);
        String content = this.getRandomString();
        IFileStore META_INF = temp.getChild(this.tarSourceFolderName1);
        this.createDir(META_INF, true);
        IFileStore MANIFEST_MF = META_INF.getChild("MANIFEST.MF");
        content = this.getRandomString();
        this.createFile(MANIFEST_MF, content);
        IFileStore org = temp.getChild(this.tarSourceFolderName2);
        this.createDir(org, true);
        IFileStore eclipse = org.getChild("eclipse");
        this.createDir(eclipse, true);
        IFileStore dstore = eclipse.getChild("dstore");
        this.createDir(dstore, true);
        IFileStore core = dstore.getChild("core");
        this.createDir(core, true);
        IFileStore internal = dstore.getChild("internal");
        this.createDir(internal, true);
        IFileStore client = core.getChild("client");
        this.createDir(client, true);
        IFileStore java = core.getChild("java");
        this.createDir(java, true);
        IFileStore miners = core.getChild("miners");
        this.createDir(miners, true);
        IFileStore model = core.getChild("model");
        this.createDir(model, true);
        IFileStore server = core.getChild("server");
        this.createDir(server, true);
        IFileStore util = core.getChild("util");
        this.createDir(util, true);
        IFileStore Activator_java = core.getChild("Activator.java");
        content = this.getRandomString();
        this.createFile(Activator_java, content);
        IFileStore ClientConnection_java = client.getChild("ClientConnection.java");
        content = this.getRandomString();
        this.createFile(ClientConnection_java, content);
        IFileStore ConnectionStatus_java = client.getChild("ConnectionStatus.java");
        content = this.getRandomString();
        this.createFile(ConnectionStatus_java, content);
        IFileStore ClassByteStreamHandler$ReceiveClassInstanceThread_java = java.getChild("ClassByteStreamHandler$ReceiveClassInstanceThread.java");
        content = this.getRandomString();
        this.createFile(ClassByteStreamHandler$ReceiveClassInstanceThread_java, content);
        IFileStore Miner_java = miners.getChild("Miner.java");
        content = this.getRandomString();
        this.createFile(Miner_java, content);
        IFileStore MinerThread_java = miners.getChild("MinerThread.java");
        content = this.getRandomString();
        this.createFile(MinerThread_java, content);
        IFileStore ByteStreamHandler_java = model.getChild("ByteStreamHandler.java");
        content = this.getRandomString();
        this.createFile(ByteStreamHandler_java, content);
        IFileStore DE_java = model.getChild("DE.java");
        content = this.getRandomString();
        this.createFile(DE_java, content);
        IFileStore Handler_java = model.getChild("Handler.java");
        content = this.getRandomString();
        this.createFile(Handler_java, content);
        IFileStore Server_java = server.getChild("Server.java");
        content = this.getRandomString();
        this.createFile(Server_java, content);
        IFileStore StringCompare_java = util.getChild("StringCompare.java");
        content = this.getRandomString();
        this.createFile(StringCompare_java, content);
        IFileStore core1 = internal.getChild("core");
        this.createDir(core1, true);
        IFileStore client1 = core1.getChild("client");
        this.createDir(client1, true);
        IFileStore model1 = core1.getChild("model");
        this.createDir(model1, true);
        IFileStore server1 = core1.getChild("server");
        this.createDir(server1, true);
        IFileStore util1 = core1.getChild("util");
        this.createDir(util1, true);
        IFileStore ClientConnection_java1 = client1.getChild("ClientConnection.java");
        content = this.getRandomString();
        this.createFile(ClientConnection_java1, content);
        IFileStore ConnectionStatus_java1 = client1.getChild("ConnectionStatus.java");
        content = this.getRandomString();
        this.createFile(ConnectionStatus_java1, content);
        IFileStore ByteStreamHandler_java1 = model1.getChild("ByteStreamHandler.java");
        content = this.getRandomString();
        this.createFile(ByteStreamHandler_java1, content);
        IFileStore DE_java1 = model1.getChild("DE.java");
        content = this.getRandomString();
        this.createFile(DE_java1, content);
        IFileStore Handler_java1 = model1.getChild("Handler.java");
        content = this.getRandomString();
        this.createFile(Handler_java1, content);
        IFileStore Server_java1 = server1.getChild("Server.java");
        content = this.getRandomString();
        this.createFile(Server_java1, content);
        IFileStore StringCompare_java1 = util1.getChild("StringCompare.java");
        content = this.getRandomString();
        this.createFile(StringCompare_java1, content);
        IRemoteFile META_INF_folder = this.localFss.getRemoteFileObject(String.valueOf(tempPath) + '\\' + this.tarSourceFolderName1, this.mon);
        FileServiceArchiveBaseTest.assertNotNull((Object)META_INF_folder);
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)((IAdaptable)META_INF_folder).getAdapter(ISystemDragDropAdapter.class);
        SystemRemoteResourceSet fromSet = new SystemRemoteResourceSet((ISubSystem)this.localFss, srcAdapter1);
        fromSet.addResource((Object)META_INF_folder);
        ISystemResourceSet tempObjects1 = srcAdapter1.doDrag(fromSet, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects1), (IRemoteFile)this.tempDir, (IProgressMonitor)this.mon, (boolean)true);
        IRemoteFile org_folder = this.localFss.getRemoteFileObject(String.valueOf(tempPath) + '\\' + this.tarSourceFolderName2, this.mon);
        FileServiceArchiveBaseTest.assertNotNull((Object)org_folder);
        ISystemDragDropAdapter srcAdapter2 = (ISystemDragDropAdapter)((IAdaptable)org_folder).getAdapter(ISystemDragDropAdapter.class);
        SystemRemoteResourceSet fromSet2 = new SystemRemoteResourceSet((ISubSystem)this.localFss, srcAdapter2);
        fromSet2.addResource((Object)org_folder);
        ISystemResourceSet tempObjects2 = srcAdapter2.doDrag(fromSet2, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects2), (IRemoteFile)this.tempDir, (IProgressMonitor)this.mon, (boolean)true);
        IRemoteFile tarSource = this.createFileOrFolder(this.tempDir.getAbsolutePath(), this.tarSourceFileName1, false);
        FileServiceArchiveBaseTest.assertNotNull((Object)tarSource);
        IRemoteFile tarSourceFolder1 = (IRemoteFile)this.getChildFromFolder(this.tempDir, this.tarSourceFolderName1);
        FileServiceArchiveBaseTest.assertNotNull((Object)tarSourceFolder1);
        IRemoteFile tarSourceFolder2 = (IRemoteFile)this.getChildFromFolder(this.tempDir, this.tarSourceFolderName2);
        this.fss.copy(tarSourceFolder1, tarSource, this.tarSourceFolderName1, this.mon);
        this.fss.copy(tarSourceFolder2, tarSource, this.tarSourceFolderName2, this.mon);
    }

    public void testCreateTarFile() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        IRemoteFile newArchiveFile = this.createFileOrFolder(this.tempDirPath, this.testName, false);
        FileServiceArchiveBaseTest.assertNotNull((Object)newArchiveFile);
        FileServiceArchiveBaseTest.assertTrue((boolean)newArchiveFile.exists());
        FileServiceArchiveBaseTest.assertTrue((boolean)newArchiveFile.canRead());
        FileServiceArchiveBaseTest.assertTrue((boolean)newArchiveFile.canWrite());
        FileServiceArchiveBaseTest.assertEquals((String)newArchiveFile.getName(), (String)this.testName);
        FileServiceArchiveBaseTest.assertEquals((String)newArchiveFile.getParentPath(), (String)this.tempDirPath);
        String childName = "aaa.txt";
        IRemoteFile file1 = this.createFileOrFolder(newArchiveFile.getAbsolutePath(), childName, false);
        FileServiceArchiveBaseTest.assertNotNull((Object)file1);
        childName = "bbb.txt";
        IRemoteFile file2 = this.createFileOrFolder(newArchiveFile.getAbsolutePath(), childName, false);
        FileServiceArchiveBaseTest.assertNotNull((Object)file2);
        childName = "folder1";
        IRemoteFile folder1 = this.createFileOrFolder(newArchiveFile.getAbsolutePath(), childName, true);
        FileServiceArchiveBaseTest.assertNotNull((Object)folder1);
        String[] namesToCheck = new String[]{"aaa.txt", "bbb.txt", "folder1"};
        int[] typesToCheck = new int[]{TYPE_FILE, TYPE_FILE, TYPE_FOLDER};
        this.checkFolderContents(newArchiveFile, namesToCheck, typesToCheck);
        String secondLevelChildName = "ccc.exe";
        IRemoteFile levelTwoChild1 = this.createFileOrFolder(folder1.getAbsolutePath(), secondLevelChildName, false);
        FileServiceArchiveBaseTest.assertNotNull((Object)levelTwoChild1);
        secondLevelChildName = "ddd.bat";
        IRemoteFile levelTwoChild2 = this.createFileOrFolder(folder1.getAbsolutePath(), secondLevelChildName, false);
        FileServiceArchiveBaseTest.assertNotNull((Object)levelTwoChild2);
        secondLevelChildName = "another Folder";
        IRemoteFile levelTwoChild3 = this.createFileOrFolder(folder1.getAbsolutePath(), secondLevelChildName, true);
        FileServiceArchiveBaseTest.assertNotNull((Object)levelTwoChild3);
        String[] namesToCheck1 = new String[]{"ccc.exe", "ddd.bat", "another Folder"};
        int[] typesToCheck1 = new int[]{TYPE_FILE, TYPE_FILE, TYPE_FOLDER};
        this.checkFolderContents(folder1, namesToCheck1, typesToCheck1);
    }

    public void testCopyToTarArchiveFile() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        this.createSourceTarFiles();
        this.createSourceFolders();
        String tarTargetFileName = this.tarSourceFileName1;
        IRemoteFile targetTarFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, tarTargetFileName);
        FileServiceArchiveBaseTest.assertNotNull((Object)targetTarFile);
        String sourceFolderName = this.folderToCopyName3;
        IRemoteFile sourceFolder = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceFolderName);
        FileServiceArchiveBaseTest.assertNotNull((Object)sourceFolder);
        this.fss.copy(sourceFolder, targetTarFile, sourceFolder.getName(), this.mon);
        Object theCopiedChild = this.getChildFromFolder(targetTarFile, sourceFolderName);
        FileServiceArchiveBaseTest.assertNotNull((Object)theCopiedChild);
        String[] childrenToCheck = new String[]{"aaaaaaaa", "aaaab", "epdcdump01.hex12a", "RSE-SDK-2.0RC1.zip"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)theCopiedChild, childrenToCheck, typesToCheck);
    }

    public void testCopyTarVirtualFile() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        this.createSourceTarFiles();
        String sourceFileName = this.tarSourceFileName1;
        IRemoteFile sourceTarFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceFileName);
        FileServiceArchiveBaseTest.assertNotNull((Object)sourceTarFile);
        String folderName = "folder1";
        IRemoteFile folder1 = this.createFileOrFolder(this.tempDirPath, folderName, true);
        FileServiceArchiveBaseTest.assertNotNull((Object)folder1);
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(sourceTarFile, this.tarSourceFolderName1);
        FileServiceArchiveBaseTest.assertNotNull((Object)firstLevelChild);
        this.fss.copy(firstLevelChild, folder1, this.tarSourceFolderName1, this.mon);
        Object copiedVirtualFolder = this.getChildFromFolder(folder1, this.tarSourceFolderName1);
        FileServiceArchiveBaseTest.assertNotNull((Object)copiedVirtualFolder);
        String[] contents = new String[]{"MANIFEST.MF"};
        int[] typesToCheck = new int[]{TYPE_FILE};
        this.checkFolderContents((IRemoteFile)copiedVirtualFolder, contents, typesToCheck);
    }

    public void testMoveToTarArchiveFile() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        this.createSourceTarFiles();
        this.createSourceFolders();
        String tarTargetFileName = this.tarSourceFileName1;
        IRemoteFile targetTarFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, tarTargetFileName);
        FileServiceArchiveBaseTest.assertNotNull((Object)targetTarFile);
        String sourceFolderName = this.folderToCopyName3;
        IRemoteFile sourceFolder = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceFolderName);
        FileServiceArchiveBaseTest.assertNotNull((Object)sourceFolder);
        this.fss.move(sourceFolder, targetTarFile, sourceFolder.getName(), this.mon);
        Object theMovedChild = this.getChildFromFolder(targetTarFile, sourceFolderName);
        FileServiceArchiveBaseTest.assertNotNull((Object)theMovedChild);
        String[] childrenToCheck = new String[]{"aaaaaaaa", "aaaab", "epdcdump01.hex12a", "RSE-SDK-2.0RC1.zip"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)theMovedChild, childrenToCheck, typesToCheck);
        Object originalSource = this.getChildFromFolder(this.tempDir, sourceFolderName);
        FileServiceArchiveBaseTest.assertNull((Object)originalSource);
    }

    public void testMoveTarVirtualFile() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        this.createSourceTarFiles();
        String sourceFileName = this.tarSourceFileName1;
        IRemoteFile sourceTarFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceFileName);
        FileServiceArchiveBaseTest.assertNotNull((Object)sourceTarFile);
        String folderName = "folder1";
        IRemoteFile folder1 = this.createFileOrFolder(this.tempDirPath, folderName, true);
        FileServiceArchiveBaseTest.assertNotNull((Object)folder1);
        String movedFolderName = this.tarSourceFolderName1;
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(sourceTarFile, this.tarSourceFolderName1);
        FileServiceArchiveBaseTest.assertNotNull((Object)firstLevelChild);
        this.fss.move(firstLevelChild, folder1, movedFolderName, this.mon);
        Object movedVirtualFolder = this.getChildFromFolder(folder1, movedFolderName);
        FileServiceArchiveBaseTest.assertNotNull((Object)movedVirtualFolder);
        String[] contents = new String[]{"MANIFEST.MF"};
        int[] typesToCheck = new int[]{TYPE_FILE};
        this.checkFolderContents((IRemoteFile)movedVirtualFolder, contents, typesToCheck);
        IRemoteFile tmp = (IRemoteFile)this.getChildFromFolder(sourceTarFile, this.tarSourceFolderName1);
        FileServiceArchiveBaseTest.assertNull((Object)tmp);
    }

    public void testRenameTarVirtualFile() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        IRemoteFile newArchiveFile = this.createFileOrFolder(this.tempDirPath, this.testName, false);
        String childName = "aaa.txt";
        IRemoteFile file1 = this.createFileOrFolder(newArchiveFile.getAbsolutePath(), childName, false);
        FileServiceArchiveBaseTest.assertNotNull((Object)file1);
        childName = "bbb.txt";
        IRemoteFile file2 = this.createFileOrFolder(newArchiveFile.getAbsolutePath(), childName, false);
        FileServiceArchiveBaseTest.assertNotNull((Object)file2);
        childName = "folder1";
        IRemoteFile folder1 = this.createFileOrFolder(newArchiveFile.getAbsolutePath(), childName, true);
        FileServiceArchiveBaseTest.assertNotNull((Object)folder1);
        String[] levelOneNamesToCheck = new String[]{"aaa.txt", "bbb.txt", "folder1"};
        int[] levalOneTypesToCheck = new int[]{TYPE_FILE, TYPE_FILE, TYPE_FOLDER};
        this.checkFolderContents(newArchiveFile, levelOneNamesToCheck, levalOneTypesToCheck);
        String secondLevelChildName = "ccc.exe";
        IRemoteFile levelTwoChild1 = this.createFileOrFolder(folder1.getAbsolutePath(), secondLevelChildName, false);
        FileServiceArchiveBaseTest.assertNotNull((Object)levelTwoChild1);
        secondLevelChildName = "ddd.bat";
        IRemoteFile levelTwoChild2 = this.createFileOrFolder(folder1.getAbsolutePath(), secondLevelChildName, false);
        FileServiceArchiveBaseTest.assertNotNull((Object)levelTwoChild2);
        secondLevelChildName = "another Folder";
        IRemoteFile levelTwoChild3 = this.createFileOrFolder(folder1.getAbsolutePath(), secondLevelChildName, true);
        FileServiceArchiveBaseTest.assertNotNull((Object)levelTwoChild3);
        String[] levelTwoNamesToCheck = new String[]{"ccc.exe", "ddd.bat", "another Folder"};
        int[] levalTwoTypesToCheck = new int[]{TYPE_FILE, TYPE_FILE, TYPE_FOLDER};
        this.checkFolderContents(folder1, levelTwoNamesToCheck, levalTwoTypesToCheck);
        IRemoteFile childToRename = (IRemoteFile)this.getChildFromFolder(newArchiveFile, "aaa.txt");
        this.fss.rename(childToRename, "aaa1.txt", this.mon);
        childToRename = (IRemoteFile)this.getChildFromFolder(newArchiveFile, "folder1");
        this.fss.rename(childToRename, "folder2", this.mon);
        String[] newLevelOneNamesToCheck = new String[]{"aaa1.txt", "bbb.txt", "folder2"};
        this.checkFolderContents(newArchiveFile, newLevelOneNamesToCheck, levalOneTypesToCheck);
        IRemoteFile thisFolder = (IRemoteFile)this.getChildFromFolder(newArchiveFile, "folder2");
        childToRename = (IRemoteFile)this.getChildFromFolder(thisFolder, "ddd.bat");
        this.fss.rename(childToRename, "ddd1.bat", this.mon);
        childToRename = (IRemoteFile)this.getChildFromFolder(thisFolder, "another Folder");
        this.fss.rename(childToRename, "some folder$", this.mon);
        String[] newLevelTwoNamesToCheck = new String[]{"ccc.exe", "ddd1.bat", "some folder$"};
        this.checkFolderContents(thisFolder, newLevelTwoNamesToCheck, levalTwoTypesToCheck);
    }

    public void testDeleteTarVirtualFile() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        this.createSourceTarFiles();
        String sourceFileName = this.tarSourceFileName1;
        IRemoteFile sourceTarFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceFileName);
        FileServiceArchiveBaseTest.assertNotNull((Object)sourceTarFile);
        String parentForFileToDeleteName = "META-INF";
        IRemoteFile parentForFileToDelete = (IRemoteFile)this.getChildFromFolder(sourceTarFile, parentForFileToDeleteName);
        FileServiceArchiveBaseTest.assertNotNull((Object)parentForFileToDelete);
        String deleteFileName = "MANIFEST.MF";
        IRemoteFile fileToToDelete = (IRemoteFile)this.getChildFromFolder(parentForFileToDelete, deleteFileName);
        FileServiceArchiveBaseTest.assertNotNull((Object)fileToToDelete);
        this.fss.delete(fileToToDelete, this.mon);
        fileToToDelete = (IRemoteFile)this.getChildFromFolder(parentForFileToDelete, deleteFileName);
        FileServiceArchiveBaseTest.assertNull((Object)fileToToDelete);
        String parentForDirectoryToDeleteName = "org";
        IRemoteFile parentForDirectoryToDelete = (IRemoteFile)this.getChildFromFolder(sourceTarFile, parentForDirectoryToDeleteName);
        FileServiceArchiveBaseTest.assertNotNull((Object)parentForDirectoryToDelete);
        parentForDirectoryToDeleteName = "eclipse";
        parentForDirectoryToDelete = (IRemoteFile)this.getChildFromFolder(parentForDirectoryToDelete, parentForDirectoryToDeleteName);
        FileServiceArchiveBaseTest.assertNotNull((Object)parentForDirectoryToDelete);
        parentForDirectoryToDeleteName = "dstore";
        parentForDirectoryToDelete = (IRemoteFile)this.getChildFromFolder(parentForDirectoryToDelete, parentForDirectoryToDeleteName);
        FileServiceArchiveBaseTest.assertNotNull((Object)parentForDirectoryToDelete);
        parentForDirectoryToDeleteName = "core";
        parentForDirectoryToDelete = (IRemoteFile)this.getChildFromFolder(parentForDirectoryToDelete, parentForDirectoryToDeleteName);
        FileServiceArchiveBaseTest.assertNotNull((Object)parentForDirectoryToDelete);
        String directoryToDeleteName = "java";
        IRemoteFile directoryToDelete = (IRemoteFile)this.getChildFromFolder(parentForDirectoryToDelete, directoryToDeleteName);
        this.fss.delete(directoryToDelete, this.mon);
        directoryToDelete = (IRemoteFile)this.getChildFromFolder(parentForDirectoryToDelete, directoryToDeleteName);
        String[] contents = new String[]{"client", "miners", "model", "server", "util", "Activator.java"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FOLDER, TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE};
        this.checkFolderContents(parentForDirectoryToDelete, contents, typesToCheck);
        directoryToDelete = (IRemoteFile)this.getChildFromFolder(parentForDirectoryToDelete, directoryToDeleteName);
        FileServiceArchiveBaseTest.assertNull((Object)directoryToDelete);
        parentForFileToDelete = (IRemoteFile)this.getChildFromFolder(parentForDirectoryToDelete, "model");
        deleteFileName = "DE.java";
        fileToToDelete = (IRemoteFile)this.getChildFromFolder(parentForFileToDelete, deleteFileName);
        FileServiceArchiveBaseTest.assertNotNull((Object)fileToToDelete);
        this.fss.delete(fileToToDelete, this.mon);
        fileToToDelete = (IRemoteFile)this.getChildFromFolder(parentForFileToDelete, deleteFileName);
        FileServiceArchiveBaseTest.assertNull((Object)fileToToDelete);
    }

    public void testCopyBatchToTarArchiveFile() throws Exception {
        if (this.isTestDisabled()) {
            return;
        }
        this.createSourceTarFiles();
        this.createSourceFolders();
        String tarTargetFileName = this.tarSourceFileName1;
        IRemoteFile targetTarFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, tarTargetFileName);
        FileServiceArchiveBaseTest.assertNotNull((Object)targetTarFile);
        String sourceFolderName = this.folderToCopyName3;
        IRemoteFile sourceFolder = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceFolderName);
        FileServiceArchiveBaseTest.assertNotNull((Object)sourceFolder);
        IRemoteFile[] sourceFiles = new IRemoteFile[3];
        String childToCopyName1 = "aaaaaaaa";
        sourceFiles[0] = (IRemoteFile)this.getChildFromFolder(sourceFolder, childToCopyName1);
        String childToCopyName2 = "aaaab";
        sourceFiles[1] = (IRemoteFile)this.getChildFromFolder(sourceFolder, childToCopyName2);
        String childToCopyName3 = "epdcdump01.hex12a";
        sourceFiles[2] = (IRemoteFile)this.getChildFromFolder(sourceFolder, childToCopyName3);
        this.fss.copyBatch(sourceFiles, targetTarFile, this.mon);
        Object theCopiedChild = this.getChildFromFolder(targetTarFile, childToCopyName1);
        FileServiceArchiveBaseTest.assertNotNull((Object)theCopiedChild);
        String[] childrenToCheck1 = new String[]{"adsf", "eclipse-SDK-3.3M6-win32.zip", "epdcdump01.hex12", "epdcdump01.hex12aaaa"};
        int[] typesToCheck1 = new int[]{TYPE_FILE, TYPE_FILE, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)theCopiedChild, childrenToCheck1, typesToCheck1);
        theCopiedChild = this.getChildFromFolder(targetTarFile, childToCopyName2);
        FileServiceArchiveBaseTest.assertNotNull((Object)theCopiedChild);
        String[] childrenToCheck2 = new String[]{"features"};
        int[] typesToCheck2 = new int[]{TYPE_FOLDER};
        this.checkFolderContents((IRemoteFile)theCopiedChild, childrenToCheck2, typesToCheck2);
        theCopiedChild = this.getChildFromFolder(targetTarFile, childToCopyName3);
        FileServiceArchiveBaseTest.assertNotNull((Object)theCopiedChild);
        FileServiceArchiveBaseTest.assertTrue((!((IRemoteFile)theCopiedChild).isDirectory() ? 1 : 0) != 0);
    }
}

