/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.uda;

import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.useractions.UserActionsResources;
import org.eclipse.rse.internal.useractions.ui.uda.ISystemUDWorkWithDialog;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDActionSubsystem;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDBaseTreeView;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDTypeElement;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDTypeManager;
import org.eclipse.rse.internal.useractions.ui.uda.SystemXMLElementWrapper;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.swt.widgets.Composite;

public class SystemUDTypeTreeView
extends SystemUDBaseTreeView {
    public SystemUDTypeTreeView(Composite parent, ISystemUDWorkWithDialog editPane, ISubSystem ss, SystemUDActionSubsystem udaActionSubsystem) {
        super(parent, editPane, ss, udaActionSubsystem.getUDTypeManager());
    }

    public SystemUDTypeTreeView(Composite parent, ISystemUDWorkWithDialog editPane, ISubSystemConfiguration ssFactory, ISystemProfile profile) {
        super(parent, editPane, ssFactory, profile, null);
    }

    public SystemUDTypeManager getTypeManager() {
        return (SystemUDTypeManager)super.getDocumentManager();
    }

    public String getSelectedTypeName() {
        return super.getSelectedElementName();
    }

    public int getSelectedTypeDomain() {
        return super.getSelectedElementDomain();
    }

    protected SystemMessage getDeleteConfirmationMessage() {
        SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.useractions", "RSEG1231", 2, UserActionsResources.MSG_CONFIRM_DELETE_USERTYPE, UserActionsResources.MSG_CONFIRM_DELETE_USERTYPE_DETAILS);
        msg.setIndicator('Q');
        return msg;
    }

    protected int getResourceType() {
        return 256;
    }

    public void doRestore() {
        SystemXMLElementWrapper selectedElement = this.getSelectedElement();
        if (selectedElement == null || !(selectedElement instanceof SystemUDTypeElement)) {
            return;
        }
        SystemUDTypeElement type = (SystemUDTypeElement)selectedElement;
        boolean ok = this.getDocumentManager().getActionSubSystem().restoreDefaultType(type, type.getDomain(), type.getOriginalName());
        if (ok) {
            type.setUserChanged(false);
            this.getDocumentManager().saveUserData(this.profile);
            this.selectElement(selectedElement);
            String[] allProps = new String[]{"org.eclipse.jface.text", "org.eclipse.jface.image"};
            this.update(selectedElement, allProps);
        }
    }

    public void selectType(SystemUDTypeElement element) {
        super.selectElement(element);
    }

    public void refreshTypeParent(SystemUDTypeElement element) {
        super.refreshElementParent(element);
    }
}

